# 機能設計書 F022-タグ管理(販売)

## 概要

本ドキュメントは、販売モジュールにおけるタグ管理機能の設計を定義するものです。商品や顧客に対してラベル（タグ）を付与し、分類・検索を容易にする機能を提供します。

### 本機能の処理概要

販売業務で使用するタグの作成・編集・削除・一覧表示を行う機能です。タグには名前と色を設定でき、視覚的に識別しやすい分類が可能です。

**業務上の目的・背景**：販売業務において、商品や顧客を様々な観点で分類・グループ化する必要があります。タグを使用することで、「新商品」「セール対象」「VIP顧客」などの柔軟なラベリングが可能となり、マーケティングや顧客管理の効率化に寄与します。

**機能の利用シーン**：営業担当者が顧客にタグを付与して顧客セグメントを管理する場面、商品担当者が商品にタグを付与してキャンペーン対象商品を管理する場面で使用されます。

**主要な処理内容**：
1. タグの作成（名前・色の設定）
2. タグの編集（名前・色の変更）
3. タグの削除
4. タグ一覧の表示・検索・ソート
5. 一括削除

**関連システム・外部連携**：見積書・受注・顧客管理など、販売モジュール内の各リソースでタグを参照・付与可能です。

**権限による制御**：Filament Shieldによる標準的な権限制御が適用されます。タグの表示・作成・編集・削除それぞれに権限設定が可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SALES-005 | TagResource | 主画面 | タグ一覧・作成・編集・削除 |
| SCR-SALES-003 | CustomerResource | 参照画面 | 顧客へのタグ付与 |
| SCR-SALES-004 | ProductResource | 参照画面 | 商品へのタグ付与 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | タグ名 | 必須、最大255文字 |
| color | string | No | 色（16進カラーコード） | HEXカラー形式 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | タグID |
| name | string | タグ名 |
| color | string | 色（HEXカラーコード） |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- データベーステーブル（sales_tags）
- 画面表示（一覧・詳細画面）

## 処理フロー

### 処理シーケンス

```
1. タグ一覧表示
   └─ ListTagsページでタグ一覧を表示
2. タグ作成
   └─ モーダルフォーム表示 → 入力 → バリデーション → DB保存
3. タグ編集
   └─ 行内アクション → モーダルフォーム → 入力 → バリデーション → DB更新
4. タグ削除
   └─ 行内アクション → 確認 → DB削除
5. タグ詳細表示
   └─ 行内アクション → Infolistで詳細表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[タグ一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[フォームモーダル表示]
    C -->|編集| E[既存データ読込]
    C -->|削除| F[削除確認]
    C -->|表示| G[詳細Infolist表示]
    C -->|一括削除| H[複数選択確認]
    D --> I{バリデーション}
    E --> D
    I -->|OK| J[DBへ保存]
    I -->|NG| D
    F -->|確認| K[DB削除]
    F -->|キャンセル| B
    H -->|確認| L[一括DB削除]
    H -->|キャンセル| B
    J --> B
    K --> B
    L --> B
    G --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-022-01 | タグ名必須 | タグ名は必須入力 | 作成・編集時 |
| BR-022-02 | 色設定任意 | 色の設定は任意、未設定でも保存可能 | 作成・編集時 |
| BR-022-03 | 作成者記録 | タグ作成時に作成者IDを記録 | 作成時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | sales_tags | SELECT | タグ一覧取得（作成者情報含む） |
| 作成 | sales_tags | INSERT | 新規タグ登録 |
| 編集 | sales_tags | UPDATE | タグ情報更新 |
| 削除 | sales_tags | DELETE | タグ削除 |
| 一括削除 | sales_tags | DELETE | 複数タグ削除 |

### テーブル別操作詳細

#### sales_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, color, creator_id | - | createdBy関連も取得 |
| INSERT | name, color, creator_id | フォーム入力値、ログインユーザーID | - |
| UPDATE | name, color | フォーム入力値 | - |
| DELETE | - | id指定 | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E022-01 | バリデーションエラー | タグ名未入力 | エラーメッセージ表示 |
| E022-02 | バリデーションエラー | 不正なカラーコード | エラーメッセージ表示 |
| E022-03 | 削除エラー | 使用中のタグ削除時 | エラー通知表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 作成・編集・削除はそれぞれ個別のトランザクションで実行
- 一括削除は1つのトランザクションで実行

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・編集・削除：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- CSRF保護（Filament標準機能）
- XSS対策（タグ名のエスケープ処理）

## 備考

- タグの色はColorPickerコンポーネントで選択
- 一覧画面ではColorColumnで色を視覚的に表示
- 検索はタグ名で可能（searchable）
- ソートはタグ名で可能（sortable）
- 通知機能により、操作成功時にフィードバックを表示
