# 機能設計書 F023-活動タイプ管理(販売)

## 概要

本ドキュメントは、販売モジュールにおける活動タイプ管理機能の設計を定義するものです。営業活動の種類（電話、メール、訪問等）を定義・管理し、活動計画の標準化を支援します。

### 本機能の処理概要

販売業務で使用する活動タイプ（アクティビティタイプ）を管理する機能です。活動タイプを定義することで、営業活動の種類を標準化し、活動計画や活動履歴の管理を効率化します。

**業務上の目的・背景**：営業活動には電話連絡、メール送信、顧客訪問、オンラインミーティングなど様々な種類があります。活動タイプを定義・管理することで、営業プロセスの標準化、活動履歴の分析、チーム間での活動方針の統一が可能となります。

**機能の利用シーン**：営業マネージャーが新しい活動タイプを定義する場面、営業担当者が顧客に対する次のアクションを計画する際に活動タイプを選択する場面で使用されます。

**主要な処理内容**：
1. 活動タイプの作成（名前、アイコン、デフォルト期間等の設定）
2. 活動タイプの編集
3. 活動タイプの削除
4. 活動タイプ一覧の表示・検索

**関連システム・外部連携**：Supportプラグインの基盤ActivityTypeResourceを継承しており、共通の活動管理機能と連携します。Chatterパネルでの活動スケジュール機能と連携します。

**権限による制御**：Filament Shieldによる標準的な権限制御が適用されます。活動タイプの表示・作成・編集・削除それぞれに権限設定が可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SALES-007 | ActivityTypeResource | 主画面 | 活動タイプ一覧・作成・編集・削除 |
| SCR-SALES-001 | QuotationResource | 参照画面 | 見積書に対する活動スケジュール |
| SCR-SALES-002 | OrderResource | 参照画面 | 受注に対する活動スケジュール |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動タイプ名 | 必須、最大255文字 |
| icon | string | No | アイコン | 有効なアイコン名 |
| default_days | integer | No | デフォルト期間（日数） | 正の整数 |
| summary | string | No | 概要説明 | 最大500文字 |
| chaining_type | string | No | 連鎖タイプ | suggest/trigger |
| delay_count | integer | No | 遅延日数 | 正の整数 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動タイプID |
| name | string | 活動タイプ名 |
| icon | string | アイコン |
| default_days | integer | デフォルト期間 |
| summary | string | 概要説明 |
| chaining_type | string | 連鎖タイプ |
| delay_count | integer | 遅延日数 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- データベーステーブル（support_activity_types）
- 画面表示（一覧・詳細・編集画面）

## 処理フロー

### 処理シーケンス

```
1. 活動タイプ一覧表示
   └─ ListActivityTypesページで一覧を表示
2. 活動タイプ作成
   └─ CreateActivityTypeページ → フォーム入力 → バリデーション → DB保存
3. 活動タイプ編集
   └─ EditActivityTypeページ → 既存データ読込 → フォーム編集 → DB更新
4. 活動タイプ詳細表示
   └─ ViewActivityTypeページ → Infolistで詳細表示
5. 活動タイプ削除
   └─ 削除確認 → DB削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[活動タイプ一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[作成画面へ遷移]
    C -->|編集| E[編集画面へ遷移]
    C -->|表示| F[詳細画面へ遷移]
    C -->|削除| G[削除確認ダイアログ]
    D --> H[フォーム入力]
    E --> H
    H --> I{バリデーション}
    I -->|OK| J[DBへ保存]
    I -->|NG| H
    G -->|確認| K[DB削除]
    G -->|キャンセル| B
    J --> B
    K --> B
    F --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-023-01 | 活動タイプ名必須 | 活動タイプ名は必須入力 | 作成・編集時 |
| BR-023-02 | salesプラグイン限定 | plugin='sales'の活動タイプのみ表示 | クエリ時 |
| BR-023-03 | 連鎖タイプ | suggest（提案）またはtrigger（自動実行）を選択可能 | 作成・編集時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | support_activity_types | SELECT | plugin='sales'の活動タイプ取得 |
| 作成 | support_activity_types | INSERT | 新規活動タイプ登録 |
| 編集 | support_activity_types | UPDATE | 活動タイプ情報更新 |
| 削除 | support_activity_types | DELETE | 活動タイプ削除 |

### テーブル別操作詳細

#### support_activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE plugin = 'sales' | 販売用のみ |
| INSERT | name, icon, default_days, summary, plugin | フォーム入力値、plugin='sales' | - |
| UPDATE | name, icon, default_days, summary | フォーム入力値 | - |
| DELETE | - | id指定 | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E023-01 | バリデーションエラー | 活動タイプ名未入力 | エラーメッセージ表示 |
| E023-02 | 削除エラー | 使用中の活動タイプ削除 | エラー通知表示 |
| E023-03 | 整合性エラー | 無効な連鎖タイプ指定 | エラーメッセージ表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 作成・編集・削除はそれぞれ個別のトランザクションで実行

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・編集・削除：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- CSRF保護（Filament標準機能）
- 入力値のバリデーション

## 備考

- 本機能はWebkul\Support\Filament\Resources\ActivityTypeResourceを継承
- Webkul\Sale\Models\ActivityTypeモデルはWebkul\Support\Models\ActivityTypeを継承
- ナビゲーショングループは「Activities」
- 各ページ（List, Create, Edit, View）は個別のページクラスで実装
