# 機能設計書 F024-活動プラン管理(販売)

## 概要

本ドキュメントは、販売モジュールにおける活動プラン管理機能の設計を定義するものです。営業プロセスを自動化するための活動テンプレートを管理し、標準的な営業フローの定義を支援します。

### 本機能の処理概要

販売業務で使用する活動プラン（アクティビティプラン）を管理する機能です。活動プランは複数の活動テンプレートを含み、顧客へのフォローアップや営業プロセスを自動化・標準化するために使用されます。

**業務上の目的・背景**：営業活動において、新規顧客への初回コンタクトから成約までの一連のプロセスを標準化することが重要です。活動プランを定義することで、営業担当者は決められた手順に従って効率的に営業活動を進められ、抜け漏れの防止やベストプラクティスの共有が可能となります。

**機能の利用シーン**：営業マネージャーが新規顧客獲得のための標準的なフォローアッププランを作成する場面、新人営業担当者がプランに従って活動を実施する場面で使用されます。

**主要な処理内容**：
1. 活動プランの作成（名前、会社、有効/無効状態の設定）
2. 活動プランの編集
3. 活動プランの削除・復元
4. 活動テンプレートの関連付け管理
5. 活動プラン一覧の表示・検索・フィルタリング・グループ化

**関連システム・外部連携**：活動タイプ管理（F023）と連携し、プラン内で使用する活動タイプを参照します。会社マスタと連携し、会社別のプラン管理が可能です。

**権限による制御**：Filament Shieldによる標準的な権限制御が適用されます。ソフトデリート対応により、削除後の復元・完全削除も権限制御されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SALES-008 | ActivityPlanResource | 主画面 | 活動プラン一覧・作成・編集・削除 |
| SCR-SALES-007 | ActivityTypeResource | 参照画面 | 活動タイプの参照 |

## 機能種別

CRUD操作 / マスタ管理 / リレーション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動プラン名 | 必須、最大255文字 |
| company_id | integer | No | 会社ID | 存在する会社ID |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| plugin | string | - | プラグイン名 | 自動設定: 'sales' |
| creator_id | integer | - | 作成者ID | 自動設定: ログインユーザーID |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）
- 認証情報（ログインユーザー情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動プランID |
| name | string | 活動プラン名 |
| company_id | integer | 会社ID |
| is_active | boolean | 有効フラグ |
| plugin | string | プラグイン名 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（ソフトデリート） |

### 出力先

- データベーステーブル（support_activity_plans）
- 画面表示（一覧・詳細・編集画面）

## 処理フロー

### 処理シーケンス

```
1. 活動プラン一覧表示
   └─ ListActivityPlansページで一覧を表示
   └─ plugin='sales'でフィルタリング
2. 活動プラン作成
   └─ EmptyStateからCreateAction実行
   └─ フォーム入力 → バリデーション → plugin='sales'自動設定 → DB保存
3. 活動プラン編集
   └─ EditActivityPlanページ → 既存データ読込 → フォーム編集 → DB更新
4. 活動プラン詳細表示
   └─ ViewActivityPlanページ → Infolistで詳細表示
5. 活動テンプレート管理
   └─ ActivityTemplateRelationManagerで関連テンプレート管理
6. 活動プラン削除
   └─ DeleteAction → ソフトデリート
7. 活動プラン復元
   └─ RestoreAction → 削除取消
8. 活動プラン完全削除
   └─ ForceDeleteAction → 物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[活動プラン一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[フォーム入力]
    C -->|編集| E[編集画面へ遷移]
    C -->|表示| F[詳細画面へ遷移]
    C -->|削除| G[ソフトデリート]
    C -->|復元| H[削除取消]
    C -->|完全削除| I[物理削除確認]
    D --> J{バリデーション}
    E --> D
    J -->|OK| K[plugin=sales設定]
    J -->|NG| D
    K --> L[DBへ保存]
    G --> B
    H --> B
    I -->|確認| M[物理削除実行]
    I -->|キャンセル| B
    L --> B
    M --> B
    F --> N[ActivityTemplateRelationManager]
    N --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-024-01 | 活動プラン名必須 | 活動プラン名は必須入力 | 作成・編集時 |
| BR-024-02 | salesプラグイン限定 | plugin='sales'の活動プランのみ表示・操作 | 常時 |
| BR-024-03 | デフォルト有効 | 新規作成時はis_active=true | 作成時 |
| BR-024-04 | 会社デフォルト | 会社未指定時はログインユーザーのデフォルト会社を設定 | 作成時 |
| BR-024-05 | ソフトデリート | 削除時は論理削除、復元可能 | 削除時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | support_activity_plans | SELECT | plugin='sales'の活動プラン取得 |
| 作成 | support_activity_plans | INSERT | 新規活動プラン登録 |
| 編集 | support_activity_plans | UPDATE | 活動プラン情報更新 |
| 削除 | support_activity_plans | UPDATE | deleted_at設定（ソフトデリート） |
| 復元 | support_activity_plans | UPDATE | deleted_at=null設定 |
| 完全削除 | support_activity_plans | DELETE | 物理削除 |

### テーブル別操作詳細

#### support_activity_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE plugin = 'sales' | 販売用のみ |
| INSERT | name, company_id, is_active, plugin, creator_id | フォーム入力値、自動設定値 | - |
| UPDATE | name, company_id, is_active | フォーム入力値 | - |
| UPDATE | deleted_at | 現在日時 | ソフトデリート |
| UPDATE | deleted_at | null | 復元 |
| DELETE | - | id指定 | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E024-01 | バリデーションエラー | 活動プラン名未入力 | エラーメッセージ表示 |
| E024-02 | 参照エラー | 存在しない会社ID指定 | エラーメッセージ表示 |
| E024-03 | 削除エラー | 使用中のプラン完全削除 | エラー通知表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 作成・編集・削除はそれぞれ個別のトランザクションで実行
- 一括操作は1つのトランザクションで実行

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・編集・削除：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- CSRF保護（Filament標準機能）
- 入力値のバリデーション
- ソフトデリートによるデータ保護

## 備考

- Webkul\Sale\Models\ActivityPlanはWebkul\Support\Models\ActivityPlanを継承
- 一覧テーブルはカラム並び替え可能（reorderableColumns）
- グループ化機能対応（名前、作成者、ステータス、作成日、更新日）
- QueryBuilderによる高度なフィルタリング対応
- ActivityTemplateRelationManagerによる活動テンプレート管理
- 通知機能により各操作の成功/失敗をフィードバック
