# 機能設計書 F025-発注書管理

## 概要

本ドキュメントは、購買モジュールにおける発注書管理機能の設計を定義するものです。仕入先への発注書（Purchase Order）の作成・編集・承認・受領までの一連のプロセスを管理します。

### 本機能の処理概要

発注書の作成から受領までのライフサイクル全体を管理する機能です。見積依頼（RFQ）から発注への変換、発注確認、入荷管理、請求書処理との連携を含む包括的な購買管理を提供します。

**業務上の目的・背景**：企業の購買活動において、発注書は仕入先との正式な取引契約を示す重要な文書です。発注書管理を通じて、購買プロセスの可視化、コスト管理、仕入先との関係管理、在庫補充の効率化を実現します。

**機能の利用シーン**：購買担当者が仕入先に商品を発注する場面、発注内容の承認を行う場面、入荷を確認する場面、請求書と照合する場面で使用されます。

**主要な処理内容**：
1. 発注書の作成（仕入先、商品明細、数量、価格の設定）
2. 発注書の編集・更新
3. 発注書の承認・確認（状態遷移: Draft→Sent→Purchase→Done）
4. 発注書のキャンセル
5. 入荷管理との連携（ManageReceipts）
6. 請求書管理との連携（ManageBills）
7. 発注書の印刷・PDF出力
8. メール送信（仕入先への発注通知）

**関連システム・外部連携**：在庫管理モジュール（Inventories）と連携して入荷処理を管理、会計モジュール（Accounts/Invoices）と連携して請求書処理を管理します。

**権限による制御**：Filament Shieldによる権限制御に加え、発注書の状態に応じた編集制限が適用されます。例：確定済み発注書の仕入先・通貨変更不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-002 | PurchaseOrderResource | 主画面 | 発注書一覧・作成・編集・表示 |
| SCR-PURCH-001 | QuotationResource | 参照画面 | 見積依頼からの変換元 |
| SCR-PURCH-003 | VendorResource | 参照画面 | 仕入先情報の参照 |
| SCR-INV-001 | ReceiptResource | 結果表示画面 | 入荷処理の管理 |

## 機能種別

CRUD操作 / 状態管理 / ワークフロー / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | 仕入先ID | 存在するsupplierタイプのパートナー |
| partner_reference | string | No | 仕入先参照番号 | 最大255文字 |
| requisition_id | integer | No | 購買契約ID | 存在する購買契約ID |
| currency_id | integer | Yes | 通貨ID | 存在する通貨ID |
| ordered_at | datetime | Yes | 発注日 | 有効な日時 |
| planned_at | datetime | No | 予定到着日 | 有効な日時 |
| user_id | integer | No | 購買担当者ID | 存在するユーザーID |
| company_id | integer | Yes | 会社ID | 存在する会社ID |
| payment_term_id | integer | No | 支払条件ID | 存在する支払条件ID |
| incoterm_id | integer | No | インコタームID | 存在するインコタームID |
| description | text | No | 備考・条件 | - |

### 明細行入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| product_id | integer | Yes | 商品ID | 存在する商品ID |
| product_qty | decimal | Yes | 数量 | 正の数値、最大99999999999 |
| price_unit | decimal | Yes | 単価 | 0以上、最大99999999999 |
| uom_id | integer | Yes(設定時) | 単位ID | UOM有効時は必須 |
| taxes | array | No | 税金ID配列 | 存在する購買税ID |
| discount | decimal | No | 割引率 | 0-100 |
| planned_at | datetime | Yes | 予定到着日 | 有効な日時 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）
- 購買契約からの商品情報自動取得
- 仕入先マスタからの支払条件自動設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 発注書ID |
| name | string | 発注書番号（PO/{id}形式） |
| state | enum | 状態（draft/sent/purchase/done/canceled） |
| invoice_status | enum | 請求状態 |
| receipt_status | enum | 入荷状態 |
| untaxed_amount | decimal | 税抜金額 |
| tax_amount | decimal | 税額 |
| total_amount | decimal | 合計金額 |
| lines | collection | 発注明細 |

### 出力先

- データベーステーブル（purchases_orders, purchases_order_lines）
- 画面表示（一覧・詳細・編集画面）
- PDF出力（印刷用発注書）
- メール送信（仕入先への通知）

## 処理フロー

### 処理シーケンス

```
1. 発注書作成
   └─ CreateOrderページ → フォーム入力 → 明細追加 → 金額計算 → DB保存
   └─ 状態: draft
2. 発注書送信
   └─ SendEmailAction → メール送信 → 状態: sent
3. 発注確認
   └─ ConfirmAction → 状態: purchase → 承認日時記録
4. 入荷管理
   └─ ManageReceiptsページ → 入荷処理連携
5. 請求書管理
   └─ ManageBillsページ → 請求書処理連携 → CreateBillAction
6. 発注完了
   └─ 全数受領・請求完了 → 状態: done
7. キャンセル
   └─ CancelAction → 状態: canceled
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|新規作成| C[発注書フォーム入力]
    B -->|見積からの変換| D[RFQデータ読込]
    D --> C
    C --> E[明細行追加]
    E --> F[金額自動計算]
    F --> G[保存 state=draft]
    G --> H{次のアクション}
    H -->|送信| I[メール送信]
    I --> J[state=sent]
    J --> H
    H -->|確認| K[ConfirmAction]
    K --> L[state=purchase]
    L --> M{入荷・請求}
    M -->|入荷管理| N[ManageReceipts]
    M -->|請求書作成| O[CreateBill]
    N --> P{全数受領?}
    O --> Q{全額請求?}
    P -->|Yes| R[入荷完了]
    Q -->|Yes| S[請求完了]
    R --> T{両方完了?}
    S --> T
    T -->|Yes| U[state=done]
    T -->|No| M
    H -->|キャンセル| V[state=canceled]
    U --> W[終了]
    V --> W
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-025-01 | 発注番号自動採番 | 発注書作成時に「PO/{id}」形式で自動採番 | 作成時 |
| BR-025-02 | 仕入先必須 | 発注書には仕入先の指定が必須 | 作成・編集時 |
| BR-025-03 | 状態遷移制限 | draft→sent→purchase→doneの順序で遷移 | 状態変更時 |
| BR-025-04 | 確定後編集制限 | purchase/done状態では仕入先・通貨変更不可 | 編集時 |
| BR-025-05 | 完了状態削除不可 | state=doneの発注書は削除不可 | 削除時 |
| BR-025-06 | 仕入先価格自動適用 | 仕入先別商品価格が設定されている場合は自動適用 | 商品選択時 |
| BR-025-07 | 購買契約連携 | 購買契約選択時は契約内商品を自動展開 | 契約選択時 |

### 計算ロジック

```
【明細行計算】
1. 小計 = 単価 × 数量
2. 割引適用 = 小計 × (1 - 割引率/100)
3. 税額計算 = TaxFacade.collect(税ID配列, 割引適用後金額, 数量)
4. price_subtotal = 税抜金額
5. price_tax = 税額
6. price_total = 税抜金額 + 税額

【発注書合計計算】
1. untaxed_amount = SUM(各明細のprice_subtotal)
2. tax_amount = SUM(各明細のprice_tax)
3. total_amount = untaxed_amount + tax_amount

【仕入先価格取得ロジック】
1. 商品の仕入先情報から、指定仕入先・通貨・最小数量条件に合致する価格を取得
2. 該当なしの場合は商品のコスト価格を使用

【最適パッケージング選択】
1. 商品のパッケージングを数量降順で取得
2. 商品数量を割り切れる最大パッケージングを選択
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | purchases_orders | SELECT | 発注書一覧取得（関連情報含む） |
| 作成 | purchases_orders | INSERT | 新規発注書登録 |
| 作成 | purchases_order_lines | INSERT | 発注明細登録 |
| 編集 | purchases_orders | UPDATE | 発注書情報更新 |
| 編集 | purchases_order_lines | UPDATE/INSERT/DELETE | 明細更新 |
| 削除 | purchases_orders | DELETE | 発注書削除 |
| 状態変更 | purchases_orders | UPDATE | state更新 |

### テーブル別操作詳細

#### purchases_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name, partner_id, currency_id, state, ... | フォーム入力値、自動計算値 | name=PO/{id} |
| UPDATE | state | draft/sent/purchase/done/canceled | 状態遷移 |
| UPDATE | approved_at | 現在日時 | 確認時 |
| UPDATE | untaxed_amount, tax_amount, total_amount | 計算値 | 金額更新時 |

#### purchases_order_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | product_id, product_qty, price_unit, ... | フォーム入力値、計算値 | - |
| UPDATE | qty_received | 受領数量 | 入荷時 |
| UPDATE | qty_invoiced | 請求数量 | 請求時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E025-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E025-02 | 状態遷移エラー | 無効な状態遷移 | エラー通知表示 |
| E025-03 | 削除エラー | 完了状態の発注書削除 | エラー通知表示 |
| E025-04 | 外部キー制約エラー | 関連データ存在時の削除 | エラー通知表示 |

### リトライ仕様

- メール送信失敗時：手動で再送信可能

## トランザクション仕様

- 発注書と明細は同一トランザクションで処理
- 状態遷移は個別トランザクション
- 入荷・請求書処理は各モジュールのトランザクションで実行

## パフォーマンス要件

- 一覧表示：2秒以内
- 作成・編集：3秒以内
- PDF生成：5秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- 状態に応じた編集制限
- CSRF保護（Filament標準機能）
- 監査ログ（HasLogActivity trait）

## 備考

- OrderResourceはQuotationResourceの基底クラスとして使用
- HasCustomFieldsトレイトによるカスタムフィールド対応
- HasChatter, HasLogActivityによる活動履歴・監査ログ対応
- Summaryコンポーネントで金額サマリーをリアルタイム表示
- ProductSettings設定によりUOM・パッケージング機能の有効/無効を制御
