# 機能設計書 F026-見積依頼(RFQ)管理

## 概要

本ドキュメントは、購買モジュールにおける見積依頼（RFQ: Request for Quotation）管理機能の設計を定義するものです。仕入先への見積依頼の作成・送信・回答受領までのプロセスを管理します。

### 本機能の処理概要

仕入先に対する見積依頼の作成から回答受領、発注への変換までを管理する機能です。複数の仕入先に見積依頼を送信し、回答を比較検討した上で発注先を決定するプロセスを支援します。

**業務上の目的・背景**：購買業務において、最適な仕入条件を得るために複数の仕入先から見積りを取得することが一般的です。見積依頼管理により、依頼プロセスの効率化、見積比較の容易化、交渉履歴の記録が可能となります。

**機能の利用シーン**：購買担当者が新規商品の仕入先を探す場面、既存商品の価格見直しを行う場面、大量発注前に複数仕入先から見積りを取得する場面で使用されます。

**主要な処理内容**：
1. 見積依頼の作成（仕入先、商品明細、数量の設定）
2. 見積依頼の編集・更新
3. 見積依頼の送信（メール送信）
4. 見積回答の受領・価格入力
5. 発注への変換（Confirm処理）
6. 入荷管理・請求書管理との連携

**関連システム・外部連携**：発注書管理（F025）と密接に連携しており、QuotationResourceはOrderResourceを継承しています。見積依頼確認後は発注書として扱われます。

**権限による制御**：Filament Shieldによる権限制御が適用されます。見積依頼の状態に応じた編集制限も適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-001 | QuotationResource | 主画面 | 見積依頼一覧・作成・編集・表示 |
| SCR-PURCH-002 | PurchaseOrderResource | 結果表示画面 | 確認後の発注書管理 |
| SCR-PURCH-003 | VendorResource | 参照画面 | 仕入先情報の参照 |

## 機能種別

CRUD操作 / 状態管理 / ワークフロー / メール送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | 仕入先ID | 存在するsupplierタイプのパートナー |
| partner_reference | string | No | 仕入先参照番号 | 最大255文字 |
| currency_id | integer | Yes | 通貨ID | 存在する通貨ID |
| ordered_at | datetime | Yes | 依頼日 | 有効な日時 |
| planned_at | datetime | No | 希望納期 | 有効な日時 |
| user_id | integer | No | 購買担当者ID | 存在するユーザーID |
| company_id | integer | Yes | 会社ID | 存在する会社ID |
| description | text | No | 備考・条件 | - |

### 明細行入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| product_id | integer | Yes | 商品ID | 存在する商品ID |
| product_qty | decimal | Yes | 数量 | 正の数値 |
| price_unit | decimal | No | 単価（見積回答後） | 0以上 |
| uom_id | integer | Yes(設定時) | 単位ID | UOM有効時は必須 |
| planned_at | datetime | Yes | 希望納期 | 有効な日時 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）
- 仕入先マスタからの情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 見積依頼ID |
| name | string | 見積依頼番号（PO/{id}形式） |
| state | enum | 状態（draft/sent/purchase） |
| partner_id | integer | 仕入先ID |
| currency_id | integer | 通貨ID |
| untaxed_amount | decimal | 税抜金額 |
| tax_amount | decimal | 税額 |
| total_amount | decimal | 合計金額 |
| lines | collection | 見積依頼明細 |

### 出力先

- データベーステーブル（purchases_orders）
- 画面表示（一覧・詳細・編集画面）
- メール送信（仕入先への見積依頼）
- PDF出力（印刷用見積依頼書）

## 処理フロー

### 処理シーケンス

```
1. 見積依頼作成
   └─ CreateQuotationページ → フォーム入力 → 明細追加 → DB保存
   └─ 状態: draft
2. 見積依頼送信
   └─ SendEmailAction → メール送信 → 状態: sent
3. 見積回答入力
   └─ EditQuotationページ → 単価入力 → 金額計算 → DB更新
4. 発注確認
   └─ ConfirmAction → 状態: purchase → 発注書として扱い
5. 入荷管理
   └─ ManageReceiptsページ → 入荷処理連携
6. 請求書管理
   └─ ManageBillsページ → 請求書処理連携
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[見積依頼作成]
    B --> C[仕入先・商品明細入力]
    C --> D[保存 state=draft]
    D --> E{次のアクション}
    E -->|送信| F[メール送信]
    F --> G[state=sent]
    G --> H[仕入先からの回答待ち]
    H --> I[回答受領・価格入力]
    I --> J{発注決定?}
    J -->|Yes| K[ConfirmAction]
    K --> L[state=purchase]
    L --> M[発注書として管理]
    J -->|No| N[キャンセルまたは再見積]
    E -->|編集| O[内容修正]
    O --> D
    E -->|印刷| P[PDF出力]
    P --> E
    M --> Q[終了]
    N --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-026-01 | 見積番号自動採番 | 「PO/{id}」形式で自動採番（発注書と共通） | 作成時 |
| BR-026-02 | 仕入先必須 | 見積依頼には仕入先の指定が必須 | 作成時 |
| BR-026-03 | draft→sent遷移 | 送信によりsent状態に遷移 | 送信時 |
| BR-026-04 | sent→purchase遷移 | 確認によりpurchase状態に遷移し発注書に | 確認時 |
| BR-026-05 | 送信後仕入先変更不可 | sent状態以降は仕入先変更不可 | 編集時 |

### 計算ロジック

発注書管理（F025）と同一の計算ロジックを使用

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | purchases_orders | SELECT | state=draft/sent の見積依頼取得 |
| 作成 | purchases_orders | INSERT | 新規見積依頼登録 |
| 作成 | purchases_order_lines | INSERT | 見積明細登録 |
| 編集 | purchases_orders | UPDATE | 見積依頼情報更新 |
| 状態変更 | purchases_orders | UPDATE | state更新 |

### テーブル別操作詳細

#### purchases_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE state IN ('draft', 'sent') | 見積依頼のみ |
| INSERT | name, partner_id, currency_id, state='draft', ... | フォーム入力値 | - |
| UPDATE | state | 'sent' | 送信時 |
| UPDATE | state | 'purchase' | 確認時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E026-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E026-02 | メール送信エラー | メール送信失敗 | エラー通知、再送信可能 |
| E026-03 | 状態遷移エラー | 無効な状態遷移 | エラー通知表示 |

### リトライ仕様

- メール送信失敗時：手動で再送信可能

## トランザクション仕様

- 見積依頼と明細は同一トランザクションで処理
- 状態遷移は個別トランザクション

## パフォーマンス要件

- 一覧表示：2秒以内
- 作成・編集：3秒以内
- メール送信：10秒以内（外部依存）

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- 状態に応じた編集制限
- CSRF保護（Filament標準機能）

## 備考

- QuotationResourceはOrderResourceを継承
- QuotationモデルはOrderモデルを継承（テーブル共有）
- 一覧ではListQuotationsページで表示（state=draft/sentのみ）
- 確認後（state=purchase）はPurchaseOrderResourceで管理
- サブナビゲーション: View → Edit → Bills → Receipts
