# 機能設計書 F027-仕入先管理

## 概要

本ドキュメントは、購買モジュールにおける仕入先管理機能の設計を定義するものです。仕入先情報、住所、連絡先、銀行口座、価格リストなどを一元管理します。

### 本機能の処理概要

仕入先（ベンダー）の基本情報から取引履歴まで包括的に管理する機能です。仕入先別の価格設定、支払条件、連絡先情報を管理し、購買業務の効率化を支援します。

**業務上の目的・背景**：購買業務において、仕入先との関係管理は重要な業務です。仕入先情報を一元管理することで、適切な仕入先選定、価格交渉、支払管理、コミュニケーションの効率化が可能となります。

**機能の利用シーン**：購買担当者が新規仕入先を登録する場面、仕入先の価格情報を更新する場面、仕入先との取引履歴を確認する場面、請求書と仕入先情報を照合する場面で使用されます。

**主要な処理内容**：
1. 仕入先情報の作成・編集・削除
2. 住所情報の管理（複数住所対応）
3. 連絡先情報の管理（複数担当者対応）
4. 銀行口座情報の管理
5. 購買履歴の参照
6. 請求書（Bills）の参照

**関連システム・外部連携**：Invoice/VendorResourceを継承しており、請求書モジュールの仕入先管理機能を拡張しています。Partner/PartnerResourceの機能も活用しています。

**権限による制御**：Filament Shieldによる権限制御が適用されます。HasCustomFieldsによるカスタムフィールド対応も可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-003 | VendorResource | 主画面 | 仕入先一覧・作成・編集・表示 |
| SCR-PURCH-001 | QuotationResource | 参照画面 | 見積依頼での仕入先選択 |
| SCR-PURCH-002 | PurchaseOrderResource | 参照画面 | 発注書での仕入先選択 |

## 機能種別

CRUD操作 / マスタ管理 / リレーション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 仕入先名 | 必須、最大255文字 |
| email | string | No | メールアドレス | メール形式 |
| phone | string | No | 電話番号 | 電話番号形式 |
| mobile | string | No | 携帯電話番号 | 電話番号形式 |
| website | string | No | ウェブサイト | URL形式 |
| vat | string | No | 税番号 | - |
| company_id | integer | No | 所属会社ID | 存在する会社ID |
| currency_id | integer | No | 通貨ID | 存在する通貨ID |
| property_supplier_payment_term_id | integer | No | 支払条件ID | 存在する支払条件ID |
| sub_type | string | - | パートナータイプ | 'supplier'固定 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 仕入先ID |
| name | string | 仕入先名 |
| email | string | メールアドレス |
| phone | string | 電話番号 |
| mobile | string | 携帯電話番号 |
| website | string | ウェブサイト |
| vat | string | 税番号 |
| sub_type | string | パートナータイプ（supplier） |
| addresses | collection | 住所一覧 |
| contacts | collection | 連絡先一覧 |
| orders | collection | 発注履歴 |

### 出力先

- データベーステーブル（accounts_partners）
- 画面表示（一覧・詳細・編集画面）

## 処理フロー

### 処理シーケンス

```
1. 仕入先一覧表示
   └─ ListVendorsページで仕入先一覧を表示
   └─ sub_type='supplier'でフィルタリング
2. 仕入先作成
   └─ CreateVendorページ → フォーム入力 → バリデーション → DB保存
3. 仕入先編集
   └─ EditVendorページ → 既存データ読込 → フォーム編集 → DB更新
4. 仕入先詳細表示
   └─ ViewVendorページ → 基本情報・関連情報表示
5. 連絡先管理
   └─ ManageContactsページ → ContactsRelationManager
6. 住所管理
   └─ ManageAddressesページ → AddressesRelationManager
7. 請求書参照
   └─ ManageBillsページ → 仕入先請求書一覧
8. 購買履歴参照
   └─ ManagePurchasesページ → 発注履歴一覧
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[仕入先一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[作成画面へ遷移]
    C -->|編集| E[編集画面へ遷移]
    C -->|表示| F[詳細画面へ遷移]
    D --> G[フォーム入力]
    E --> G
    G --> H{バリデーション}
    H -->|OK| I[DBへ保存]
    H -->|NG| G
    I --> B
    F --> J{関連情報参照}
    J -->|連絡先| K[ManageContacts]
    J -->|住所| L[ManageAddresses]
    J -->|請求書| M[ManageBills]
    J -->|購買履歴| N[ManagePurchases]
    K --> F
    L --> F
    M --> F
    N --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-027-01 | 仕入先名必須 | 仕入先名は必須入力 | 作成・編集時 |
| BR-027-02 | supplier固定 | sub_type='supplier'として保存 | 作成時 |
| BR-027-03 | 複数住所対応 | 1仕入先に複数住所を登録可能 | 住所管理時 |
| BR-027-04 | 複数連絡先対応 | 1仕入先に複数連絡先を登録可能 | 連絡先管理時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | accounts_partners | SELECT | sub_type='supplier'の仕入先取得 |
| 作成 | accounts_partners | INSERT | 新規仕入先登録 |
| 編集 | accounts_partners | UPDATE | 仕入先情報更新 |
| 削除 | accounts_partners | DELETE/SoftDelete | 仕入先削除 |
| 住所管理 | partners_addresses | CRUD | 住所の管理 |
| 連絡先管理 | partners_contacts | CRUD | 連絡先の管理 |

### テーブル別操作詳細

#### accounts_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE sub_type = 'supplier' | 仕入先のみ |
| INSERT | name, email, phone, sub_type='supplier', ... | フォーム入力値 | - |
| UPDATE | name, email, phone, ... | フォーム入力値 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E027-01 | バリデーションエラー | 仕入先名未入力 | エラーメッセージ表示 |
| E027-02 | バリデーションエラー | 不正なメール形式 | エラーメッセージ表示 |
| E027-03 | 削除エラー | 取引履歴がある仕入先削除 | エラー通知表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 仕入先情報の更新は個別トランザクション
- 関連情報（住所・連絡先）はRelationManagerで個別管理

## パフォーマンス要件

- 一覧表示：2秒以内
- 作成・編集：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- HasCustomFieldsによるカスタムフィールドの権限制御
- CSRF保護（Filament標準機能）

## 備考

- VendorResourceはInvoice\VendorResourceを継承
- Purchase\Models\PartnerはAccount\Models\Partnerを継承
- ordersリレーションで発注履歴を参照可能
- accountMovesリレーションで会計移動を参照可能
- RelationGroup機能で連絡先・住所を関連グループ化
- サブナビゲーション: View → Edit → Contacts → Addresses → Bills → Purchases
