# 機能設計書 F028-商品管理(購買)

## 概要

本ドキュメントは、購買モジュールにおける商品管理機能の設計を定義するものです。購買用商品の管理、仕入先別情報（価格・リードタイム）の管理、バリエーション・属性の管理を行います。

### 本機能の処理概要

購買業務で使用する商品情報を管理する機能です。商品の基本情報に加え、仕入先別の価格情報、リードタイム、バリエーション、属性を管理し、最適な購買判断を支援します。

**業務上の目的・背景**：購買業務において、商品ごとの仕入先情報、価格履歴、リードタイムは重要な判断材料です。商品管理により、コスト最適化、納期管理、仕入先比較が可能となります。

**機能の利用シーン**：購買担当者が商品の仕入先別価格を確認する場面、新規商品を購買マスタに登録する場面、仕入先ごとのリードタイムを設定する場面で使用されます。

**主要な処理内容**：
1. 商品情報の作成・編集・削除
2. 仕入先情報の管理（ManageVendors）
3. 商品バリエーションの管理（ManageVariants）
4. 商品属性の管理（ManageAttributes）
5. 商品一覧の表示・検索・フィルタリング

**関連システム・外部連携**：Product/ProductResourceを基底クラスとして継承し、商品管理の共通機能を活用しています。Invoice/ProductResourceも継承チェーンに含まれます。

**権限による制御**：Filament Shieldによる権限制御が適用されます。HasCustomFieldsによるカスタムフィールド対応も可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-005 | ProductResource | 主画面 | 商品一覧・作成・編集・表示 |
| SCR-PURCH-001 | QuotationResource | 参照画面 | 見積依頼での商品選択 |
| SCR-PURCH-002 | PurchaseOrderResource | 参照画面 | 発注書での商品選択 |

## 機能種別

CRUD操作 / マスタ管理 / リレーション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 商品名 | 必須、最大255文字 |
| type | enum | Yes | 商品タイプ | goods/service/consumable |
| default_code | string | No | 商品コード | 最大255文字 |
| barcode | string | No | バーコード | 最大255文字 |
| description | text | No | 説明 | - |
| cost | decimal | No | 原価 | 0以上 |
| price | decimal | No | 販売価格 | 0以上 |
| uom_id | integer | No | 単位ID | 存在する単位ID |
| category_id | integer | No | カテゴリID | 存在するカテゴリID |

### 仕入先情報入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | 仕入先ID | 存在する仕入先ID |
| price | decimal | Yes | 仕入価格 | 0以上 |
| min_qty | decimal | No | 最小発注数量 | 0以上 |
| currency_id | integer | No | 通貨ID | 存在する通貨ID |
| delay | integer | No | リードタイム（日） | 0以上 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 商品ID |
| name | string | 商品名 |
| type | enum | 商品タイプ |
| default_code | string | 商品コード |
| cost | decimal | 原価 |
| price | decimal | 販売価格 |
| supplierInformation | collection | 仕入先情報一覧 |
| variants | collection | バリエーション一覧 |
| attributes | collection | 属性一覧 |

### 出力先

- データベーステーブル（products_products）
- 画面表示（一覧・詳細・編集画面）

## 処理フロー

### 処理シーケンス

```
1. 商品一覧表示
   └─ ListProductsページで商品一覧を表示
2. 商品作成
   └─ CreateProductページ → フォーム入力 → バリデーション → DB保存
3. 商品編集
   └─ EditProductページ → 既存データ読込 → フォーム編集 → DB更新
4. 商品詳細表示
   └─ ViewProductページ → 基本情報・関連情報表示
5. 仕入先管理
   └─ ManageVendorsページ → 仕入先別価格・リードタイム管理
6. バリエーション管理
   └─ ManageVariantsページ → 商品バリエーション管理
7. 属性管理
   └─ ManageAttributesページ → 商品属性管理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[商品一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[作成画面へ遷移]
    C -->|編集| E[編集画面へ遷移]
    C -->|表示| F[詳細画面へ遷移]
    D --> G[フォーム入力]
    E --> G
    G --> H{バリデーション}
    H -->|OK| I[DBへ保存]
    H -->|NG| G
    I --> B
    F --> J{関連情報参照}
    J -->|仕入先| K[ManageVendors]
    J -->|バリエーション| L[ManageVariants]
    J -->|属性| M[ManageAttributes]
    K --> F
    L --> F
    M --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-028-01 | 商品名必須 | 商品名は必須入力 | 作成・編集時 |
| BR-028-02 | タイプ必須 | 商品タイプは必須選択 | 作成時 |
| BR-028-03 | 仕入先価格優先 | 発注時は仕入先別価格を優先使用 | 発注時 |
| BR-028-04 | 最小数量チェック | 仕入先の最小発注数量を考慮 | 発注時 |
| BR-028-05 | configurable除外 | is_configurable商品は発注対象外 | 発注時 |

### 計算ロジック

```
【仕入先価格取得ロジック】
1. 商品のsupplierInformationから指定仕入先の価格を取得
2. 通貨・最小数量条件でフィルタリング
3. sortの降順で優先順位決定
4. 該当なしの場合はcost価格を使用
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | products_products | SELECT | 商品一覧取得 |
| 作成 | products_products | INSERT | 新規商品登録 |
| 編集 | products_products | UPDATE | 商品情報更新 |
| 削除 | products_products | DELETE/SoftDelete | 商品削除 |
| 仕入先管理 | products_product_suppliers | CRUD | 仕入先別情報管理 |

### テーブル別操作詳細

#### products_products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | 商品一覧 |
| INSERT | name, type, cost, price, ... | フォーム入力値 | - |
| UPDATE | name, type, cost, price, ... | フォーム入力値 | - |

#### products_product_suppliers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE product_id = ? | 仕入先情報 |
| INSERT | product_id, partner_id, price, min_qty, delay, ... | フォーム入力値 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E028-01 | バリデーションエラー | 商品名未入力 | エラーメッセージ表示 |
| E028-02 | バリデーションエラー | 商品タイプ未選択 | エラーメッセージ表示 |
| E028-03 | 削除エラー | 使用中の商品削除 | エラー通知表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 商品情報の更新は個別トランザクション
- 関連情報（仕入先・バリエーション・属性）はRelationManagerで個別管理

## パフォーマンス要件

- 一覧表示：2秒以内
- 作成・編集：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- HasCustomFieldsによるカスタムフィールドの権限制御
- CSRF保護（Filament標準機能）

## 備考

- ProductResourceはBaseProductResourceを継承
- BaseProductResourceはProduct\ProductResourceを継承
- Purchase\Models\ProductはInvoice\Models\Productを継承
- supplierInformationリレーションでis_configurableの場合はvariants含む
- responsibleフィルタはテーブルから除外（購買では不要）
- サブナビゲーション: View → Edit → Attributes → Variants → Vendors
