# 機能設計書: ロール管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F003 |
| 機能名 | ロール管理 |
| 機能概要 | ユーザーに割り当てるロール（役割）の作成・編集・削除、およびパーミッション（権限）の設定を行う |
| 関連画面 | SCR-ROLE-001（ロール一覧）、SCR-ROLE-002（ロール作成）、SCR-ROLE-003（ロール詳細）、SCR-ROLE-004（ロール編集） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

ロール管理機能は、Spatie Laravel Permissionパッケージを基盤として、システム内のアクセス権限を体系的に管理する。ロールは複数のパーミッションをグループ化したもので、ユーザーに割り当てることでアクセス制御を実現する。

#### 主な機能
1. **ロール一覧表示**: 登録済みロールをテーブル形式で表示
2. **ロール作成**: 新規ロールの登録とパーミッション割り当て
3. **ロール編集**: 既存ロールの情報更新とパーミッション変更
4. **ロール削除**: ロールの削除（使用中の場合は警告）
5. **パーミッション割り当て**: ロールへのパーミッション一括設定

### 2.2 処理フロー

#### ロール作成フロー
```
[開始]
   |
   v
[ロール作成画面表示]
   |
   v
[ロール名入力]
   |
   v
[パーミッション選択（チェックボックス）]
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フォーム入力]
   |
   v (OK)
[rolesテーブルにレコード作成]
   |
   v
[role_has_permissionsに関係レコード作成]
   |
   v
[ロール詳細画面へリダイレクト]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| name | string | YES | max:255, unique:roles | ロール名 |
| guard_name | string | NO | - | ガード名（デフォルト: web） |
| permissions | array | NO | exists:permissions,id | 割り当てパーミッションID配列 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | ロールID |
| name | string | ロール名 |
| guard_name | string | ガード名 |
| permissions | array | 割り当て済みパーミッション一覧 |
| users_count | integer | ロールに紐付くユーザー数 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | ロール名一意性 | ロール名は同一guard_name内で一意である必要がある |
| BR-002 | デフォルトロール保護 | システムデフォルトロール（admin等）は削除不可 |
| BR-003 | ユーザー紐付き確認 | ユーザーが紐付いているロールの削除時は確認を要求 |
| BR-004 | パーミッション継承 | ロールに割り当てられたパーミッションはユーザーに継承される |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| roles | ロール情報管理 | SELECT, INSERT, UPDATE, DELETE |
| permissions | パーミッション情報参照 | SELECT |
| role_has_permissions | ロール-パーミッション関係 | SELECT, INSERT, DELETE |
| model_has_roles | ユーザー-ロール関係参照 | SELECT |

### 4.2 テーブル定義（roles）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| name | varchar(255) | NO | - | ロール名 |
| guard_name | varchar(255) | NO | 'web' | ガード名 |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

### 4.3 テーブル定義（role_has_permissions）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| permission_id | bigint | NO | - | パーミッションID（FK） |
| role_id | bigint | NO | - | ロールID（FK） |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| RoleResource | plugins/webkul/security/src/Filament/Resources/RoleResource.php | ロール管理Filamentリソース |
| Role | Spatie\Permission\Models\Role | ロールモデル（Spatieパッケージ） |
| Permission | Spatie\Permission\Models\Permission | パーミッションモデル |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| spatie/laravel-permission | 必須（RBAC基盤） |
| filament/filament | 必須（管理画面UI） |
| webkul/security | 必須（セキュリティ基盤） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_role | ロール一覧・詳細の閲覧 |
| view_any_role | 全ロールの閲覧 |
| create_role | ロール作成 |
| update_role | ロール更新 |
| delete_role | ロール削除 |

### 6.2 セキュリティ考慮事項

- ロール管理は管理者権限を持つユーザーのみアクセス可能
- パーミッション変更はリアルタイムで反映される（キャッシュクリア）
- 監査ログへの操作記録

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内 |
| ロール作成応答時間 | 500ms以内 |
| パーミッションキャッシュ更新 | 即座に反映 |

### 7.2 可用性

- パーミッション変更後のキャッシュクリアを自動実行

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| ROLE-001 | ロール名重複 | バリデーションエラー表示 |
| ROLE-002 | 削除不可ロール | エラー通知表示 |
| ROLE-003 | パーミッション割り当て失敗 | ロールバック、エラーログ |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | ロール一覧が正しく表示されること |
| T-002 | ロール作成 | 必須項目入力で正常に作成できること |
| T-003 | パーミッション設定 | パーミッションが正しく割り当てられること |
| T-004 | ロール更新 | ロール情報とパーミッションが更新されること |
| T-005 | ロール削除 | ロールが削除されること |
| T-006 | 権限継承確認 | ロールのパーミッションがユーザーに継承されること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
