# 機能設計書 F030-商品カテゴリ管理(購買)

## 概要

本ドキュメントは、購買モジュールにおける商品カテゴリ管理機能の設計を定義するものです。購買用商品のカテゴリ（分類）を階層的に管理し、購買分類の体系化を支援します。

### 本機能の処理概要

購買業務で使用する商品カテゴリを管理する機能です。カテゴリを階層構造で定義し、商品の分類・検索・分析を容易にします。

**業務上の目的・背景**：購買業務において、商品を適切に分類することは、購買分析、予算管理、仕入先選定の効率化に重要です。カテゴリ管理により、支出分析、カテゴリ別の購買戦略策定が可能となります。

**機能の利用シーン**：購買担当者が新しい商品カテゴリを作成する場面、既存カテゴリの階層を整理する場面、カテゴリ内の商品を確認する場面で使用されます。

**主要な処理内容**：
1. 商品カテゴリの作成・編集・削除
2. カテゴリの階層構造管理（親子関係）
3. カテゴリ内商品の管理（ManageProducts）
4. カテゴリ一覧の表示・検索

**関連システム・外部連携**：Product/CategoryResourceを基底クラスとして継承し、商品カテゴリ管理の共通機能を活用しています。

**権限による制御**：Filament Shieldによる権限制御が適用されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-007 | ProductCategoryResource | 主画面 | カテゴリ一覧・作成・編集・表示 |
| SCR-PURCH-005 | ProductResource | 参照画面 | 商品でのカテゴリ選択 |

## 機能種別

CRUD操作 / マスタ管理 / 階層管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 必須、最大255文字 |
| parent_id | integer | No | 親カテゴリID | 存在するカテゴリID |
| complete_name | string | - | 完全パス名 | 自動生成 |
| parent_path | string | - | 親パス | 自動生成 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | カテゴリID |
| name | string | カテゴリ名 |
| parent_id | integer | 親カテゴリID |
| complete_name | string | 完全パス名（階層表示用） |
| parent_path | string | 親パス |
| products | collection | カテゴリ内商品一覧 |

### 出力先

- データベーステーブル（products_categories）
- 画面表示（一覧・詳細・編集画面）

## 処理フロー

### 処理シーケンス

```
1. カテゴリ一覧表示
   └─ ListProductCategoriesページでカテゴリ一覧を表示
   └─ 階層構造で表示
2. カテゴリ作成
   └─ CreateProductCategoryページ → フォーム入力 → 親カテゴリ選択 → DB保存
3. カテゴリ編集
   └─ EditProductCategoryページ → 既存データ読込 → フォーム編集 → DB更新
4. カテゴリ詳細表示
   └─ ViewProductCategoryページ → 基本情報表示
5. カテゴリ内商品管理
   └─ ManageProductsページ → カテゴリ内商品一覧表示・管理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[カテゴリ一覧表示]
    B --> C{ユーザー操作}
    C -->|作成| D[作成画面へ遷移]
    C -->|編集| E[編集画面へ遷移]
    C -->|表示| F[詳細画面へ遷移]
    D --> G[フォーム入力]
    G --> H[親カテゴリ選択]
    H --> I{バリデーション}
    I -->|OK| J[DBへ保存]
    I -->|NG| G
    E --> G
    J --> K[complete_name更新]
    K --> B
    F --> L{関連情報参照}
    L -->|商品管理| M[ManageProducts]
    M --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-030-01 | カテゴリ名必須 | カテゴリ名は必須入力 | 作成・編集時 |
| BR-030-02 | 階層構造 | 親カテゴリを指定することで階層構造を形成 | 作成・編集時 |
| BR-030-03 | 完全パス名自動生成 | 親カテゴリ名/子カテゴリ名の形式で自動生成 | 保存時 |
| BR-030-04 | 循環参照禁止 | 自身を親カテゴリに指定不可 | 編集時 |

### 計算ロジック

```
【完全パス名生成】
complete_name = 親カテゴリのcomplete_name + " / " + カテゴリ名
（ルートカテゴリの場合はカテゴリ名のみ）
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | products_categories | SELECT | カテゴリ一覧取得 |
| 作成 | products_categories | INSERT | 新規カテゴリ登録 |
| 編集 | products_categories | UPDATE | カテゴリ情報更新 |
| 削除 | products_categories | DELETE | カテゴリ削除 |

### テーブル別操作詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | カテゴリ一覧 |
| INSERT | name, parent_id, complete_name, parent_path | フォーム入力値、自動生成値 | - |
| UPDATE | name, parent_id, complete_name, parent_path | フォーム入力値、再計算値 | - |
| DELETE | - | id指定 | 子カテゴリ・商品なしの場合のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E030-01 | バリデーションエラー | カテゴリ名未入力 | エラーメッセージ表示 |
| E030-02 | 整合性エラー | 循環参照 | エラーメッセージ表示 |
| E030-03 | 削除エラー | 子カテゴリまたは商品が存在 | エラー通知表示 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- カテゴリ情報の更新は個別トランザクション
- 子カテゴリのcomplete_name更新は親更新と同一トランザクション

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・編集：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- CSRF保護（Filament標準機能）

## 備考

- ProductCategoryResourceはCategoryResourceを継承
- Purchase\Models\CategoryはProduct\Models\Categoryを継承
- サブナビゲーション: View → Edit → Products
- SubNavigationPosition: 一覧ではStart、詳細/編集ではTop
- ナビゲーショングループはConfigurationクラスター
- navigationSort = 8
- ナビゲーションアイコンはheroicon-o-folder
