# 機能設計書 32-商品属性管理(購買)

## 概要

本ドキュメントは、購買管理モジュールにおける商品属性管理機能の設計仕様を定義するものです。購買用商品のバリエーション生成に使用する属性（サイズ、色など）を管理します。

### 本機能の処理概要

商品属性管理（購買）機能は、購買用商品のバリエーションを定義するための属性を管理する機能です。属性とは商品の特性（色、サイズ、素材など）を表し、各属性には複数のオプション値を設定できます。これにより商品バリエーションの自動生成が可能になります。

**業務上の目的・背景**：購買業務において、同一商品でも色やサイズなどが異なるバリエーションを仕入れる場合があります。本機能により、商品の属性を体系的に定義・管理することで、商品バリエーションの効率的な管理と仕入れ業務の効率化を実現します。また、販売モジュールの商品属性と連携し、購買から販売までの一貫した商品管理を可能にします。

**機能の利用シーン**：
- 新規商品カテゴリ追加時に属性を定義する場面
- 既存属性に新しいオプション値を追加する場面
- 商品のバリエーション生成前に属性を設定する場面
- 属性タイプ（ラジオボタン、カラー選択など）を変更する場面

**主要な処理内容**：
1. 商品属性の登録・編集・削除
2. 属性オプション（選択肢）の管理
3. 属性タイプ（表示形式）の設定
4. 属性に紐づく追加価格の設定
5. 属性一覧の表示と検索

**関連システム・外部連携**：商品マスタ（ProductResource）と連携し、商品に属性を適用してバリエーションを生成します。ベースとなるAttributeResourceを継承しており、商品管理モジュールと共通の属性管理基盤を使用しています。

**権限による制御**：購買設定権限を持つユーザーのみが属性の登録・編集・削除を行えます。ProductSettings設定でenable_variantsがtrueの場合のみ本機能が有効化されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-008 | ProductAttributeResource | 主画面 | 商品属性一覧表示・検索・フィルタ |
| SCR-PURCH-008 | ProductAttributeResource/Create | 参照画面 | 新規商品属性の作成 |
| SCR-PURCH-008 | ProductAttributeResource/Edit | 参照画面 | 既存商品属性の編集 |
| SCR-PURCH-008 | ProductAttributeResource/View | 参照画面 | 商品属性詳細の表示 |
| SCR-PURCH-005 | ProductResource | 参照画面 | 商品の属性管理（ManageAttributes） |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 属性名 | 最大255文字 |
| type | enum | Yes | 属性タイプ | AttributeType列挙型（radio/color/select/multi-checkbox/multi-image） |
| options | array | No | オプション一覧 | 配列形式 |
| options.*.name | string | Yes | オプション名 | 最大255文字 |
| options.*.color | string | No | カラーコード | 16進数カラーコード（typeがcolorの場合のみ） |
| options.*.extra_price | decimal | Yes | 追加価格 | 0〜99999999999の数値、デフォルト0 |

### 入力データソース

- 画面入力：属性登録・編集フォームからのユーザー入力
- DBテーブル：products_attributes（属性）、products_attribute_options（オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 属性ID |
| name | string | 属性名 |
| type | enum | 属性タイプ |
| options | array | オプション一覧 |
| options.*.id | integer | オプションID |
| options.*.name | string | オプション名 |
| options.*.color | string | カラーコード |
| options.*.extra_price | decimal | 追加価格 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示：属性一覧画面、詳細画面
- DBテーブル：products_attributes、products_attribute_options

## 処理フロー

### 処理シーケンス

```
1. 属性一覧表示
   └─ products_attributesテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. 属性登録
   └─ 入力フォームでデータ入力
   └─ オプション（Repeater）でオプション値を入力
   └─ バリデーション実行
   └─ products_attributesテーブルにINSERT
   └─ products_attribute_optionsテーブルにオプションをINSERT
   └─ 成功通知表示

3. 属性編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ products_attributesテーブルをUPDATE
   └─ products_attribute_optionsをSYNC（追加/更新/削除）
   └─ 成功通知表示

4. 属性削除
   └─ 削除確認ダイアログ表示
   └─ products_attributesテーブルからDELETE（ソフトデリート）
   └─ 成功/エラー通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[入力フォーム表示]
    F --> G[属性情報入力]
    G --> H[オプション追加]
    H --> I{バリデーション}
    I -->|OK| J[属性をDB保存]
    J --> K[オプションをDB保存]
    I -->|NG| G
    K --> L[成功通知]

    B -->|編集| M[既存データ取得]
    M --> N[編集フォーム表示]
    N --> O[データ編集]
    O --> P{バリデーション}
    P -->|OK| Q[属性を更新]
    Q --> R[オプションを同期]
    P -->|NG| O
    R --> S[成功通知]

    B -->|削除| T[削除確認]
    T -->|確認| U{削除実行}
    U -->|成功| V[ソフトデリート]
    U -->|失敗| W[エラー通知]
    T -->|キャンセル| E

    E --> X[終了]
    L --> X
    S --> X
    V --> X
    W --> X
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-032-001 | デフォルトタイプ | 属性タイプのデフォルトはRADIO | 新規登録時 |
| BR-032-002 | カラー表示条件 | typeがCOLORの場合のみカラーピッカーを表示 | 属性編集時 |
| BR-032-003 | 機能有効化条件 | enable_variants設定がtrueの場合のみ機能有効 | 画面表示時 |
| BR-032-004 | ソフトデリート | 削除時は論理削除（deleted_at設定） | 削除操作時 |
| BR-032-005 | 復元可能 | 削除された属性は復元可能 | 削除後 |

### 計算ロジック

**商品バリエーション価格の算出**：
```
バリエーション価格 = 基本価格 + Σ(選択オプションのextra_price)
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | products_attributes | SELECT | 属性一覧の取得 |
| 登録 | products_attributes | INSERT | 新規属性の登録 |
| 登録 | products_attribute_options | INSERT | オプションの登録 |
| 編集 | products_attributes | UPDATE | 既存属性の更新 |
| 編集 | products_attribute_options | SYNC | オプションの同期 |
| 削除 | products_attributes | UPDATE | ソフトデリート（deleted_at設定） |
| 復元 | products_attributes | UPDATE | deleted_atをNULLに |
| 完全削除 | products_attributes | DELETE | 物理削除 |

### テーブル別操作詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 属性名 |
| INSERT | type | フォーム入力値（デフォルトradio） | 属性タイプ |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | attribute_id | 親属性のID | 属性への紐付け |
| INSERT | name | フォーム入力値 | オプション名 |
| INSERT | color | フォーム入力値 | カラーコード |
| INSERT | extra_price | フォーム入力値（デフォルト0） | 追加価格 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-032-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-032-002 | 外部キー制約エラー | 商品で使用中の属性を削除 | エラー通知表示、削除をキャンセル |
| ERR-032-003 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |
| ERR-032-004 | 機能無効エラー | enable_variantsがfalse | 画面非表示・ナビゲーション非表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- 属性とオプションの登録・更新は1トランザクションで処理
- オプションの同期処理（追加/更新/削除）はリレーション管理により自動処理
- エラー発生時は全件ロールバック

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了
- オプション数が多い場合（50件以上）でも3秒以内に保存完了

## セキュリティ考慮事項

- 購買設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- ProductAttributeResourceはWebkul\Product\Filament\Resources\AttributeResourceを継承
- 購買モジュール固有のAttributeモデル（Webkul\Purchase\Models\Attribute）を使用
- SoftDeletesトレイトによる論理削除対応
- Filament Repeaterコンポーネントによるオプション管理
