# 機能設計書 33-パッケージング管理(購買)

## 概要

本ドキュメントは、購買管理モジュールにおけるパッケージング管理機能の設計仕様を定義するものです。購買用商品の受入単位（梱包単位）を管理し、発注業務における数量管理を効率化します。

### 本機能の処理概要

パッケージング管理（購買）機能は、商品の梱包単位や受入単位を定義・管理する機能です。1つの商品に対して複数のパッケージング単位を設定でき、発注時に適切な単位を選択して発注数量を管理できます。

**業務上の目的・背景**：購買業務において、商品は個別単位だけでなく、箱単位やパレット単位など、さまざまな梱包単位で仕入れられることが一般的です。本機能により、商品ごとのパッケージング情報を一元管理し、発注時の数量指定を効率化するとともに、受入れ検品業務もスムーズに行えるようにします。また、バーコード管理によりスキャナーを使用した効率的な在庫管理も可能にします。

**機能の利用シーン**：
- 新規仕入商品のパッケージング単位を登録する場面
- ケース入数やパレット入数を設定する場面
- パッケージングのバーコードを登録する場面
- パッケージング一覧をバーコード印刷する場面

**主要な処理内容**：
1. パッケージング情報の登録・編集・削除
2. 商品別のパッケージング一覧表示と検索
3. パッケージングのバーコード管理
4. パッケージング数量（入数）の設定
5. パッケージング一覧のバーコード印刷

**関連システム・外部連携**：商品マスタ（ProductResource）と連携し、商品に紐づくパッケージング情報を管理します。ベースとなるPackagingResourceを継承しており、商品管理モジュールと共通のパッケージング管理基盤を使用しています。

**権限による制御**：購買設定権限を持つユーザーのみがパッケージングの登録・編集・削除を行えます。ProductSettings設定でenable_packagingsがtrueの場合のみ本機能が有効化されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PURCH-009 | PackagingResource | 主画面 | パッケージング一覧表示・検索・フィルタ |
| SCR-PURCH-009 | PackagingResource/Manage | 参照画面 | パッケージングの作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | パッケージング名 | 最大255文字 |
| barcode | string | No | バーコード | 最大255文字 |
| product_id | integer | Yes | 商品ID | 存在する商品であること（type=goodsの商品のみ） |
| qty | decimal | Yes | 数量（入数） | 0〜99999999の数値 |
| company_id | integer | No | 会社ID | 存在する会社であること |

### 入力データソース

- 画面入力：パッケージング登録・編集フォームからのユーザー入力
- DBテーブル：products_products（商品）、supports_companies（会社）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パッケージングID |
| name | string | パッケージング名 |
| barcode | string | バーコード |
| product.name | string | 商品名 |
| qty | decimal | 数量（入数） |
| company.name | string | 会社名 |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示：パッケージング一覧画面、詳細画面
- PDF出力：バーコード印刷
- DBテーブル：products_packagings

## 処理フロー

### 処理シーケンス

```
1. パッケージング一覧表示
   └─ products_packagingsテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. パッケージング登録
   └─ モーダル入力フォームでデータ入力
   └─ バリデーション実行
   └─ products_packagingsテーブルにINSERT
   └─ 成功通知表示

3. パッケージング編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ products_packagingsテーブルをUPDATE
   └─ 成功通知表示

4. パッケージング削除
   └─ 削除確認ダイアログ表示
   └─ products_packagingsテーブルからDELETE
   └─ 成功/エラー通知表示

5. バーコード印刷
   └─ 選択されたパッケージングを取得
   └─ PDF生成（Packaging-Barcode.pdf）
   └─ ダウンロード
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[モーダルフォーム表示]
    F --> G[データ入力]
    G --> H{バリデーション}
    H -->|OK| I[DBに保存]
    H -->|NG| G
    I --> J[成功通知]

    B -->|編集| K[既存データ取得]
    K --> L[編集フォーム表示]
    L --> M[データ編集]
    M --> N{バリデーション}
    N -->|OK| O[DBを更新]
    N -->|NG| M
    O --> P[成功通知]

    B -->|削除| Q[削除確認]
    Q -->|確認| R{削除実行}
    R -->|成功| S[成功通知]
    R -->|失敗| T[エラー通知]
    Q -->|キャンセル| E

    B -->|印刷| U[選択レコード取得]
    U --> V[PDF生成]
    V --> W[ダウンロード]

    E --> X[終了]
    J --> X
    P --> X
    S --> X
    T --> X
    W --> X
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-033-001 | 商品タイプ制限 | type=goodsの商品のみパッケージング設定可能 | 商品選択時 |
| BR-033-002 | 機能有効化条件 | enable_packagings設定がtrueの場合のみ機能有効 | 画面表示時 |
| BR-033-003 | 作成者自動設定 | 登録時にcreator_idを認証ユーザーIDで設定 | 新規登録時 |
| BR-033-004 | 削除済み商品表示 | 商品選択時に削除済み商品も表示（選択不可） | 商品選択時 |
| BR-033-005 | バーコード印刷形式 | A4縦向きでPDF出力 | 印刷時 |

### 計算ロジック

**発注総数量の算出**：
```
発注総数量 = パッケージング数量(qty) × 発注パッケージ数
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | products_packagings | SELECT | パッケージング一覧の取得 |
| 登録 | products_packagings | INSERT | 新規パッケージングの登録 |
| 編集 | products_packagings | UPDATE | 既存パッケージングの更新 |
| 削除 | products_packagings | DELETE | パッケージングの削除（物理削除） |

### テーブル別操作詳細

#### products_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | パッケージング名 |
| INSERT | barcode | フォーム入力値 | バーコード |
| INSERT | product_id | フォーム入力値 | 商品ID |
| INSERT | qty | フォーム入力値 | 数量（入数） |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |
| DELETE | - | WHERE id = 対象ID | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-033-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-033-002 | 外部キー制約エラー | 存在しない商品/会社を指定 | エラーメッセージ表示、正しい値を選択 |
| ERR-033-003 | 削除エラー | 他テーブルから参照されている | エラー通知表示、削除をキャンセル |
| ERR-033-004 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |
| ERR-033-005 | 機能無効エラー | enable_packagingsがfalse | 画面非表示・ナビゲーション非表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- 登録・更新・削除操作は単一レコードへの操作のため、デフォルトのトランザクション管理を使用
- 一括削除時は全レコードの削除を1トランザクションで処理し、エラー発生時は全件ロールバック

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了
- PDF生成（バーコード印刷）：5秒以内に完了

## セキュリティ考慮事項

- 購買設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- PackagingResourceはWebkul\Product\Filament\Resources\PackagingResourceを継承
- 購買モジュール固有のPackagingモデル（Webkul\Purchase\Models\Packaging）を使用
- ManagePackagingsページでSimple Resourceとして実装
- Barryvdh\DomPDF\Facade\Pdfを使用したバーコード印刷機能
