# 機能設計書 34-倉庫管理

## 概要

本ドキュメントは、在庫管理モジュールにおける倉庫管理機能の設計仕様を定義するものです。企業の物流拠点となる倉庫情報を一元管理し、入出荷プロセスや在庫管理の基盤を提供します。

### 本機能の処理概要

倉庫管理機能は、企業の物流拠点である倉庫の基本情報と運用設定を管理する機能です。倉庫ごとに入荷・出荷のステップ（工程）を設定でき、複数倉庫間の補充関係も定義できます。

**業務上の目的・背景**：企業の物流業務において、倉庫は在庫管理の中核となる拠点です。単一倉庫から複数倉庫まで、企業の物流ネットワークに応じた柔軟な管理が必要です。また、入荷検品や出荷梱包など、倉庫内作業のステップ管理も重要な要素です。本機能は、これらの倉庫運用に関する設定を一元管理し、効率的な在庫管理を支援します。

**機能の利用シーン**：
- 新規倉庫の開設時に倉庫情報を登録する場面
- 入荷・出荷の作業ステップを設定する場面
- 複数倉庫間の補充関係（リサプライ）を設定する場面
- 倉庫に関連するルートを管理する場面

**主要な処理内容**：
1. 倉庫情報の登録・編集・削除
2. 入荷ステップ（直接入庫/検品後入庫/品質管理後入庫）の設定
3. 出荷ステップ（直接出荷/ピック&出荷/ピック&梱包&出荷）の設定
4. 倉庫間補充関係の設定
5. 倉庫関連ルートの管理

**関連システム・外部連携**：ロケーション管理機能と連携し、倉庫内の保管場所を管理します。また、在庫移動管理機能と連携して入出荷オペレーションを実行します。ルート管理機能とも連携し、倉庫固有の入出荷ルートを定義します。

**権限による制御**：在庫設定権限を持つユーザーのみが倉庫の登録・編集・削除を行えます。一部の設定項目はWarehouseSettings設定で有効化されている場合のみ表示されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-001 | WarehouseResource | 主画面 | 倉庫一覧表示・検索・フィルタ |
| SCR-INV-001 | WarehouseResource/Create | 参照画面 | 新規倉庫の作成 |
| SCR-INV-001 | WarehouseResource/Edit | 参照画面 | 既存倉庫の編集 |
| SCR-INV-001 | WarehouseResource/View | 参照画面 | 倉庫詳細の表示 |
| SCR-INV-001 | ManageRoutes | 参照画面 | 倉庫関連ルートの管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 倉庫名 | 最大255文字、一意 |
| code | string | Yes | 倉庫コード | 最大255文字、一意 |
| company_id | integer | Yes | 会社ID | 存在する会社であること |
| partner_address_id | integer | No | 住所ID | 存在するパートナー（住所）であること |
| reception_steps | enum | No | 入荷ステップ | ReceptionStep列挙型 |
| delivery_steps | enum | No | 出荷ステップ | DeliveryStep列挙型 |
| supplierWarehouses | array | No | 補充元倉庫 | 存在する倉庫のID配列 |

### 入力データソース

- 画面入力：倉庫登録・編集フォームからのユーザー入力
- DBテーブル：supports_companies（会社）、partners（住所）、inventories_warehouses（補充元倉庫）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 倉庫ID |
| name | string | 倉庫名 |
| code | string | 倉庫コード |
| company.name | string | 会社名 |
| partnerAddress.name | string | 住所 |
| reception_steps | enum | 入荷ステップ |
| delivery_steps | enum | 出荷ステップ |
| supplierWarehouses | array | 補充元倉庫一覧 |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時 |

### 出力先

- 画面表示：倉庫一覧画面、詳細画面
- DBテーブル：inventories_warehouses、inventories_warehouse_resupplies

## 処理フロー

### 処理シーケンス

```
1. 倉庫一覧表示
   └─ inventories_warehousesテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. 倉庫登録
   └─ 入力フォームでデータ入力
   └─ 入荷・出荷ステップを選択
   └─ 補充元倉庫を選択（任意）
   └─ バリデーション実行
   └─ inventories_warehousesテーブルにINSERT
   └─ 関連ロケーション自動生成
   └─ 関連オペレーションタイプ自動生成
   └─ 成功通知表示

3. 倉庫編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ inventories_warehousesテーブルをUPDATE
   └─ 補充関係を同期
   └─ 成功通知表示

4. 倉庫削除
   └─ 削除確認ダイアログ表示
   └─ inventories_warehousesテーブルをソフトデリート
   └─ 成功/エラー通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[入力フォーム表示]
    F --> G[基本情報入力]
    G --> H[出入荷ステップ設定]
    H --> I[補充元倉庫選択]
    I --> J{バリデーション}
    J -->|OK| K[倉庫レコード作成]
    K --> L[関連ロケーション生成]
    L --> M[オペレーションタイプ生成]
    J -->|NG| G
    M --> N[成功通知]

    B -->|編集| O[既存データ取得]
    O --> P[編集フォーム表示]
    P --> Q[データ編集]
    Q --> R{バリデーション}
    R -->|OK| S[倉庫レコード更新]
    S --> T[補充関係同期]
    R -->|NG| Q
    T --> U[成功通知]

    B -->|削除| V[削除確認]
    V -->|確認| W{削除実行}
    W -->|成功| X[ソフトデリート]
    W -->|失敗| Y[エラー通知]
    V -->|キャンセル| E

    E --> Z[終了]
    N --> Z
    U --> Z
    X --> Z
    Y --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-034-001 | 入荷ステップデフォルト | 入荷ステップのデフォルトはONE_STEP（直接入庫） | 新規登録時 |
| BR-034-002 | 出荷ステップデフォルト | 出荷ステップのデフォルトはONE_STEP（直接出荷） | 新規登録時 |
| BR-034-003 | 会社デフォルト | 会社はユーザーのデフォルト会社を設定（変更不可） | 新規登録時 |
| BR-034-004 | 倉庫コード更新時同期 | 倉庫コード変更時、ビューロケーション名を同期更新 | 編集時 |
| BR-034-005 | マルチステップ表示条件 | enable_multi_steps_routes設定時のみ入出荷ステップ表示 | 画面表示時 |
| BR-034-006 | 補充関係表示条件 | 倉庫が2件以上存在する場合のみ補充元選択を表示 | 画面表示時 |
| BR-034-007 | 一意制約 | 倉庫名および倉庫コードは一意 | 登録・編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | inventories_warehouses | SELECT | 倉庫一覧の取得 |
| 登録 | inventories_warehouses | INSERT | 新規倉庫の登録 |
| 登録 | inventories_locations | INSERT | 関連ロケーションの自動生成 |
| 登録 | inventories_operation_types | INSERT | オペレーションタイプの自動生成 |
| 登録 | inventories_warehouse_resupplies | INSERT | 補充関係の登録 |
| 編集 | inventories_warehouses | UPDATE | 既存倉庫の更新 |
| 編集 | inventories_warehouse_resupplies | SYNC | 補充関係の同期 |
| 削除 | inventories_warehouses | UPDATE | ソフトデリート（deleted_at設定） |
| 復元 | inventories_warehouses | UPDATE | deleted_atをNULLに |
| 完全削除 | inventories_warehouses | DELETE | 物理削除 |

### テーブル別操作詳細

#### inventories_warehouses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 倉庫名 |
| INSERT | code | フォーム入力値 | 倉庫コード |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | partner_address_id | フォーム入力値 | 住所ID |
| INSERT | reception_steps | フォーム入力値（デフォルトONE_STEP） | 入荷ステップ |
| INSERT | delivery_steps | フォーム入力値（デフォルトONE_STEP） | 出荷ステップ |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |

#### inventories_warehouse_resupplies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SYNC | supplier_warehouse_id | 選択された補充元倉庫ID | 補充元倉庫 |
| SYNC | supplied_warehouse_id | 対象倉庫のID | 補充先倉庫 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-034-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-034-002 | 一意制約エラー | 重複する倉庫名/コードを指定 | エラーメッセージ表示、別の値を入力 |
| ERR-034-003 | 外部キー制約エラー | 削除対象倉庫が他テーブルから参照されている | エラー通知表示、完全削除をキャンセル |
| ERR-034-004 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- 倉庫登録時は、倉庫レコード・関連ロケーション・オペレーションタイプの生成を1トランザクションで処理
- エラー発生時は全件ロールバック
- 一括削除時は全レコードの削除を1トランザクションで処理

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了

## セキュリティ考慮事項

- 在庫設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- Warehouseモデルは`Webkul\Inventory\Models\Warehouse`を使用
- SoftDeletesトレイトによる論理削除対応
- Spatie\EloquentSortable\Sortableによる並び順管理
- HasCustomFieldsトレイトによるカスタムフィールド対応
- PartnerResourceから住所を直接作成可能
