# 機能設計書 38-ルート管理

## 概要

本ドキュメントは、在庫管理モジュールにおけるルート管理機能の設計仕様を定義するものです。在庫の入出荷経路を定義し、複数ステップの入出荷フローを実現します。

### 本機能の処理概要

ルート管理機能は、在庫の入出荷時に適用される経路（ルート）を定義・管理する機能です。ルートには複数のルール（Rule）を設定でき、商品が倉庫を通過する際の経路を自動的に決定します。

**業務上の目的・背景**：複雑な物流プロセスでは、商品が入荷から出荷まで複数のステップを経ることがあります。検品エリアでの品質チェック、保管エリアへの移動、ピッキングエリアへの補充など、各ステップを体系的に管理する必要があります。本機能は、これらの複雑な物流フローをルートとして定義し、自動的なオペレーション生成を可能にします。

**機能の利用シーン**：
- 複数ステップの入荷フローを定義する場面
- 複数ステップの出荷フローを定義する場面
- 商品カテゴリ別のルートを設定する場面
- 倉庫固有のルートを設定する場面

**主要な処理内容**：
1. ルート情報の登録・編集・削除
2. ルートの適用対象設定（商品/商品カテゴリ/パッケージング/倉庫）
3. ルールの管理（入出荷ステップの定義）
4. 会社別ルートの管理

**関連システム・外部連携**：倉庫管理機能と連携し、倉庫固有のルートを定義します。商品管理機能と連携し、商品/商品カテゴリ別のルートを適用します。オペレーション管理機能と連携し、ルートに基づいたオペレーションを自動生成します。

**権限による制御**：在庫設定権限を持つユーザーのみがルートの登録・編集・削除を行えます。WarehouseSettings設定でenable_multi_steps_routesがtrueの場合のみ本機能が有効化されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-007 | RouteResource | 主画面 | ルート一覧表示・検索・フィルタ |
| SCR-INV-007 | RouteResource/Create | 参照画面 | 新規ルートの作成 |
| SCR-INV-007 | RouteResource/Edit | 参照画面 | 既存ルートの編集 |
| SCR-INV-007 | RouteResource/View | 参照画面 | ルート詳細の表示 |
| SCR-INV-007 | ManageRules | 参照画面 | ルールの管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | ルート名 | 最大255文字 |
| company_id | integer | No | 会社ID | 存在する会社であること |
| product_category_selectable | boolean | No | 商品カテゴリに適用可能 | - |
| product_selectable | boolean | No | 商品に適用可能 | - |
| packaging_selectable | boolean | No | パッケージングに適用可能 | enable_packagings設定時のみ表示 |
| warehouse_selectable | boolean | No | 倉庫に適用可能 | - |
| warehouses | array | No | 適用倉庫 | warehouse_selectable=trueの場合のみ |

### 入力データソース

- 画面入力：ルート登録・編集フォームからのユーザー入力
- DBテーブル：supports_companies（会社）、inventories_warehouses（倉庫）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ルートID |
| name | string | ルート名 |
| company.name | string | 会社名 |
| product_category_selectable | boolean | 商品カテゴリ適用可能 |
| product_selectable | boolean | 商品適用可能 |
| packaging_selectable | boolean | パッケージング適用可能 |
| warehouse_selectable | boolean | 倉庫適用可能 |
| warehouses | array | 適用倉庫一覧 |
| rules | array | ルール一覧 |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時 |

### 出力先

- 画面表示：ルート一覧画面、詳細画面
- DBテーブル：inventories_routes、inventories_route_warehouses

## 処理フロー

### 処理シーケンス

```
1. ルート一覧表示
   └─ inventories_routesテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. ルート登録
   └─ 入力フォームでデータ入力
   └─ 適用対象（商品/カテゴリ/パッケージング/倉庫）選択
   └─ 倉庫選択（warehouse_selectable時）
   └─ バリデーション実行
   └─ inventories_routesテーブルにINSERT
   └─ inventories_route_warehousesテーブルに関連INSERT
   └─ 成功通知表示

3. ルート編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ inventories_routesテーブルをUPDATE
   └─ 倉庫関連を同期
   └─ 成功通知表示

4. ルート削除
   └─ 削除確認ダイアログ表示
   └─ inventories_routesテーブルをソフトデリート
   └─ 成功/エラー通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[入力フォーム表示]
    F --> G[基本情報入力]
    G --> H[適用対象設定]
    H --> I{倉庫選択?}
    I -->|Yes| J[倉庫選択]
    I -->|No| K
    J --> K{バリデーション}
    K -->|OK| L[ルート作成]
    L --> M[倉庫関連作成]
    K -->|NG| G
    M --> N[成功通知]

    B -->|編集| O[既存データ取得]
    O --> P[編集フォーム表示]
    P --> Q[データ編集]
    Q --> R{バリデーション}
    R -->|OK| S[ルート更新]
    S --> T[倉庫関連同期]
    R -->|NG| Q
    T --> U[成功通知]

    B -->|削除| V[削除確認]
    V -->|確認| W{削除実行}
    W -->|成功| X[ソフトデリート]
    W -->|失敗| Y[エラー通知]
    V -->|キャンセル| E

    E --> Z[終了]
    N --> Z
    U --> Z
    X --> Z
    Y --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-038-001 | 機能有効化条件 | enable_multi_steps_routes設定がtrueの場合のみ機能有効 | 画面表示時 |
| BR-038-002 | パッケージング表示条件 | enable_packagings設定時のみpackaging_selectableを表示 | フォーム表示時 |
| BR-038-003 | 倉庫選択表示条件 | warehouse_selectable=trueの場合のみ倉庫選択を表示 | フォーム表示時 |
| BR-038-004 | 会社デフォルト | 会社はユーザーのデフォルト会社を設定 | 新規登録時 |
| BR-038-005 | ソート順管理 | sort列による表示順序の管理 | 一覧表示時 |
| BR-038-006 | 削除済み会社表示 | 削除済み会社も表示（選択不可） | 会社選択時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | inventories_routes | SELECT | ルート一覧の取得 |
| 登録 | inventories_routes | INSERT | 新規ルートの登録 |
| 登録 | inventories_route_warehouses | INSERT | 倉庫関連の登録 |
| 編集 | inventories_routes | UPDATE | 既存ルートの更新 |
| 編集 | inventories_route_warehouses | SYNC | 倉庫関連の同期 |
| 削除 | inventories_routes | UPDATE | ソフトデリート（deleted_at設定） |
| 復元 | inventories_routes | UPDATE | deleted_atをNULLに |
| 完全削除 | inventories_routes | DELETE | 物理削除 |

### テーブル別操作詳細

#### inventories_routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ルート名 |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | product_category_selectable | フォーム入力値 | 商品カテゴリ適用可能 |
| INSERT | product_selectable | フォーム入力値 | 商品適用可能 |
| INSERT | packaging_selectable | フォーム入力値 | パッケージング適用可能 |
| INSERT | warehouse_selectable | フォーム入力値 | 倉庫適用可能 |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |

#### inventories_route_warehouses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SYNC | route_id | ルートID | ルートへの紐付け |
| SYNC | warehouse_id | 選択された倉庫ID | 倉庫への紐付け |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-038-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-038-002 | 外部キー制約エラー | 削除対象ルートが他テーブルから参照されている | エラー通知表示、完全削除をキャンセル |
| ERR-038-003 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |
| ERR-038-004 | 機能無効エラー | enable_multi_steps_routesがfalse | 画面非表示・ナビゲーション非表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- ルートと倉庫関連の登録・更新は1トランザクションで処理
- エラー発生時は全件ロールバック

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了

## セキュリティ考慮事項

- 在庫設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- Routeモデル（Webkul\Inventory\Models\Route）を使用
- SoftDeletesトレイトによる論理削除対応
- Spatie\EloquentSortable\Sortableによる並び順管理
- RulesRelationManagerでルールをサブリソース管理
