# 機能設計書 39-ストレージカテゴリ管理

## 概要

本ドキュメントは、在庫管理モジュールにおけるストレージカテゴリ管理機能の設計仕様を定義するものです。ロケーションの保管ルールを分類し、在庫配置の最適化を支援します。

### 本機能の処理概要

ストレージカテゴリ管理機能は、ロケーションに適用する保管ルールのカテゴリを定義・管理する機能です。重量制限、新商品の許可設定、商品/パッケージ別のキャパシティ制限などを設定できます。

**業務上の目的・背景**：倉庫内のロケーションには、物理的な制約（重量制限、容量制限）や運用上の制約（特定商品専用、混載禁止）が存在します。本機能は、これらの制約条件をストレージカテゴリとして体系化し、ロケーションに適用することで、適切な在庫配置を実現します。

**機能の利用シーン**：
- 重量制限のあるロケーション用のカテゴリを作成する場面
- 特定商品専用のロケーション用のカテゴリを作成する場面
- 商品別/パッケージ別のキャパシティを設定する場面
- ロケーションにストレージカテゴリを割り当てる場面

**主要な処理内容**：
1. ストレージカテゴリの登録・編集・削除
2. 最大重量の設定
3. 新商品の許可設定（空のみ/混載可/禁止）
4. 商品別キャパシティの設定
5. パッケージタイプ別キャパシティの設定

**関連システム・外部連携**：ロケーション管理機能と連携し、ストレージカテゴリをロケーションに適用します。商品管理機能と連携し、商品別キャパシティを設定します。パッケージタイプ管理機能と連携し、パッケージ別キャパシティを設定します。

**権限による制御**：在庫設定権限を持つユーザーのみがストレージカテゴリの登録・編集・削除を行えます。WarehouseSettings設定でenable_locationsがtrueの場合のみ本機能が有効化されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-008 | StorageCategoryResource | 主画面 | ストレージカテゴリ一覧表示・検索・フィルタ |
| SCR-INV-008 | StorageCategoryResource/Create | 参照画面 | 新規ストレージカテゴリの作成 |
| SCR-INV-008 | StorageCategoryResource/Edit | 参照画面 | 既存ストレージカテゴリの編集 |
| SCR-INV-008 | StorageCategoryResource/View | 参照画面 | ストレージカテゴリ詳細の表示 |
| SCR-INV-008 | ManageCapacityByPackages | 参照画面 | パッケージ別キャパシティの管理 |
| SCR-INV-008 | ManageCapacityByProducts | 参照画面 | 商品別キャパシティの管理 |
| SCR-INV-008 | ManageLocations | 参照画面 | 関連ロケーションの管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 最大255文字 |
| max_weight | decimal | No | 最大重量 | 0〜99999999の数値、デフォルト0 |
| allow_new_products | enum | Yes | 新商品の許可設定 | AllowNewProduct列挙型（empty/mixed/same） |
| company_id | integer | No | 会社ID | 存在する会社であること |

### 入力データソース

- 画面入力：ストレージカテゴリ登録・編集フォームからのユーザー入力
- DBテーブル：supports_companies（会社）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ストレージカテゴリID |
| name | string | カテゴリ名 |
| max_weight | decimal | 最大重量 |
| allow_new_products | enum | 新商品の許可設定 |
| company.name | string | 会社名 |
| storageCategoryCapacitiesByProduct | array | 商品別キャパシティ |
| storageCategoryCapacitiesByPackageType | array | パッケージ別キャパシティ |
| locations | array | 関連ロケーション |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示：ストレージカテゴリ一覧画面、詳細画面
- DBテーブル：inventories_storage_categories、inventories_storage_category_capacities

## 処理フロー

### 処理シーケンス

```
1. ストレージカテゴリ一覧表示
   └─ inventories_storage_categoriesテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. ストレージカテゴリ登録
   └─ 入力フォームでデータ入力
   └─ 新商品の許可設定選択
   └─ バリデーション実行
   └─ inventories_storage_categoriesテーブルにINSERT
   └─ 成功通知表示

3. ストレージカテゴリ編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ inventories_storage_categoriesテーブルをUPDATE
   └─ 成功通知表示

4. ストレージカテゴリ削除
   └─ 削除確認ダイアログ表示
   └─ inventories_storage_categoriesテーブルからDELETE
   └─ 成功/エラー通知表示

5. キャパシティ管理
   └─ 商品別/パッケージ別キャパシティをサブリソースで管理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[入力フォーム表示]
    F --> G[基本情報入力]
    G --> H[新商品許可設定]
    H --> I{バリデーション}
    I -->|OK| J[カテゴリ作成]
    I -->|NG| G
    J --> K[成功通知]

    B -->|編集| L[既存データ取得]
    L --> M[編集フォーム表示]
    M --> N[データ編集]
    N --> O{バリデーション}
    O -->|OK| P[カテゴリ更新]
    O -->|NG| N
    P --> Q[成功通知]

    B -->|削除| R[削除確認]
    R -->|確認| S{削除実行}
    S -->|成功| T[成功通知]
    S -->|失敗| U[エラー通知]
    R -->|キャンセル| E

    B -->|キャパシティ管理| V[サブリソース画面]
    V --> W[商品/パッケージ別設定]

    E --> X[終了]
    K --> X
    Q --> X
    T --> X
    U --> X
    W --> X
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-039-001 | 機能有効化条件 | enable_locations設定がtrueの場合のみ機能有効 | 画面表示時 |
| BR-039-002 | 新商品許可デフォルト | allow_new_productsのデフォルトはMIXED | 新規登録時 |
| BR-039-003 | 最大重量デフォルト | max_weightのデフォルトは0 | 新規登録時 |
| BR-039-004 | 会社デフォルト | 会社はユーザーのデフォルト会社を設定 | 新規登録時 |
| BR-039-005 | ソート順管理 | sort列による表示順序の管理 | 一覧表示時 |

### 計算ロジック

**AllowNewProduct列挙型**：
- `empty`：ロケーションが空の場合のみ新商品を受け入れ
- `mixed`：既存商品と混載可能
- `same`：同一商品のみ受け入れ（新商品禁止）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | inventories_storage_categories | SELECT | ストレージカテゴリ一覧の取得 |
| 登録 | inventories_storage_categories | INSERT | 新規ストレージカテゴリの登録 |
| 編集 | inventories_storage_categories | UPDATE | 既存ストレージカテゴリの更新 |
| 削除 | inventories_storage_categories | DELETE | ストレージカテゴリの削除（物理削除） |
| キャパシティ登録 | inventories_storage_category_capacities | INSERT | キャパシティの登録 |

### テーブル別操作詳細

#### inventories_storage_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | カテゴリ名 |
| INSERT | max_weight | フォーム入力値（デフォルト0） | 最大重量 |
| INSERT | allow_new_products | フォーム入力値（デフォルトMIXED） | 新商品許可設定 |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-039-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-039-002 | 外部キー制約エラー | ロケーションで使用中のカテゴリを削除 | エラー通知表示、削除をキャンセル |
| ERR-039-003 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |
| ERR-039-004 | 機能無効エラー | enable_locationsがfalse | 画面非表示・ナビゲーション非表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- 登録・更新・削除操作は単一レコードへの操作のため、デフォルトのトランザクション管理を使用
- キャパシティ管理はリレーションマネージャーで個別処理

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了

## セキュリティ考慮事項

- 在庫設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- StorageCategoryモデル（Webkul\Inventory\Models\StorageCategory）を使用
- Spatie\EloquentSortable\Sortableによる並び順管理
- AllowNewProduct列挙型（EMPTY/MIXED/SAME）
- RelationGroupでキャパシティをサブリソース管理
- CapacityByPackagesRelationManager、CapacityByProductsRelationManagerを使用
