# 機能設計書: 会社管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F004 |
| 機能名 | 会社管理 |
| 機能概要 | マルチカンパニー対応のための会社情報の登録・編集・削除、および親子会社（支社）構造の管理を行う |
| 関連画面 | SCR-COMPANY-001（会社一覧）、SCR-COMPANY-002（会社作成）、SCR-COMPANY-003（会社詳細）、SCR-COMPANY-004（会社編集） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

会社管理機能は、AureusERPのマルチカンパニー機能を支える基盤機能である。会社情報の管理に加え、親会社-支社の階層構造、ユーザーへの会社アクセス権限割り当て、およびPartnerレコードとの自動同期を行う。

#### 主な機能
1. **会社一覧表示**: 登録済み会社をテーブル形式で表示（親会社のみ/支社含む切り替え）
2. **会社作成**: 新規会社の登録とPartner自動作成
3. **会社編集**: 既存会社情報の更新
4. **会社アーカイブ**: 会社の論理削除（SoftDelete）
5. **支社管理**: 親会社-支社の階層構造管理
6. **ユーザー許可会社設定**: ユーザーがアクセス可能な会社の設定

### 2.2 処理フロー

#### 会社作成フロー
```
[開始]
   |
   v
[会社作成画面表示]
   |
   v
[フォーム入力（会社名、住所、連絡先等）]
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フォーム入力]
   |
   v (OK)
[Partnerレコード作成（boot::creating）]
   |
   v
[companiesテーブルにレコード作成]
   |
   v
[Partner同期更新（boot::saved）]
   |
   v
[会社詳細画面へリダイレクト]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| name | string | YES | max:255 | 会社名 |
| parent_id | integer | NO | exists:companies,id | 親会社ID（支社の場合） |
| tax_id | string | NO | max:50 | 税務登録番号 |
| registration_number | string | NO | max:100 | 法人登録番号 |
| email | string | NO | email | メールアドレス |
| phone | string | NO | max:20 | 電話番号 |
| mobile | string | NO | max:20 | 携帯電話番号 |
| website | string | NO | url | Webサイト |
| street1 | string | NO | max:255 | 住所1 |
| street2 | string | NO | max:255 | 住所2 |
| city | string | NO | max:100 | 市区町村 |
| zip | string | NO | max:20 | 郵便番号 |
| state_id | integer | NO | exists:states,id | 都道府県/州ID |
| country_id | integer | NO | exists:countries,id | 国ID |
| currency_id | integer | NO | exists:currencies,id | 通貨ID |
| logo | file | NO | image,max:2048 | 会社ロゴ |
| color | string | NO | hex_color | テーマカラー |
| is_active | boolean | NO | - | アクティブ状態 |
| founded_date | date | NO | date | 設立日 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | 会社ID |
| name | string | 会社名 |
| parent | object | 親会社情報（支社の場合） |
| branches | array | 支社一覧 |
| country | object | 国情報 |
| state | object | 都道府県/州情報 |
| currency | object | 通貨情報 |
| partner | object | 関連パートナー情報 |
| is_active | boolean | アクティブ状態 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | Partner自動作成 | 会社作成時、対応するPartnerレコード（sub_type: company）が自動作成される |
| BR-002 | Partner自動更新 | 会社更新時、関連Partnerレコードも同期更新される |
| BR-003 | 階層構造 | 親会社-支社の2階層構造をサポート |
| BR-004 | 論理削除 | 会社削除は論理削除（SoftDelete）で行われる |
| BR-005 | アクティブ状態管理 | is_active=falseの会社はシステム全体で非表示 |
| BR-006 | ソート順管理 | Spatie Sortableによるドラッグ&ドロップ順序変更可能 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| companies | 会社情報管理 | SELECT, INSERT, UPDATE, DELETE(soft) |
| partners | パートナー情報連携 | SELECT, INSERT, UPDATE |
| countries | 国マスタ参照 | SELECT |
| states | 都道府県/州マスタ参照 | SELECT |
| currencies | 通貨マスタ参照 | SELECT |
| user_allowed_companies | ユーザー許可会社 | SELECT, INSERT, DELETE |

### 4.2 テーブル定義（companies）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| sort | integer | NO | auto | ソート順 |
| name | varchar(255) | NO | - | 会社名 |
| company_id | bigint | YES | NULL | 会社ID（自己参照） |
| parent_id | bigint | YES | NULL | 親会社ID |
| tax_id | varchar(50) | YES | NULL | 税務登録番号 |
| registration_number | varchar(100) | YES | NULL | 法人登録番号 |
| email | varchar(255) | YES | NULL | メールアドレス |
| phone | varchar(20) | YES | NULL | 電話番号 |
| mobile | varchar(20) | YES | NULL | 携帯電話番号 |
| street1 | varchar(255) | YES | NULL | 住所1 |
| street2 | varchar(255) | YES | NULL | 住所2 |
| city | varchar(100) | YES | NULL | 市区町村 |
| zip | varchar(20) | YES | NULL | 郵便番号 |
| state_id | bigint | YES | NULL | 都道府県/州ID（FK） |
| country_id | bigint | YES | NULL | 国ID（FK） |
| logo | varchar(255) | YES | NULL | ロゴ画像パス |
| color | varchar(7) | YES | NULL | テーマカラー |
| is_active | boolean | NO | true | アクティブフラグ |
| founded_date | date | YES | NULL | 設立日 |
| creator_id | bigint | YES | NULL | 作成者ID |
| currency_id | bigint | YES | NULL | 通貨ID（FK） |
| partner_id | bigint | YES | NULL | パートナーID（FK） |
| website | varchar(255) | YES | NULL | Webサイト |
| deleted_at | timestamp | YES | NULL | 論理削除日時 |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| CompanyResource | plugins/webkul/security/src/Filament/Resources/CompanyResource.php | 会社管理Filamentリソース |
| Company | plugins/webkul/support/src/Models/Company.php | 会社モデル |
| Partner | plugins/webkul/partner/src/Models/Partner.php | パートナーモデル（連携先） |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/support | 必須（基盤モデル） |
| webkul/partner | 必須（Partner連携） |
| webkul/chatter | オプション（HasChatterトレイト） |
| webkul/fields | オプション（HasCustomFieldsトレイト） |
| spatie/eloquent-sortable | 必須（ソート機能） |
| filament/filament | 必須（管理画面UI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_company | 会社一覧・詳細の閲覧 |
| view_any_company | 全会社の閲覧 |
| create_company | 会社作成 |
| update_company | 会社更新 |
| delete_company | 会社アーカイブ |
| restore_company | アーカイブ復元 |
| force_delete_company | 物理削除 |

### 6.2 セキュリティ考慮事項

- ユーザーは許可された会社（user_allowed_companies）のデータのみアクセス可能
- マルチテナント環境でのデータ分離

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内 |
| 会社作成応答時間 | 2秒以内（Partner作成含む） |
| ロゴアップロード | 5秒以内 |

### 7.2 可用性

- Partner同期処理はトランザクション管理
- ファイルアップロード失敗時のリトライ機構

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| COMP-001 | Partner作成失敗 | ロールバック、エラーログ出力 |
| COMP-002 | ロゴアップロード失敗 | エラー通知、再アップロード促進 |
| COMP-003 | 循環参照（親子関係） | バリデーションエラー表示 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | 会社一覧が正しく表示されること |
| T-002 | 会社作成 | 必須項目入力で正常に作成できること |
| T-003 | Partner連携 | 会社作成時にPartnerが自動作成されること |
| T-004 | Partner更新 | 会社更新時にPartnerが同期更新されること |
| T-005 | 支社作成 | 親会社を指定して支社が作成できること |
| T-006 | アクティブ状態 | is_activeによるフィルタリングが機能すること |
| T-007 | アーカイブ | 会社が論理削除されること |
| T-008 | 復元 | アーカイブ会社が復元できること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
