# 機能設計書 40-パッケージタイプ管理

## 概要

本ドキュメントは、在庫管理モジュールにおけるパッケージタイプ管理機能の設計仕様を定義するものです。商品を梱包するパッケージの種類とサイズ・重量制限を定義し、物流オペレーションを支援します。

### 本機能の処理概要

パッケージタイプ管理機能は、在庫管理で使用するパッケージ（梱包箱・コンテナ等）の種類を定義・管理する機能です。パッケージの寸法（縦・横・高さ）、基本重量、最大重量、バーコードなどを設定できます。

**業務上の目的・背景**：物流業務では、商品を適切なパッケージに梱包して出荷します。パッケージの種類によってサイズや重量制限が異なるため、パッケージタイプを体系的に管理することで、適切なパッケージ選択と配送コスト最適化を支援します。

**機能の利用シーン**：
- 新しい梱包箱タイプを登録する場面
- パッケージのサイズ・重量制限を設定する場面
- パッケージにバーコードを割り当てる場面
- 配送業者との連携用パッケージコードを設定する場面

**主要な処理内容**：
1. パッケージタイプの登録・編集・削除
2. サイズ（縦・横・高さ）の設定
3. 基本重量・最大重量の設定
4. バーコードの設定
5. 会社別パッケージタイプの管理

**関連システム・外部連携**：パッケージ管理機能と連携し、パッケージタイプを個別パッケージに適用します。ストレージカテゴリ管理機能と連携し、パッケージタイプ別のキャパシティを設定します。

**権限による制御**：在庫設定権限を持つユーザーのみがパッケージタイプの登録・編集・削除を行えます。OperationSettings設定でenable_packagesがtrueの場合のみ本機能が有効化されます。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-009 | PackageTypeResource | 主画面 | パッケージタイプ一覧表示・検索・フィルタ |
| SCR-INV-009 | PackageTypeResource/Create | 参照画面 | 新規パッケージタイプの作成 |
| SCR-INV-009 | PackageTypeResource/Edit | 参照画面 | 既存パッケージタイプの編集 |
| SCR-INV-009 | PackageTypeResource/View | 参照画面 | パッケージタイプ詳細の表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | パッケージタイプ名 | 最大255文字 |
| length | decimal | Yes | 長さ | 0〜99999999999の数値、デフォルト0 |
| width | decimal | Yes | 幅 | 0〜99999999999の数値、デフォルト0 |
| height | decimal | Yes | 高さ | 0〜99999999999の数値、デフォルト0 |
| base_weight | decimal | Yes | 基本重量 | 0〜99999999999の数値、デフォルト0 |
| max_weight | decimal | Yes | 最大重量 | 0〜99999999999の数値、デフォルト0 |
| barcode | string | No | バーコード | 最大255文字 |
| company_id | integer | No | 会社ID | 存在する会社であること |

### 入力データソース

- 画面入力：パッケージタイプ登録・編集フォームからのユーザー入力
- DBテーブル：supports_companies（会社）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パッケージタイプID |
| name | string | パッケージタイプ名 |
| length | decimal | 長さ |
| width | decimal | 幅 |
| height | decimal | 高さ |
| base_weight | decimal | 基本重量 |
| max_weight | decimal | 最大重量 |
| barcode | string | バーコード |
| company.name | string | 会社名 |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示：パッケージタイプ一覧画面、詳細画面
- DBテーブル：inventories_package_types

## 処理フロー

### 処理シーケンス

```
1. パッケージタイプ一覧表示
   └─ inventories_package_typesテーブルからデータ取得
   └─ フィルター・ソート条件を適用
   └─ ページネーション処理
   └─ 一覧画面に表示

2. パッケージタイプ登録
   └─ 入力フォームでデータ入力
   └─ サイズ（縦・横・高さ）入力
   └─ 重量（基本・最大）入力
   └─ バリデーション実行
   └─ inventories_package_typesテーブルにINSERT
   └─ 成功通知表示

3. パッケージタイプ編集
   └─ 既存データを取得してフォームに表示
   └─ データ編集
   └─ バリデーション実行
   └─ inventories_package_typesテーブルをUPDATE
   └─ 成功通知表示

4. パッケージタイプ削除
   └─ 削除確認ダイアログ表示
   └─ inventories_package_typesテーブルからDELETE
   └─ 成功/エラー通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[データ取得]
    C --> D[フィルタ・ソート適用]
    D --> E[一覧表示]

    B -->|登録| F[入力フォーム表示]
    F --> G[基本情報入力]
    G --> H[サイズ入力]
    H --> I[重量入力]
    I --> J{バリデーション}
    J -->|OK| K[パッケージタイプ作成]
    J -->|NG| G
    K --> L[成功通知]

    B -->|編集| M[既存データ取得]
    M --> N[編集フォーム表示]
    N --> O[データ編集]
    O --> P{バリデーション}
    P -->|OK| Q[パッケージタイプ更新]
    P -->|NG| O
    Q --> R[成功通知]

    B -->|削除| S[削除確認]
    S -->|確認| T{削除実行}
    T -->|成功| U[成功通知]
    T -->|失敗| V[エラー通知]
    S -->|キャンセル| E

    E --> W[終了]
    L --> W
    R --> W
    U --> W
    V --> W
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-040-001 | 機能有効化条件 | enable_packages設定がtrueの場合のみ機能有効 | 画面表示時 |
| BR-040-002 | サイズデフォルト | length/width/heightのデフォルトは0 | 新規登録時 |
| BR-040-003 | 重量デフォルト | base_weight/max_weightのデフォルトは0 | 新規登録時 |
| BR-040-004 | ソート順管理 | sort列による表示順序の管理 | 一覧表示時 |
| BR-040-005 | 単位表示 | サイズはcm、重量はkgで表示 | 詳細画面表示時 |

### 計算ロジック

**容積の算出**（参考）：
```
容積 = length × width × height
```

**最大積載量の算出**（参考）：
```
最大積載量 = max_weight - base_weight
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | inventories_package_types | SELECT | パッケージタイプ一覧の取得 |
| 登録 | inventories_package_types | INSERT | 新規パッケージタイプの登録 |
| 編集 | inventories_package_types | UPDATE | 既存パッケージタイプの更新 |
| 削除 | inventories_package_types | DELETE | パッケージタイプの削除（物理削除） |

### テーブル別操作詳細

#### inventories_package_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | パッケージタイプ名 |
| INSERT | length | フォーム入力値（デフォルト0） | 長さ |
| INSERT | width | フォーム入力値（デフォルト0） | 幅 |
| INSERT | height | フォーム入力値（デフォルト0） | 高さ |
| INSERT | base_weight | フォーム入力値（デフォルト0） | 基本重量 |
| INSERT | max_weight | フォーム入力値（デフォルト0） | 最大重量 |
| INSERT | barcode | フォーム入力値 | バーコード |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | creator_id | 認証ユーザーID | 作成者ID |
| UPDATE | 上記項目 | フォーム入力値 | 更新対象項目 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-040-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、入力画面に戻る |
| ERR-040-002 | 外部キー制約エラー | パッケージで使用中のタイプを削除 | エラー通知表示、削除をキャンセル |
| ERR-040-003 | 権限エラー | 操作権限がない | アクセス拒否メッセージ表示 |
| ERR-040-004 | 機能無効エラー | enable_packagesがfalse | 画面非表示・ナビゲーション非表示 |

### リトライ仕様

通常のCRUD操作のため、リトライ処理は不要です。DBエラー発生時はエラーメッセージを表示し、ユーザーに再操作を促します。

## トランザクション仕様

- 登録・更新・削除操作は単一レコードへの操作のため、デフォルトのトランザクション管理を使用

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 登録・更新・削除：2秒以内に完了

## セキュリティ考慮事項

- 在庫設定権限による操作制限
- SQLインジェクション対策（Eloquent ORMによるパラメータバインディング）
- CSRF対策（Laravelのトークン検証）
- XSS対策（Bladeテンプレートによるエスケープ）

## 備考

- PackageTypeモデル（Webkul\Inventory\Models\PackageType）を使用
- Spatie\EloquentSortable\Sortableによる並び順管理
- shipper_package_code、package_carrier_type は配送業者連携用（Fillableに定義あり）
- 詳細画面でサイズはcm単位、重量はkg単位で表示
