# 機能設計書: F041 - 商品カテゴリ管理(在庫)

## 1. 機能概要

### 1.1 機能名
商品カテゴリ管理(在庫)

### 1.2 機能ID
F041

### 1.3 対象プラグイン
inventories

### 1.4 機能説明
在庫管理システムにおける商品カテゴリの管理機能を提供する。商品を論理的にグループ化し、在庫ルート設定や商品分類を行うための基盤機能である。プロダクトプラグインの基本カテゴリ機能を継承し、在庫管理に特化した拡張を行っている。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 名前 | テキスト | 必須 | 255 | カテゴリ名 |
| 親カテゴリ | 選択 | 任意 | - | 階層構造の親カテゴリ |
| ルート | 選択(複数) | 任意 | - | 在庫ルート設定 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| カテゴリ名 | 商品カテゴリの名称 |
| 親カテゴリ | 所属する親カテゴリ名 |
| 商品数 | カテゴリに属する商品の数 |
| 作成日時 | レコード作成日時 |
| 更新日時 | レコード更新日時 |

## 3. 処理フロー

### 3.1 カテゴリ登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
カテゴリ名を入力（必須）
  ↓
親カテゴリを選択（任意）
  ↓
在庫ルートを選択（任意、複数可）
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
[バリデーションエラー?]
  ├─ Yes → エラーメッセージ表示 → 入力フォームに戻る
  └─ No ↓
データベースに保存
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 カテゴリ更新フロー

```
開始
  ↓
一覧からカテゴリを選択
  ↓
編集ボタンをクリック
  ↓
既存データを含む編集フォームを表示
  ↓
内容を変更
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
データベースを更新
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.3 カテゴリ削除フロー

```
開始
  ↓
一覧からカテゴリを選択
  ↓
削除ボタンをクリック
  ↓
確認ダイアログ表示
  ↓
[削除確認?]
  ├─ No → キャンセル → 終了
  └─ Yes ↓
[関連商品が存在?]
  ├─ Yes → エラーメッセージ表示 → 終了
  └─ No ↓
データベースから削除
  ↓
成功メッセージ表示
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Inventory\Models\Category | products_categories (継承) | 商品カテゴリモデル（基底クラスを継承） |
| Webkul\Inventory\Models\Route | inventories_routes | 在庫ルートモデル |
| Webkul\Inventory\Models\Product | inventories_products | 在庫商品モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| ProductCategoryResource | plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/ProductCategoryResource.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| routes | belongsToMany | Route | カテゴリに紐づく在庫ルート（中間テーブル: inventories_category_routes） |
| products | hasMany | Product | カテゴリに属する商品 |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | カテゴリ名が空の場合 | カテゴリ名は必須です |
| 文字数超過 | カテゴリ名が255文字を超える場合 | カテゴリ名は255文字以内で入力してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 関連商品が存在する場合 | このカテゴリには商品が紐付いているため削除できません |
| 参照整合性エラー | 親カテゴリが削除済みの場合 | 指定された親カテゴリは存在しません |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |
| トランザクションエラー | ロールバック実行、エラーログ出力 |

## 6. 備考

### 6.1 設計上の考慮事項
- 本機能はWebkul\Product\Models\Categoryを継承しており、基本的なカテゴリ管理機能はproductsプラグインから提供される
- 在庫管理に特化したルート機能（routes）がinventoriesプラグインで拡張されている
- カテゴリは階層構造をサポートしており、親子関係を持つことができる

### 6.2 パフォーマンス考慮
- カテゴリ選択時はsearchableオプションにより、大量データでも効率的な検索が可能
- 階層構造のデータ取得にはEager Loadingを使用して、N+1問題を回避

### 6.3 セキュリティ考慮
- Filamentの標準的な認証・認可機能により、アクセス制御が行われる
- 入力値はEloquentによりサニタイズされ、SQLインジェクション対策が施されている

### 6.4 依存関係
- products プラグイン（基底クラス提供）
- Filament フレームワーク（UI提供）
