# 機能設計書: F042 - 請求書管理

## 1. 機能概要

### 1.1 機能名
請求書管理

### 1.2 機能ID
F042

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
顧客向け請求書（売上請求書）の作成・編集・管理を行う機能を提供する。請求書の作成から確定（転記）、支払い状況の追跡までを一元管理する。会計処理の中核機能として、仕訳帳との連携や税計算機能を備える。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目（基本情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 顧客 | 選択 | 任意 | - | 請求先顧客の選択 |
| 請求日 | 日付 | 任意 | - | 請求書の発行日 |
| 期日 | 日付 | 条件付必須 | - | 支払期日（支払条件未設定時は必須） |
| 支払条件 | 選択 | 条件付必須 | - | 支払条件の選択（期日未設定時は必須） |
| 会社 | 選択 | 任意 | - | 発行元会社 |
| 通貨 | 選択 | 必須 | - | 請求書の通貨 |

#### 画面入力項目（明細行）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 商品 | 選択 | 必須 | - | 請求対象商品 |
| 数量 | 数値 | 必須 | - | 請求数量（デフォルト: 1） |
| 単位 | 選択 | 条件付必須 | - | 単位（UOM有効時のみ） |
| 単価 | 数値 | 必須 | - | 商品単価 |
| 割引率 | 数値 | 任意 | - | 割引率（%） |
| 税 | 選択(複数) | 任意 | - | 適用する税 |

#### 画面入力項目（その他情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| インコタームズ | 選択 | 任意 | - | 貿易条件 |
| インコタームズ場所 | テキスト | 任意 | 255 | 貿易条件の場所 |
| 支払方法 | 選択 | 任意 | - | 支払方法 |
| 自動転記 | トグル | 任意 | - | 自動転記フラグ |
| 確認済み | トグル | 任意 | - | 確認済みフラグ |
| 備考 | リッチテキスト | 任意 | - | 条件・注意事項 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 請求書番号 | 自動採番された請求書番号 |
| 顧客名 | 請求先顧客名 |
| 請求日 | 請求書発行日 |
| 期日 | 支払期日 |
| 税抜金額 | 税抜きの合計金額 |
| 合計金額 | 税込みの合計金額 |
| 状態 | 請求書の状態（下書き/転記済み/取消） |
| 支払状態 | 支払状態（未払い/一部支払い/支払済み） |

## 3. 処理フロー

### 3.1 請求書作成フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示（状態: 下書き）
  ↓
基本情報を入力
  ↓
明細行を追加
  ├─ 商品を選択
  ├─ 数量・単価を入力
  ├─ 税を選択
  └─ 小計を自動計算
  ↓
合計金額を自動計算
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
[バリデーションエラー?]
  ├─ Yes → エラーメッセージ表示 → 入力フォームに戻る
  └─ No ↓
データベースに保存
  ↓
請求書番号を自動採番（INV/YYYY/MM/ID形式）
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 請求書転記フロー

```
開始
  ↓
請求書詳細画面を表示
  ↓
「確認」ボタンをクリック
  ↓
状態を「posted」に更新
  ↓
仕訳明細行を生成
  ├─ 商品行（product）
  ├─ 税行（tax）
  └─ 支払条件行（payment_term）
  ↓
会計仕訳を確定
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.3 小計計算ロジック

```
開始
  ↓
商品単価を取得
  ↓
数量を乗算
  ↓
[割引率が設定されている?]
  ├─ Yes → 割引額を計算して減算
  └─ No ↓
税額を計算
  ↓
小計 = 単価 × 数量 - 割引額
税額 = Tax::collect() で計算
合計 = 小計 + 税額
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\Move | accounts_account_moves | 請求書/仕訳の親モデル |
| Webkul\Account\Models\MoveLine | accounts_account_move_lines | 請求書明細行モデル |
| Webkul\Account\Models\Journal | accounts_journals | 仕訳帳モデル |
| Webkul\Account\Models\PaymentTerm | accounts_payment_terms | 支払条件モデル |
| Webkul\Partner\Models\Partner | partners_partners | 顧客/取引先モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| InvoiceResource | plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php |
| CreateInvoice | InvoiceResource/Pages/CreateInvoice.php |
| EditInvoice | InvoiceResource/Pages/EditInvoice.php |
| ViewInvoice | InvoiceResource/Pages/ViewInvoice.php |
| ListInvoices | InvoiceResource/Pages/ListInvoices.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| journal | belongsTo | Journal | 仕訳帳 |
| partner | belongsTo | Partner | 顧客 |
| lines | hasMany | MoveLine | 商品明細行 |
| allLines | hasMany | MoveLine | 全明細行（商品・税・支払条件含む） |
| taxLines | hasMany | MoveLine | 税明細行 |
| paymentTermLine | hasOne | MoveLine | 支払条件明細行 |
| currency | belongsTo | Currency | 通貨 |
| company | belongsTo | Company | 会社 |
| invoicePaymentTerm | belongsTo | PaymentTerm | 支払条件 |

### 4.4 Enum定義

| Enum名 | 説明 |
|--------|------|
| MoveState | 請求書状態（draft/posted/cancel） |
| MoveType | 移動タイプ（out_invoice/in_invoice/out_refund/in_refund等） |
| PaymentState | 支払状態（not_paid/partial/paid/reversed等） |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 商品未選択 | 明細行の商品が選択されていない | 商品は必須です |
| 数量不正 | 数量が0以下の場合 | 数量は1以上を入力してください |
| 通貨未選択 | 通貨が選択されていない | 通貨は必須です |
| 期日・支払条件未設定 | 両方とも未設定の場合 | 期日または支払条件を設定してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 転記済み請求書の削除時 | 転記済みの請求書は削除できません |
| 編集制限 | 転記済み/取消請求書の編集時 | 該当フィールドを無効化 |
| 重複商品 | 同一明細内で同一商品を選択時 | 選択肢を無効化 |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |
| 税計算エラー | エラーログ出力、0として計算継続 |

## 6. 備考

### 6.1 設計上の考慮事項
- 請求書はMoveモデルを使用し、move_type = 'out_invoice' で識別される
- 請求書番号は「INV/YYYY/MM/ID」形式で自動採番される
- 転記済み請求書は編集・削除が制限される
- 商品の重複選択を防止するため、選択済み商品は選択肢から除外される

### 6.2 パフォーマンス考慮
- 明細行の合計計算はリアルタイム（live）で実行される
- 商品選択は検索可能（searchable）で、大量データにも対応
- 顧客選択時にパートナー情報を一括取得し、支払条件等を自動設定

### 6.3 セキュリティ考慮
- 会社ごとのデータ分離が行われる
- 削除済みデータ（ソフトデリート）の参照には適切なフラグ表示

### 6.4 依存関係
- partners プラグイン（顧客管理）
- support プラグイン（通貨・会社管理）
- Filament フレームワーク（UI提供）

### 6.5 状態遷移図

```
[下書き(draft)]
     │
     ├── 確認 ──→ [転記済み(posted)]
     │                  │
     │                  ├── 支払い ──→ 支払状態更新
     │                  │
     │                  └── 取消 ──→ [取消(cancel)]
     │
     └── 削除 ──→ 削除完了
```
