# 機能設計書: F043 - 返金管理

## 1. 機能概要

### 1.1 機能名
返金管理

### 1.2 機能ID
F043

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
顧客への返金処理を管理する機能を提供する。売上請求書に対するクレジットノート（貸方票）の作成・管理を行い、返品や値引きに伴う返金処理を記録する。請求書管理と同様にMoveモデルを使用し、move_type = 'out_refund' で識別される。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目（基本情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 顧客 | 選択 | 任意 | - | 返金対象顧客の選択 |
| 返金日 | 日付 | 任意 | - | 返金伝票の発行日 |
| 期日 | 日付 | 条件付必須 | - | 返金期日 |
| 支払条件 | 選択 | 条件付必須 | - | 支払条件の選択 |
| 会社 | 選択 | 任意 | - | 発行元会社 |
| 通貨 | 選択 | 必須 | - | 返金の通貨 |
| 逆仕訳参照 | 選択 | 任意 | - | 元の請求書への参照 |

#### 画面入力項目（明細行）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 商品 | 選択 | 必須 | - | 返金対象商品 |
| 数量 | 数値 | 必須 | - | 返金数量 |
| 単位 | 選択 | 条件付必須 | - | 単位（UOM有効時のみ） |
| 単価 | 数値 | 必須 | - | 商品単価 |
| 割引率 | 数値 | 任意 | - | 割引率（%） |
| 税 | 選択(複数) | 任意 | - | 適用する税 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 返金番号 | 自動採番された返金番号 |
| 顧客名 | 返金対象顧客名 |
| 返金日 | 返金伝票発行日 |
| 期日 | 返金期日 |
| 税抜金額 | 税抜きの合計金額 |
| 合計金額 | 税込みの合計金額 |
| 状態 | 返金伝票の状態 |
| 支払状態 | 支払状態 |

## 3. 処理フロー

### 3.1 返金伝票作成フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示（状態: 下書き）
  ↓
基本情報を入力
  ↓
明細行を追加
  ├─ 商品を選択
  ├─ 数量・単価を入力
  ├─ 税を選択
  └─ 小計を自動計算
  ↓
合計金額を自動計算
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
データベースに保存
  ↓
返金番号を自動採番（RINV/YYYY/MM/ID形式）
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 請求書からの返金作成フロー

```
開始
  ↓
元の請求書詳細画面を表示
  ↓
「返金を作成」アクションをクリック
  ↓
元の請求書情報をコピーして返金伝票を作成
  ├─ 顧客情報をコピー
  ├─ 明細行をコピー（金額は負値または逆仕訳として）
  └─ 逆仕訳参照を設定
  ↓
返金伝票編集画面を表示
  ↓
必要に応じて内容を調整
  ↓
保存・確定
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\Move | accounts_account_moves | 返金/仕訳の親モデル |
| Webkul\Account\Models\MoveLine | accounts_account_move_lines | 返金明細行モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| RefundResource | plugins/webkul/accounts/src/Filament/Resources/RefundResource.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| reversedEntry | belongsTo | Move | 逆仕訳参照（元の請求書） |
| partner | belongsTo | Partner | 顧客 |
| lines | hasMany | MoveLine | 返金明細行 |
| currency | belongsTo | Currency | 通貨 |

### 4.4 MoveType区分

| 値 | 説明 |
|-----|------|
| out_refund | 売上返金（顧客への返金） |
| in_refund | 仕入返金（仕入先からの返金） |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 商品未選択 | 明細行の商品が選択されていない | 商品は必須です |
| 数量不正 | 数量が0以下の場合 | 数量は1以上を入力してください |
| 通貨未選択 | 通貨が選択されていない | 通貨は必須です |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 転記済み返金伝票の削除時 | 転記済みの返金伝票は削除できません |
| 編集制限 | 転記済み/取消状態の編集時 | 該当フィールドを無効化 |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |

## 6. 備考

### 6.1 設計上の考慮事項
- 返金伝票はMoveモデルを使用し、move_type = 'out_refund' で識別される
- 返金番号は「RINV/YYYY/MM/ID」形式で自動採番される
- 元の請求書への参照（reversed_entry_id）を保持可能
- 請求書と同様の編集制限ルールが適用される

### 6.2 会計処理
- 返金は売上の逆仕訳として処理される
- 税の配分も請求書と同様のロジックで計算される

### 6.3 依存関係
- accounts プラグイン（請求書管理機能と共有）
- partners プラグイン（顧客管理）
- Filament フレームワーク（UI提供）
