# 機能設計書: F044 - 仕訳帳管理

## 1. 機能概要

### 1.1 機能名
仕訳帳管理

### 1.2 機能ID
F044

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
会計システムにおける仕訳帳（Journal）の管理機能を提供する。仕訳帳は会計取引を記録するための帳簿であり、売上、仕入、銀行、現金、クレジットカードなど取引種別ごとに分類される。各仕訳帳にはデフォルト勘定科目、サスペンス勘定、損益勘定などを設定でき、会計処理の基盤となる。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 名前 | テキスト | 必須 | 255 | 仕訳帳名 |
| コード | テキスト | 任意 | 255 | 仕訳帳コード |
| 種類 | 選択 | 必須 | - | 仕訳帳種類（sale/purchase/bank/cash/credit/general） |
| 会社 | 選択 | 任意 | - | 所属会社 |
| 通貨 | 選択 | 任意 | - | 使用通貨 |
| デフォルト勘定科目 | 選択 | 任意 | - | デフォルトの勘定科目 |
| サスペンス勘定 | 選択 | 任意 | - | サスペンス勘定科目 |
| 損益勘定（利益） | 選択 | 任意 | - | 利益用勘定科目 |
| 損益勘定（損失） | 選択 | 任意 | - | 損失用勘定科目 |
| 銀行口座 | 選択 | 任意 | - | 紐づく銀行口座 |
| 色 | カラーピッカー | 任意 | - | 表示色 |
| 請求書参照タイプ | 選択 | 任意 | - | 請求書参照の形式 |
| ダッシュボード表示 | トグル | 任意 | - | ダッシュボードに表示するか |
| 転記時自動チェック | トグル | 任意 | - | 転記時に自動チェックするか |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 仕訳帳名 | 仕訳帳の名称 |
| コード | 仕訳帳コード |
| 種類 | 仕訳帳の種類 |
| 会社 | 所属会社名 |
| 通貨 | 使用通貨 |
| デフォルト勘定科目 | デフォルトの勘定科目名 |
| 作成日時 | レコード作成日時 |
| 更新日時 | レコード更新日時 |

## 3. 処理フロー

### 3.1 仕訳帳登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
仕訳帳名・種類を入力（必須）
  ↓
必要に応じて勘定科目を設定
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
[バリデーションエラー?]
  ├─ Yes → エラーメッセージ表示 → 入力フォームに戻る
  └─ No ↓
データベースに保存
  ↓
[種類がbank/cash/credit?]
  ├─ Yes → 支払方法ラインを自動生成
  └─ No ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 支払方法ライン自動生成フロー

```
開始
  ↓
仕訳帳の種類を確認
  ↓
[bank/cash/creditの場合]
  ↓
既存のinbound支払方法ラインを削除
  ↓
アクティブなinbound支払方法を取得
  ↓
各支払方法に対してPaymentMethodLineを作成
  ├─ name: 支払方法名
  ├─ payment_method_id: 支払方法ID
  └─ type: 'inbound'
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\Journal | accounts_journals | 仕訳帳モデル |
| Webkul\Account\Models\Account | accounts_accounts | 勘定科目モデル |
| Webkul\Account\Models\PaymentMethodLine | accounts_payment_method_lines | 支払方法ラインモデル |
| Webkul\Account\Models\PaymentMethod | accounts_payment_methods | 支払方法マスタモデル |
| Webkul\Partner\Models\BankAccount | partners_bank_accounts | 銀行口座モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| JournalResource | plugins/webkul/accounts/src/Filament/Resources/JournalResource.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| company | belongsTo | Company | 所属会社 |
| currency | belongsTo | Currency | 使用通貨 |
| defaultAccount | belongsTo | Account | デフォルト勘定科目 |
| suspenseAccount | belongsTo | Account | サスペンス勘定科目 |
| profitAccount | belongsTo | Account | 利益勘定科目 |
| lossAccount | belongsTo | Account | 損失勘定科目 |
| bankAccount | belongsTo | BankAccount | 銀行口座 |
| allowedAccounts | belongsToMany | Account | 許可された勘定科目（中間テーブル: accounts_journal_accounts） |
| inboundPaymentMethodLines | hasMany | PaymentMethodLine | 入金用支払方法ライン |
| outboundPaymentMethodLines | hasMany | PaymentMethodLine | 出金用支払方法ライン |

### 4.4 JournalType Enum

| 値 | 説明 |
|-----|------|
| SALE | 売上仕訳帳 |
| PURCHASE | 仕入仕訳帳 |
| BANK | 銀行仕訳帳 |
| CASH | 現金仕訳帳 |
| CREDIT_CARD | クレジットカード仕訳帳 |
| GENERAL | 一般仕訳帳 |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 仕訳帳名が空の場合 | 仕訳帳名は必須です |
| 種類未選択 | 種類が選択されていない場合 | 種類は必須です |
| 文字数超過 | 名前が255文字を超える場合 | 255文字以内で入力してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 仕訳帳に紐づく仕訳が存在する場合 | この仕訳帳には仕訳が存在するため削除できません |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |
| トランザクションエラー | ロールバック実行、エラーログ出力 |

## 6. 備考

### 6.1 設計上の考慮事項
- 仕訳帳はソート可能（Sortable）インターフェースを実装し、表示順序を管理可能
- 銀行・現金・クレジットカード種類の仕訳帳作成時、自動的に支払方法ラインが生成される
- 勘定科目との紐づけにより、仕訳入力時のデフォルト値を設定可能

### 6.2 パフォーマンス考慮
- 勘定科目選択は検索可能（searchable）で、大量データにも対応
- 関連モデルの取得にはEager Loadingを使用

### 6.3 セキュリティ考慮
- 会社ごとのデータ分離が行われる
- 作成者情報（creator_id）を記録

### 6.4 依存関係
- support プラグイン（会社・通貨管理）
- partners プラグイン（銀行口座管理）
- Filament フレームワーク（UI提供）
