# 機能設計書: F045 - 税グループ管理

## 1. 機能概要

### 1.1 機能名
税グループ管理

### 1.2 機能ID
F045

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
税をグループ化して管理する機能を提供する。税グループは複数の税を論理的にまとめ、請求書や帳票での表示順序や小計表示位置を制御する。国・会社ごとに異なる税グループを設定でき、税計算の柔軟な運用を可能にする。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 名前 | テキスト | 必須 | 255 | 税グループ名 |
| 会社 | 選択 | 任意 | - | 所属会社 |
| 国 | 選択 | 任意 | - | 適用国 |
| 前小計 | テキスト | 任意 | 255 | 小計を表示する前のラベル |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 会社 | 所属会社名 |
| 国 | 適用国名 |
| 作成者 | レコード作成者 |
| 名前 | 税グループ名 |
| 前小計 | 小計表示ラベル |
| 作成日時 | レコード作成日時 |
| 更新日時 | レコード更新日時 |

## 3. 処理フロー

### 3.1 税グループ登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
税グループ名を入力（必須）
  ↓
必要に応じて会社・国を選択
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
[バリデーションエラー?]
  ├─ Yes → エラーメッセージ表示 → 入力フォームに戻る
  └─ No ↓
作成者ID（creator_id）を設定
  ↓
データベースに保存
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 税グループ削除フロー

```
開始
  ↓
一覧から税グループを選択
  ↓
削除ボタンをクリック
  ↓
確認ダイアログ表示
  ↓
[削除確認?]
  ├─ No → キャンセル → 終了
  └─ Yes ↓
[紐づく税が存在?]
  ├─ Yes → エラー通知表示 → 終了
  └─ No ↓
データベースから削除
  ↓
成功メッセージ表示
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\TaxGroup | accounts_tax_groups | 税グループモデル |
| Webkul\Account\Models\Tax | accounts_taxes | 税モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| TaxGroupResource | plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php |
| ListTaxGroups | TaxGroupResource/Pages/ListTaxGroups.php |
| CreateTaxGroup | TaxGroupResource/Pages/CreateTaxGroup.php |
| EditTaxGroup | TaxGroupResource/Pages/EditTaxGroup.php |
| ViewTaxGroup | TaxGroupResource/Pages/ViewTaxGroup.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| company | belongsTo | Company | 所属会社 |
| country | belongsTo | Country | 適用国 |
| createdBy | belongsTo | User | 作成者 |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 税グループ名が空の場合 | 名前は必須です |
| 文字数超過 | 名前が255文字を超える場合 | 255文字以内で入力してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除エラー | 紐づく税が存在する場合 | QueryExceptionをキャッチしてエラー通知 |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |
| 削除時のQueryException | エラー通知を表示（削除失敗メッセージ） |

## 6. 備考

### 6.1 設計上の考慮事項
- 税グループはソート可能（Sortable）インターフェースを実装し、表示順序を管理可能
- 税の作成フォームから直接税グループを作成可能（createOptionForm）
- ナビゲーション登録は無効化されており、設定画面からのみアクセス

### 6.2 テーブル機能
- グループ化機能: 名前、会社、国、作成者、作成日時、更新日時でグループ化可能
- 一括削除機能をサポート

### 6.3 依存関係
- support プラグイン（会社・国管理）
- security プラグイン（ユーザー管理）
- Filament フレームワーク（UI提供）
