# 機能設計書: F046 - 税管理

## 1. 機能概要

### 1.1 機能名
税管理

### 1.2 機能ID
F046

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
税（Tax）の作成・編集・管理を行う機能を提供する。売上税、仕入税、消費税など各種税率を管理し、請求書や仕入伝票での税計算に使用する。税グループとの紐づけ、価格への含有設定、税配分（請求書用・返金用）の自動生成など、会計処理に必要な税設定を一元管理する。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目（基本情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 名前 | テキスト | 必須 | 255 | 税名称 |
| 税タイプ | 選択 | 必須 | - | 使用区分（売上/仕入/なし） |
| 税計算 | 選択 | 必須 | - | 計算方法（固定/パーセント等） |
| 税スコープ | 選択 | 任意 | - | 適用範囲 |
| ステータス | トグル | 任意 | - | 有効/無効 |
| 税額/税率 | 数値 | 必須 | - | 税額または税率（%） |

#### 画面入力項目（詳細設定）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 請求書ラベル | テキスト | 任意 | 255 | 請求書上の表示ラベル |
| 税グループ | 選択 | 必須 | - | 所属する税グループ |
| 国 | 選択 | 任意 | - | 適用国 |
| 価格含有オーバーライド | 選択 | 任意 | - | 価格に税を含むかの設定 |
| 基準額に含める | トグル | 任意 | - | 後続税計算の基準に含めるか |
| 基準額の影響を受ける | トグル | 任意 | - | 前の税の影響を受けるか |
| 説明 | リッチテキスト | 任意 | - | 税の説明 |
| 法的注記 | リッチテキスト | 任意 | - | 請求書に表示する法的注記 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 名前 | 税名称 |
| 会社 | 所属会社名 |
| 税グループ | 所属税グループ名 |
| 国 | 適用国名 |
| 税タイプ | 使用区分 |
| 請求書ラベル | 請求書上の表示ラベル |
| ステータス | 有効/無効アイコン |

## 3. 処理フロー

### 3.1 税登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
基本情報を入力
  ├─ 名前（必須）
  ├─ 税タイプ（必須）
  ├─ 税計算方法（必須）
  └─ 税額/税率（必須）
  ↓
詳細設定を入力
  ├─ 税グループ選択（必須）
  └─ その他オプション
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
データベースに保存
  ↓
税配分レコードを自動生成
  ├─ 請求書用配分（BASE + TAX）
  └─ 返金用配分（BASE + TAX）
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 税配分自動生成フロー

```
開始
  ↓
税レコード作成完了
  ↓
請求書用配分を作成
  ├─ BASEタイプ（repartition_type: base, factor: null）
  └─ TAXタイプ（repartition_type: tax, factor: 1, factor_percent: 100）
  ↓
返金用配分を作成
  ├─ BASEタイプ（repartition_type: base, factor: null）
  └─ TAXタイプ（repartition_type: tax, factor: 1, factor_percent: 100）
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\Tax | accounts_taxes | 税モデル |
| Webkul\Account\Models\TaxGroup | accounts_tax_groups | 税グループモデル |
| Webkul\Account\Models\TaxPartition | accounts_tax_partition_lines | 税配分モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| TaxResource | plugins/webkul/accounts/src/Filament/Resources/TaxResource.php |
| ListTaxes | TaxResource/Pages/ListTaxes.php |
| CreateTax | TaxResource/Pages/CreateTax.php |
| EditTax | TaxResource/Pages/EditTax.php |
| ViewTax | TaxResource/Pages/ViewTax.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| company | belongsTo | Company | 所属会社 |
| taxGroup | belongsTo | TaxGroup | 所属税グループ |
| country | belongsTo | Country | 適用国 |
| createdBy | belongsTo | User | 作成者 |
| cashBasisTransitionAccount | belongsTo | Account | 現金主義移行勘定 |
| distributionForInvoice | hasMany | TaxPartition | 請求書用配分 |
| distributionForRefund | hasMany | TaxPartition | 返金用配分 |
| parentTaxes | belongsToMany | Tax | 親税（中間テーブル: accounts_tax_taxes） |

### 4.4 Enum定義

| Enum名 | 説明 |
|--------|------|
| TypeTaxUse | 税タイプ（sale/purchase/none） |
| AmountType | 計算方法（percent/fixed/group等） |
| TaxScope | 税スコープ |
| TaxIncludeOverride | 価格含有オーバーライド |
| RepartitionType | 配分タイプ（base/tax） |
| DocumentType | ドキュメントタイプ（invoice/refund） |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 名前が空の場合 | 名前は必須です |
| 税グループ未選択 | 税グループが選択されていない場合 | 税グループは必須です |
| 税額不正 | 税額が0未満または上限超過の場合 | 0以上99999999999以下で入力してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除エラー | 紐づくデータが存在する場合 | QueryExceptionをキャッチしてエラー通知 |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |

## 6. 備考

### 6.1 設計上の考慮事項
- 税はソート可能（Sortable）インターフェースを実装し、表示順序を管理可能
- 税作成時、請求書用・返金用の配分レコードが自動生成される
- 税グループ作成フォームが税作成フォーム内に組み込まれている（createOptionForm）
- ナビゲーション登録は無効化されており、設定画面からのみアクセス

### 6.2 税計算
- Tax::collect()ファサードを通じて税計算が実行される
- 複数税の適用時、include_base_amount/is_base_affected設定に基づいて計算順序が決定される

### 6.3 依存関係
- accounts プラグイン（税グループ管理）
- support プラグイン（会社・国管理）
- security プラグイン（ユーザー管理）
- Filament フレームワーク（UI提供）
