# 機能設計書: F047 - 財政ポジション管理

## 1. 機能概要

### 1.1 機能名
財政ポジション管理

### 1.2 機能ID
F047

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
財政ポジション（Fiscal Position）の管理機能を提供する。財政ポジションは、取引先の所在地（国・地域）に基づいて適用する税の自動変換ルールを定義する。例えば、EU域内取引や免税取引など、特定の条件に該当する場合に通常の税から別の税へ自動的に置換する仕組みを実現する。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 名前 | テキスト | 必須 | 255 | 財政ポジション名 |
| 外国VAT | テキスト | 必須 | 255 | 外国VAT番号 |
| 国 | 選択 | 任意 | - | 適用国 |
| 国グループ | 選択 | 任意 | - | 適用国グループ |
| 郵便番号（From） | テキスト | 必須 | 255 | 適用郵便番号範囲の開始値 |
| 郵便番号（To） | テキスト | 必須 | 255 | 適用郵便番号範囲の終了値 |
| 自動検出 | トグル | 任意 | - | 取引先情報から自動検出するか |
| 備考 | リッチテキスト | 任意 | - | 備考・メモ |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 名前 | 財政ポジション名 |
| 会社 | 所属会社名 |
| 国 | 適用国名 |
| 国グループ | 適用国グループ名 |
| 作成者 | レコード作成者 |
| 郵便番号（From） | 適用郵便番号範囲の開始値 |
| 郵便番号（To） | 適用郵便番号範囲の終了値 |
| 自動検出 | 自動検出フラグ |

## 3. 処理フロー

### 3.1 財政ポジション登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
基本情報を入力
  ├─ 名前（必須）
  ├─ 外国VAT（必須）
  ├─ 国または国グループを選択
  └─ 郵便番号範囲を入力
  ↓
オプション設定
  ├─ 自動検出フラグ
  └─ 備考
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
データベースに保存
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 税マッピング管理フロー

```
開始
  ↓
財政ポジション詳細画面を表示
  ↓
「税マッピング」タブを選択
  ↓
税マッピングを追加/編集
  ├─ 元の税を選択
  └─ 置換後の税を選択
  ↓
保存
  ↓
請求書作成時に自動適用
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\FiscalPosition | accounts_fiscal_positions | 財政ポジションモデル |
| Webkul\Account\Models\FiscalPositionTax | accounts_fiscal_position_taxes | 財政ポジション税マッピングモデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| FiscalPositionResource | plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource.php |
| ListFiscalPositions | FiscalPositionResource/Pages/ListFiscalPositions.php |
| CreateFiscalPosition | FiscalPositionResource/Pages/CreateFiscalPosition.php |
| EditFiscalPosition | FiscalPositionResource/Pages/EditFiscalPosition.php |
| ViewFiscalPosition | FiscalPositionResource/Pages/ViewFiscalPosition.php |
| ManageFiscalPositionTax | FiscalPositionResource/Pages/ManageFiscalPositionTax.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| company | belongsTo | Company | 所属会社 |
| country | belongsTo | Country | 適用国 |
| countryGroup | belongsTo | Country | 適用国グループ |
| createdBy | belongsTo | User | 作成者 |
| fiscalPositionTaxes | hasMany | FiscalPositionTax | 税マッピング |

### 4.4 RelationManager

| 名前 | 説明 |
|------|------|
| FiscalPositionTaxRelationManager | 税マッピングの管理 |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 名前が空の場合 | 名前は必須です |
| 外国VAT未入力 | 外国VATが空の場合 | 外国VATは必須です |
| 郵便番号未入力 | 郵便番号範囲が空の場合 | 郵便番号は必須です |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 使用中の財政ポジション削除時 | 削除できません |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |

## 6. 備考

### 6.1 設計上の考慮事項
- 財政ポジションはソート可能（Sortable）インターフェースを実装
- サブナビゲーション機能により、詳細画面・編集画面・税マッピング画面間を簡単に移動可能
- RelationGroupを使用して税マッピングをグループ化して表示
- ナビゲーション登録は無効化されており、設定画面からのみアクセス

### 6.2 自動検出機能
- auto_replyフラグが有効な場合、取引先の住所情報に基づいて財政ポジションを自動選択
- 国・国グループ・郵便番号範囲の条件に合致する場合に適用

### 6.3 依存関係
- support プラグイン（会社・国管理）
- security プラグイン（ユーザー管理）
- Filament フレームワーク（UI提供）
