# 機能設計書: F048 - 銀行口座管理

## 1. 機能概要

### 1.1 機能名
銀行口座管理

### 1.2 機能ID
F048

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
銀行口座（Bank Account）の管理機能を提供する。取引先やシステムで使用する銀行口座情報を登録・管理し、請求書や支払処理に紐づける。partnersプラグインのBankAccountResourceを継承し、会計モジュール向けにカスタマイズされている。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 口座番号 | テキスト | 必須 | 255 | 銀行口座番号（一意） |
| 銀行 | 選択 | 必須 | - | 銀行の選択 |
| 口座名義人 | 選択 | 必須 | - | 口座保有者（パートナー）の選択 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 口座番号 | 銀行口座番号 |
| 銀行 | 銀行名 |
| 口座名義人 | 口座保有者名 |
| 削除日時 | ソフトデリート日時 |
| 作成日時 | レコード作成日時 |
| 更新日時 | レコード更新日時 |

## 3. 処理フロー

### 3.1 銀行口座登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
口座番号を入力（必須・一意）
  ↓
銀行を選択（必須）
  ↓
口座名義人（パートナー）を選択（必須）
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
[バリデーションエラー?]
  ├─ Yes → エラーメッセージ表示 → 入力フォームに戻る
  └─ No ↓
account_holder_name を自動設定（partner.name）
  ↓
データベースに保存
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 銀行口座削除フロー

```
開始
  ↓
一覧から銀行口座を選択
  ↓
削除ボタンをクリック
  ↓
確認ダイアログ表示
  ↓
[削除確認?]
  ├─ No → キャンセル → 終了
  └─ Yes ↓
ソフトデリート実行
  ↓
成功メッセージ表示
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Partner\Models\BankAccount | partners_bank_accounts | 銀行口座モデル |
| Webkul\Support\Models\Bank | banks | 銀行マスタモデル |
| Webkul\Partner\Models\Partner | partners_partners | パートナーモデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| BankAccountResource (accounts) | plugins/webkul/accounts/src/Filament/Resources/BankAccountResource.php |
| BaseBankAccountResource (partners) | plugins/webkul/partners/src/Filament/Resources/BankAccountResource.php |
| ListBankAccounts | BankAccountResource/Pages/ListBankAccounts.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| bank | belongsTo | Bank | 銀行マスタ |
| partner | belongsTo | Partner | 口座名義人（パートナー） |
| creator | belongsTo | User | 作成者 |

### 4.4 継承関係

accounts版のBankAccountResourceはpartners版のBankAccountResourceを継承し、以下のカスタマイズを実施:
- フォームから一部コンポーネント（2番目）を削除
- テーブルからcan_send_money列を削除

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 口座番号が空の場合 | 口座番号は必須です |
| 一意性違反 | 同一口座番号が存在する場合 | この口座番号は既に使用されています |
| 銀行未選択 | 銀行が選択されていない場合 | 銀行は必須です |
| 名義人未選択 | 口座名義人が選択されていない場合 | 口座名義人は必須です |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 復元エラー | 復元処理失敗時 | 復元に失敗しました |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |

## 6. 備考

### 6.1 設計上の考慮事項
- ソフトデリート（SoftDeletes）を使用し、削除されたレコードも復元可能
- partnersプラグインのBankAccountResourceを継承し、会計向けにカスタマイズ
- account_holder_nameは作成・更新時にpartner.nameから自動設定
- 削除済み銀行の選択肢には「(Deleted)」ラベルが付与され、選択不可

### 6.2 テーブル機能
- グループ化機能: 銀行、送金可否、作成日時でグループ化可能
- フィルター機能: 送金可否、銀行、口座名義人、作成者でフィルタ可能
- ソフトデリート対応: 削除済みレコードの表示・復元・完全削除をサポート

### 6.3 一括操作
- 一括復元
- 一括削除（ソフトデリート）
- 一括完全削除（強制削除）

### 6.4 依存関係
- partners プラグイン（基底リソース提供）
- support プラグイン（銀行マスタ管理）
- security プラグイン（ユーザー管理）
- Filament フレームワーク（UI提供）
