# 機能設計書: F049 - 支払条件管理

## 1. 機能概要

### 1.1 機能名
支払条件管理

### 1.2 機能ID
F049

### 1.3 対象プラグイン
accounts

### 1.4 機能説明
支払条件（Payment Term）の管理機能を提供する。請求書の支払期日を自動計算するためのルールを定義し、分割払いや早期支払割引などの複雑な支払条件を設定できる。支払期日の計算方法、早期割引条件、支払明細（Due Term）を管理する。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目（基本情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 支払条件名 | テキスト | 必須 | 255 | 支払条件の名称 |
| 早期割引 | トグル | 任意 | - | 早期割引を有効にするか |

#### 画面入力項目（早期割引設定 - early_discount有効時）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 割引率 | 数値 | 必須 | - | 割引率（0-100%） |
| 割引日数 | 整数 | 必須 | - | 割引適用期限の日数 |
| 減額税適用 | 選択 | 任意 | - | 早期支払時の税処理方法 |

#### 画面入力項目（その他）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 備考 | リッチテキスト | 任意 | - | 支払条件の説明・備考 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 支払条件名 | 支払条件の名称 |
| 会社 | 所属会社名 |
| 作成日時 | レコード作成日時 |
| 更新日時 | レコード更新日時 |

## 3. 処理フロー

### 3.1 支払条件登録フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示
  ↓
支払条件名を入力（必須）
  ↓
[早期割引を有効にする?]
  ├─ Yes → 割引率・割引日数・減額税適用を入力
  └─ No ↓
備考を入力（任意）
  ↓
保存ボタンをクリック
  ↓
バリデーション実行
  ↓
データベースに保存
  ↓
デフォルト支払期日条件を自動生成
  ├─ value: percent
  ├─ value_amount: 100
  ├─ delay_type: days_after
  └─ nb_days: 0
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 支払期日条件管理フロー

```
開始
  ↓
支払条件詳細画面を表示
  ↓
「支払期日条件」タブを選択
  ↓
期日条件を追加/編集
  ├─ 値タイプ（パーセント/固定額）
  ├─ 金額/割合
  ├─ 遅延タイプ（日数後/月末等）
  └─ 日数
  ↓
保存
  ↓
請求書作成時に期日を自動計算
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Account\Models\PaymentTerm | accounts_payment_terms | 支払条件モデル |
| Webkul\Account\Models\PaymentDueTerm | accounts_payment_due_terms | 支払期日条件モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| PaymentTermResource | plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php |
| ListPaymentTerms | PaymentTermResource/Pages/ListPaymentTerms.php |
| CreatePaymentTerm | PaymentTermResource/Pages/CreatePaymentTerm.php |
| EditPaymentTerm | PaymentTermResource/Pages/EditPaymentTerm.php |
| ViewPaymentTerm | PaymentTermResource/Pages/ViewPaymentTerm.php |
| ManagePaymentDueTerm | PaymentTermResource/Pages/ManagePaymentDueTerm.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| company | belongsTo | Company | 所属会社 |
| createdBy | belongsTo | User | 作成者 |
| dueTerm | hasOne | PaymentDueTerm | 支払期日条件 |

### 4.4 Enum定義

| Enum名 | 説明 |
|--------|------|
| EarlyPayDiscount | 早期支払割引の税処理（included/excluded等） |
| DueTermValue | 期日条件値タイプ（percent/fixed） |
| DelayType | 遅延タイプ（days_after/end_of_month等） |

### 4.5 RelationManager

| 名前 | 説明 |
|------|------|
| PaymentDueTermRelationManager | 支払期日条件の管理 |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 必須項目未入力 | 支払条件名が空の場合 | 支払条件名は必須です |
| 割引率不正 | 割引率が0-100の範囲外の場合 | 0から100の間で入力してください |
| 文字数超過 | 名前が255文字を超える場合 | 255文字以内で入力してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 使用中の支払条件削除時 | 使用中のため削除できません |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |

## 6. 備考

### 6.1 設計上の考慮事項
- ソフトデリート（SoftDeletes）を使用し、削除されたレコードも復元可能
- 支払条件作成時、デフォルトの支払期日条件が自動生成される
- サブナビゲーション機能により、詳細画面・編集画面・期日条件画面間を簡単に移動可能
- ナビゲーション登録は無効化されており、設定画面からのみアクセス

### 6.2 自動生成されるデフォルト期日条件

```
value: percent (パーセント指定)
value_amount: 100 (100%)
delay_type: days_after (日数後)
days_next_month: 10
nb_days: 0 (即日)
```

### 6.3 早期割引設定
- early_discountフラグがオンの場合のみ、割引設定入力欄が表示される
- 動的フォーム（live）で表示/非表示を制御

### 6.4 テーブル機能
- グループ化機能: 会社名、割引日数、早期支払割引、支払条件名、請求書表示、早期割引、割引率でグループ化可能
- ソフトデリート対応: 復元・完全削除をサポート

### 6.5 依存関係
- support プラグイン（会社管理）
- security プラグイン（ユーザー管理）
- Filament フレームワーク（UI提供）
