# 機能設計書: チーム管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F005 |
| 機能名 | チーム管理 |
| 機能概要 | ユーザーをグループ化するチームの作成・編集・削除、およびチームへのユーザー割り当てを行う |
| 関連画面 | SCR-TEAM-001（チーム一覧）、SCR-TEAM-002（チーム作成）、SCR-TEAM-003（チーム詳細）、SCR-TEAM-004（チーム編集） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

チーム管理機能は、ユーザーを論理的なグループ（チーム）に編成するための機能を提供する。チームは組織構造やプロジェクトチームの表現に使用され、多対多の関係でユーザーと紐付けられる。

#### 主な機能
1. **チーム一覧表示**: 登録済みチームをテーブル形式で表示
2. **チーム作成**: 新規チームの登録
3. **チーム編集**: 既存チーム情報の更新
4. **チーム削除**: チームの削除
5. **ユーザー割り当て**: チームへのユーザーメンバー追加・削除

### 2.2 処理フロー

#### チーム作成フロー
```
[開始]
   |
   v
[チーム作成画面表示]
   |
   v
[チーム名入力]
   |
   v
[メンバー選択（オプション）]
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フォーム入力]
   |
   v (OK)
[teamsテーブルにレコード作成]
   |
   v
[user_teamテーブルに関係レコード作成]
   |
   v
[チーム詳細画面へリダイレクト]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| name | string | YES | max:255 | チーム名 |
| users | array | NO | exists:users,id | チームメンバーのユーザーID配列 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | チームID |
| name | string | チーム名 |
| users | array | 所属ユーザー一覧 |
| users_count | integer | メンバー数 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | チーム名一意性推奨 | チーム名は一意であることを推奨（強制ではない） |
| BR-002 | 多対多関係 | 1ユーザーは複数チームに所属可能、1チームは複数ユーザーを含む |
| BR-003 | メンバーなしチーム | メンバーが0人のチームも作成可能 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| teams | チーム情報管理 | SELECT, INSERT, UPDATE, DELETE |
| user_team | ユーザー-チーム関係 | SELECT, INSERT, DELETE |
| users | ユーザー情報参照 | SELECT |

### 4.2 テーブル定義（teams）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| name | varchar(255) | NO | - | チーム名 |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

### 4.3 テーブル定義（user_team）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| user_id | bigint | NO | - | ユーザーID（FK） |
| team_id | bigint | NO | - | チームID（FK） |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| TeamResource | plugins/webkul/security/src/Filament/Resources/TeamResource.php | チーム管理Filamentリソース |
| Team | plugins/webkul/security/src/Models/Team.php | チームモデル |
| User | plugins/webkul/security/src/Models/User.php | ユーザーモデル（リレーション定義） |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/security | 必須（User/Team管理） |
| filament/filament | 必須（管理画面UI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_team | チーム一覧・詳細の閲覧 |
| view_any_team | 全チームの閲覧 |
| create_team | チーム作成 |
| update_team | チーム更新 |
| delete_team | チーム削除 |

### 6.2 セキュリティ考慮事項

- チーム管理は管理者権限を持つユーザーのみアクセス可能
- チームメンバーシップの変更は監査ログに記録（推奨）

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内 |
| チーム作成応答時間 | 500ms以内 |
| メンバー追加応答時間 | 500ms以内 |

### 7.2 可用性

- 中間テーブル操作はトランザクション管理

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| TEAM-001 | チーム作成失敗 | ロールバック、エラーログ出力 |
| TEAM-002 | メンバー追加失敗 | ロールバック、エラー通知 |
| TEAM-003 | 存在しないユーザー指定 | バリデーションエラー表示 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | チーム一覧が正しく表示されること |
| T-002 | チーム作成 | チーム名入力で正常に作成できること |
| T-003 | メンバー追加 | チームにユーザーを追加できること |
| T-004 | メンバー削除 | チームからユーザーを削除できること |
| T-005 | チーム削除 | チームが削除されること |
| T-006 | 複数チーム所属 | 1ユーザーが複数チームに所属できること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
