# 機能設計書: F050 - 請求書管理(仕入)

## 1. 機能概要

### 1.1 機能名
請求書管理(仕入)

### 1.2 機能ID
F050

### 1.3 対象プラグイン
invoices

### 1.4 機能説明
仕入先からの請求書（Bill）の作成・編集・管理を行う機能を提供する。仕入先への支払管理、仕入明細の登録、支払状況の追跡を一元管理する。accountsプラグインのBillResourceを継承し、invoicesプラグイン向けにカスタマイズされている。売上請求書（Invoice）と同様のMoveモデルを使用するが、move_type = 'in_invoice' で識別される。

## 2. 入力/出力仕様

### 2.1 入力仕様

#### 画面入力項目（基本情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 仕入先 | 選択 | 任意 | - | 仕入先ベンダーの選択（sub_type: supplier） |
| 請求日 | 日付 | 任意 | - | 仕入請求書の発行日 |
| 請求参照 | テキスト | 任意 | 255 | 仕入先からの請求書番号 |
| 会計日 | 日付 | 任意 | - | 会計上の計上日 |
| 支払参照 | テキスト | 任意 | 255 | 支払時の参照番号 |
| 受取銀行 | 選択 | 任意 | - | 支払先銀行口座 |
| 期日 | 日付 | 条件付必須 | - | 支払期日（支払条件未設定時は必須） |
| 支払条件 | 選択 | 条件付必須 | - | 支払条件の選択（期日未設定時は必須） |

#### 画面入力項目（明細行）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| 商品 | 選択 | 必須 | - | 仕入商品 |
| 数量 | 数値 | 必須 | - | 仕入数量（デフォルト: 1） |
| 単位 | 選択 | 条件付必須 | - | 単位（UOM有効時のみ） |
| 税 | 選択(複数) | 任意 | - | 適用する仕入税 |
| 割引率 | 数値 | 任意 | - | 割引率（%） |
| 単価 | 数値 | 必須 | - | 仕入単価 |
| 小計 | 数値 | - | - | 自動計算 |

#### 画面入力項目（その他情報）

| 項目名 | 型 | 必須 | 最大長 | 説明 |
|--------|-----|------|--------|------|
| インコタームズ | 選択 | 任意 | - | 貿易条件 |
| インコタームズ場所 | テキスト | 任意 | 255 | 貿易条件の場所 |
| 支払方法 | 選択 | 任意 | - | 支払方法 |
| 自動転記 | トグル | 任意 | - | 自動転記フラグ |
| 確認済み | トグル | 任意 | - | 確認済みフラグ |
| 会社 | 選択 | 任意 | - | 購入元会社 |
| 通貨 | 選択 | 必須 | - | 請求書の通貨 |
| 備考 | リッチテキスト | 任意 | - | 条件・注意事項 |

### 2.2 出力仕様

#### 一覧画面表示項目

| 項目名 | 説明 |
|--------|------|
| 請求書番号 | 自動採番された仕入請求書番号 |
| 仕入先名 | 仕入先ベンダー名 |
| 請求日 | 仕入請求書発行日 |
| 期日 | 支払期日 |
| 税抜金額 | 税抜きの合計金額 |
| 合計金額 | 税込みの合計金額 |
| 状態 | 請求書の状態（下書き/転記済み/取消） |
| 支払状態 | 支払状態（未払い/一部支払い/支払済み） |

## 3. 処理フロー

### 3.1 仕入請求書作成フロー

```
開始
  ↓
ユーザーが新規作成ボタンをクリック
  ↓
入力フォームを表示（状態: 下書き）
  ↓
仕入先を選択（sub_type: supplierでフィルタ）
  ↓
仕入先情報から自動設定
  ├─ 銀行口座
  ├─ 支払方法
  └─ 支払条件
  ↓
明細行を追加
  ├─ 商品を選択
  ├─ 数量・単価を入力（costまたはpriceから取得）
  ├─ 仕入税を選択（TypeTaxUse::PURCHASE）
  └─ 小計を自動計算
  ↓
合計金額を自動計算
  ↓
保存ボタンをクリック
  ↓
データベースに保存
  ↓
請求書番号を自動採番（BILL/YYYY/MM/ID形式）
  ↓
成功メッセージ表示
  ↓
終了
```

### 3.2 仕入先選択時の自動設定

```
開始
  ↓
仕入先を選択
  ↓
パートナー情報を取得
  ↓
銀行口座を自動設定
  └─ partner.bankAccounts.first()
  ↓
支払方法を自動設定
  └─ partner.propertyOutboundPaymentMethodLine
  ↓
支払条件を自動設定
  └─ partner.propertySupplierPaymentTerm
  ↓
終了
```

### 3.3 商品選択時の自動設定

```
開始
  ↓
商品を選択
  ↓
商品情報を取得
  ↓
単位を自動設定
  └─ product.uom_id
  ↓
単価を自動設定
  └─ product.cost または product.price
  ↓
仕入税を自動設定
  └─ product.productTaxes（仕入税）
  ↓
小計を計算
  ↓
終了
```

## 4. 関連コンポーネント

### 4.1 モデル

| モデル名 | テーブル名 | 説明 |
|----------|------------|------|
| Webkul\Invoice\Models\Bill | accounts_account_moves | 仕入請求書モデル（Moveを継承） |
| Webkul\Account\Models\Move | accounts_account_moves | 基底請求書/仕訳モデル |
| Webkul\Account\Models\MoveLine | accounts_account_move_lines | 請求書明細行モデル |
| Webkul\Invoice\Models\Product | products | 商品モデル |

### 4.2 リソース・ページ

| リソース名 | パス |
|------------|------|
| BillResource (invoices) | plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource.php |
| BaseBillResource (accounts) | plugins/webkul/accounts/src/Filament/Resources/BillResource.php |
| ListBills | BillResource/Pages/ListBills.php |
| CreateBill | BillResource/Pages/CreateBill.php |
| EditBill | BillResource/Pages/EditBill.php |
| ViewBill | BillResource/Pages/ViewBill.php |

### 4.3 主要なリレーション

| リレーション名 | 種類 | 関連モデル | 説明 |
|----------------|------|------------|------|
| partner | belongsTo | Partner | 仕入先 |
| lines | hasMany | MoveLine | 商品明細行 |
| partnerBank | belongsTo | BankAccount | 支払先銀行口座 |
| invoicePaymentTerm | belongsTo | PaymentTerm | 支払条件 |
| currency | belongsTo | Currency | 通貨 |
| company | belongsTo | Company | 会社 |

### 4.4 クラスター

| クラスター名 | 説明 |
|--------------|------|
| Vendors | 仕入先管理クラスター |

## 5. エラーハンドリング

### 5.1 バリデーションエラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 商品未選択 | 明細行の商品が選択されていない | 商品は必須です |
| 数量不正 | 数量が0以下の場合 | 数量は1以上を入力してください |
| 通貨未選択 | 通貨が選択されていない | 通貨は必須です |
| 期日・支払条件未設定 | 両方とも未設定の場合 | 期日または支払条件を設定してください |

### 5.2 業務エラー

| エラー種別 | 条件 | メッセージ |
|------------|------|------------|
| 削除不可 | 転記済み請求書の削除時 | 転記済みの請求書は削除できません |
| 編集制限 | 転記済み/取消請求書の編集時 | 該当フィールドを無効化 |

### 5.3 システムエラー

| エラー種別 | 対処方法 |
|------------|----------|
| データベース接続エラー | エラーログ出力、ユーザーへ一般的なエラーメッセージ表示 |
| 税計算エラー | エラーログ出力、0として計算継続 |

## 6. 備考

### 6.1 設計上の考慮事項
- 仕入請求書はMoveモデルを使用し、move_type = 'in_invoice' で識別される
- 請求書番号は「BILL/YYYY/MM/ID」形式で自動採番される
- accountsプラグインのBillResourceを継承し、invoicesプラグイン向けにカスタマイズ
- Vendorsクラスター内にナビゲーション表示（navigationSort: 1）

### 6.2 仕入先フィルタリング
- パートナー選択時、sub_type = 'supplier' でフィルタリング
- 仕入先専用の支払方法・支払条件が自動適用される

### 6.3 商品リンク機能
- 明細行から商品編集画面への直接リンク（extraItemActions）
- 別タブで商品詳細を開くことが可能

### 6.4 仕入税の適用
- TypeTaxUse::PURCHASE に一致する税のみ選択可能
- 商品のproductTaxesから自動設定

### 6.5 依存関係
- accounts プラグイン（基底リソース提供）
- partners プラグイン（仕入先管理）
- support プラグイン（通貨・会社管理）
- Filament フレームワーク（UI提供）

### 6.6 状態遷移図

```
[下書き(draft)]
     │
     ├── 確認 ──→ [転記済み(posted)]
     │                  │
     │                  ├── 支払い ──→ 支払状態更新
     │                  │
     │                  └── 取消 ──→ [取消(cancel)]
     │
     └── 削除 ──→ 削除完了
```
