# 機能設計書 51-顧客請求書管理

## 概要

本ドキュメントは、invoicesプラグインにおける顧客請求書管理機能の設計仕様を定義する。顧客に対する請求書の作成、編集、送信、支払管理などの機能を提供する。

### 本機能の処理概要

顧客請求書管理機能は、企業が顧客に対して発行する請求書のライフサイクル全体を管理するための機能である。

**業務上の目的・背景**：企業の売掛金管理において、請求書の発行は収益認識と資金回収の起点となる重要なプロセスである。本機能により、正確かつ迅速な請求書発行、顧客への送付、支払状況の追跡が可能となり、キャッシュフローの改善と売掛金回収率の向上を実現する。

**機能の利用シーン**：
- 商品・サービス提供後の請求書発行
- 定期的な請求（月額サービス等）の一括発行
- 請求書の修正・再発行
- 支払条件の設定と期日管理
- 顧客への請求書送付（メール/印刷）

**主要な処理内容**：
1. 請求書の新規作成（顧客選択、商品明細入力、税額計算）
2. 請求書の編集・更新
3. 請求書の確認・投稿（ステータス変更）
4. 請求書のメール送信・PDF出力
5. 支払登録と消込処理
6. クレジットノート（返金）の作成

**関連システム・外部連携**：
- 会計モジュール（accounts）との仕訳連携
- 商品マスタ（products）との商品情報連携
- パートナー管理（partners）との顧客情報連携
- 決済処理（payments）との支払連携

**権限による制御**：Filament Shieldによる権限管理に基づき、請求書の閲覧・作成・編集・削除・送信の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-CU-001 | InvoiceResource | 主画面 | 請求書一覧表示、作成、編集、表示、送信 |
| SCR-INV-CU-003 | PaymentsResource | 参照画面 | 支払情報の参照・登録 |
| SCR-INV-CU-004 | PartnerResource | 参照画面 | 顧客情報の参照 |
| SCR-INV-CU-005 | ProductResource | 参照画面 | 商品情報の参照 |

## 機能種別

CRUD操作 / 帳票出力 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | 顧客ID | 存在チェック |
| journal_id | integer | Yes | 仕訳帳ID | 存在チェック |
| invoice_date | date | No | 請求日 | 日付形式 |
| invoice_date_due | date | No | 支払期日 | 日付形式、請求日以降 |
| invoice_payment_term_id | integer | No | 支払条件ID | 存在チェック |
| currency_id | integer | No | 通貨ID | 存在チェック |
| reference | string | No | 参照番号 | 最大255文字 |
| narration | text | No | 備考 | - |
| products | array | Yes | 商品明細 | 1件以上必須 |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（顧客、商品、仕訳帳、支払条件等のマスタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| name | string | 請求書番号（自動採番：INV/YYYY/MM/ID） |
| state | enum | ステータス（draft/posted/cancel） |
| payment_state | enum | 支払状態（not_paid/partial/paid/reversed） |
| amount_untaxed | decimal | 税抜金額 |
| amount_tax | decimal | 税額 |
| amount_total | decimal | 税込合計金額 |
| amount_residual | decimal | 残高（未払額） |

### 出力先

- DBテーブル（accounts_account_moves、accounts_account_move_lines）
- 画面表示（一覧、詳細）
- PDF帳票（請求書印刷）
- メール送信（顧客への請求書送付）

## 処理フロー

### 処理シーケンス

```
1. 請求書作成
   └─ 顧客選択、仕訳帳選択、基本情報入力
2. 商品明細入力
   └─ 商品選択、数量・単価入力、税設定
3. 金額計算
   └─ 小計、税額、合計額の自動計算
4. 請求書保存（ドラフト状態）
   └─ DBへの保存、採番処理
5. 請求書確認（投稿）
   └─ ステータス変更、仕訳生成
6. 請求書送信
   └─ PDF生成、メール送信
7. 支払処理
   └─ 支払登録、消込処理
```

### フローチャート

```mermaid
flowchart TD
    A[請求書作成開始] --> B[顧客・基本情報入力]
    B --> C[商品明細入力]
    C --> D[金額計算]
    D --> E{保存}
    E --> F[ドラフト状態]
    F --> G{確認/投稿}
    G -->|投稿| H[Posted状態]
    G -->|キャンセル| I[Cancel状態]
    H --> J{送信}
    J -->|メール| K[メール送信]
    J -->|印刷| L[PDF出力]
    H --> M{支払}
    M -->|支払登録| N[支払消込]
    N --> O{全額支払?}
    O -->|Yes| P[支払完了]
    O -->|No| Q[部分支払]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-051-01 | 請求書番号採番 | INV/YYYY/MM/連番形式で自動採番 | 請求書作成時 |
| BR-051-02 | 支払期日自動設定 | 支払条件に基づき期日を自動計算 | 支払条件選択時 |
| BR-051-03 | 税額自動計算 | 商品の税設定に基づき税額を自動計算 | 明細入力時 |
| BR-051-04 | 投稿後の編集制限 | Posted状態の請求書は直接編集不可 | 編集操作時 |
| BR-051-05 | 支払状態自動更新 | 支払登録時に残高と支払状態を自動更新 | 支払消込時 |

### 計算ロジック

- 税抜金額 = SUM(明細の数量 × 単価 × (1 - 割引率/100))
- 税額 = 各明細の税抜金額 × 税率（税設定に基づく）
- 税込合計 = 税抜金額 + 税額
- 残高 = 税込合計 - 支払済金額

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 請求書作成 | accounts_account_moves | INSERT | 請求書ヘッダ作成 |
| 明細追加 | accounts_account_move_lines | INSERT | 明細行作成 |
| 請求書更新 | accounts_account_moves | UPDATE | ヘッダ情報更新 |
| 明細更新 | accounts_account_move_lines | UPDATE | 明細行更新 |
| ステータス変更 | accounts_account_moves | UPDATE | state列更新 |
| 支払登録 | accounts_account_payments | INSERT | 支払レコード作成 |

### テーブル別操作詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | 'out_invoice' | 顧客請求書 |
| INSERT | state | 'draft' | 初期状態 |
| INSERT | name | 自動採番 | INV/YYYY/MM/ID形式 |
| UPDATE | state | 'posted'/'cancel' | ステータス変更 |
| UPDATE | payment_state | 計算値 | 支払状態更新 |

#### accounts_account_move_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | display_type | 'product' | 商品明細 |
| INSERT | display_type | 'tax' | 税額行 |
| INSERT | display_type | 'payment_term' | 支払条件行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-051-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-051-02 | 参照整合性エラー | 存在しないIDを指定 | 正しい値の選択を促す |
| E-051-03 | ステータスエラー | 投稿済み請求書の編集 | 取消後に修正を案内 |
| E-051-04 | 金額エラー | 負の金額入力 | 正の値の入力を促す |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 請求書の作成・更新は単一トランザクションで処理
- ヘッダと明細は同一トランザクション内で処理
- ステータス変更時は仕訳生成も同一トランザクションで処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 請求書保存：2秒以内
- PDF生成：3秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- 請求書アクセスはロールベースで制御
- 監査ログ（HasLogActivity）による操作履歴記録
- アクセストークンによる外部アクセス制御

## 備考

- 請求書はaccountsプラグインのMoveモデルを継承
- move_type = 'out_invoice' で顧客請求書を識別
- 多通貨対応（currency_id による通貨指定）
- インコターム対応（国際取引条件の設定可能）
