# 機能設計書 52-返金管理(仕入)

## 概要

本ドキュメントは、invoicesプラグインにおける仕入先返金管理機能の設計仕様を定義する。仕入先からの返金（クレジットノート）の作成、編集、管理などの機能を提供する。

### 本機能の処理概要

仕入先返金管理機能は、仕入先に対する返品や値引きに伴う返金処理を管理するための機能である。

**業務上の目的・背景**：仕入取引において、返品、品質不良、価格調整などの理由で仕入先から返金を受ける場合がある。本機能により、これらの返金処理を適切に記録し、買掛金の調整と会計処理の正確性を確保する。返金処理を体系的に管理することで、仕入先との取引関係の透明性と財務報告の正確性を維持できる。

**機能の利用シーン**：
- 仕入商品の返品に伴う返金処理
- 仕入価格の事後調整（値引き）
- 品質不良に対する補償金の受領
- 仕入請求書の誤りに対する訂正

**主要な処理内容**：
1. 返金（クレジットノート）の新規作成
2. 返金明細の入力（商品、数量、金額）
3. 元の仕入請求書との紐付け
4. 返金の確認・投稿
5. 仕入請求書との相殺処理
6. 買掛金残高の調整

**関連システム・外部連携**：
- 会計モジュール（accounts）との仕訳連携
- 仕入請求書（BillResource）との連携
- パートナー管理（partners）との仕入先情報連携
- 商品マスタとの商品情報連携

**権限による制御**：Filament Shieldによる権限管理に基づき、返金の閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-VE-002 | RefundResource | 主画面 | 返金一覧表示、作成、編集、表示 |
| SCR-INV-VE-001 | BillResource | 参照画面 | 元請求書の参照 |
| SCR-INV-VE-004 | VendorResource | 参照画面 | 仕入先情報の参照 |
| SCR-INV-VE-005 | ProductResource | 参照画面 | 商品情報の参照 |

## 機能種別

CRUD操作 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | 仕入先ID | 存在チェック |
| journal_id | integer | Yes | 仕訳帳ID | 存在チェック |
| invoice_date | date | No | 返金日 | 日付形式 |
| reversed_entry_id | integer | No | 元請求書ID | 存在チェック |
| currency_id | integer | No | 通貨ID | 存在チェック |
| reference | string | No | 参照番号 | 最大255文字 |
| narration | text | No | 備考 | - |
| products | array | Yes | 商品明細 | 1件以上必須 |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（仕入先、商品、仕訳帳等のマスタ）
- 元請求書データ（返金作成時の参照）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| name | string | 返金番号（自動採番：RBILL/YYYY/MM/ID） |
| state | enum | ステータス（draft/posted/cancel） |
| amount_untaxed | decimal | 税抜金額 |
| amount_tax | decimal | 税額 |
| amount_total | decimal | 税込合計金額 |
| amount_residual | decimal | 残高 |

### 出力先

- DBテーブル（accounts_account_moves、accounts_account_move_lines）
- 画面表示（一覧、詳細）

## 処理フロー

### 処理シーケンス

```
1. 返金作成開始
   └─ 仕入先選択、仕訳帳選択
2. 元請求書の参照（任意）
   └─ 元請求書からデータをコピー
3. 商品明細入力
   └─ 商品選択、数量・単価入力
4. 金額計算
   └─ 小計、税額、合計額の自動計算
5. 返金保存（ドラフト状態）
   └─ DBへの保存、採番処理
6. 返金確認（投稿）
   └─ ステータス変更、仕訳生成
7. 相殺処理（任意）
   └─ 元請求書との消込
```

### フローチャート

```mermaid
flowchart TD
    A[返金作成開始] --> B[仕入先・基本情報入力]
    B --> C{元請求書参照?}
    C -->|Yes| D[元請求書からコピー]
    C -->|No| E[手動入力]
    D --> F[商品明細確認・編集]
    E --> F
    F --> G[金額計算]
    G --> H{保存}
    H --> I[ドラフト状態]
    I --> J{確認/投稿}
    J -->|投稿| K[Posted状態]
    J -->|キャンセル| L[Cancel状態]
    K --> M{相殺処理?}
    M -->|Yes| N[元請求書と消込]
    M -->|No| O[処理完了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-052-01 | 返金番号採番 | RBILL/YYYY/MM/連番形式で自動採番 | 返金作成時 |
| BR-052-02 | 元請求書との関連 | 返金は元請求書と紐付け可能 | 返金作成時 |
| BR-052-03 | 税額自動計算 | 商品の税設定に基づき税額を自動計算 | 明細入力時 |
| BR-052-04 | 投稿後の編集制限 | Posted状態の返金は直接編集不可 | 編集操作時 |
| BR-052-05 | 相殺処理 | 投稿後、元請求書との相殺が可能 | 消込操作時 |

### 計算ロジック

- 税抜金額 = SUM(明細の数量 × 単価)
- 税額 = 各明細の税抜金額 × 税率
- 税込合計 = 税抜金額 + 税額

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 返金作成 | accounts_account_moves | INSERT | 返金ヘッダ作成 |
| 明細追加 | accounts_account_move_lines | INSERT | 明細行作成 |
| 返金更新 | accounts_account_moves | UPDATE | ヘッダ情報更新 |
| ステータス変更 | accounts_account_moves | UPDATE | state列更新 |

### テーブル別操作詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | 'in_refund' | 仕入返金 |
| INSERT | state | 'draft' | 初期状態 |
| INSERT | name | 自動採番 | RBILL/YYYY/MM/ID形式 |
| INSERT | reversed_entry_id | 元請求書ID | 元請求書との関連 |
| UPDATE | state | 'posted'/'cancel' | ステータス変更 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-052-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-052-02 | 参照整合性エラー | 存在しないIDを指定 | 正しい値の選択を促す |
| E-052-03 | ステータスエラー | 投稿済み返金の編集 | 取消後に修正を案内 |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 返金の作成・更新は単一トランザクションで処理
- ヘッダと明細は同一トランザクション内で処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 返金保存：2秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- 返金アクセスはロールベースで制御
- 監査ログによる操作履歴記録

## 備考

- 返金はaccountsプラグインのMoveモデルを継承
- move_type = 'in_refund' で仕入返金を識別
- Vendorsクラスター配下に配置
