# 機能設計書 53-支払管理

## 概要

本ドキュメントは、invoicesプラグインにおける支払管理機能の設計仕様を定義する。顧客からの入金および仕入先への支払の記録・管理機能を提供する。

### 本機能の処理概要

支払管理機能は、企業の入出金処理を一元管理するための機能である。顧客からの売掛金回収と仕入先への買掛金支払を記録し、請求書との消込を行う。

**業務上の目的・背景**：企業の資金管理において、入出金の正確な記録と請求書との照合は財務健全性の維持に不可欠である。本機能により、キャッシュフローの可視化、売掛・買掛の適切な消込、銀行口座との照合が可能となり、財務報告の正確性と資金繰り管理の効率化を実現する。

**機能の利用シーン**：
- 顧客からの入金記録
- 仕入先への支払記録
- 請求書との支払消込
- 銀行振込の記録
- 現金・小切手の入出金記録
- 内部振替（口座間移動）

**主要な処理内容**：
1. 支払レコードの新規作成
2. 支払方法・銀行口座の選択
3. 金額・日付の入力
4. 請求書との紐付けと消込
5. 支払の確認・投稿
6. 支払照合（銀行明細との突合）

**関連システム・外部連携**：
- 会計モジュール（accounts）との仕訳連携
- 請求書（InvoiceResource、BillResource）との消込連携
- 銀行口座管理との連携
- 決済処理（payments）との連携

**権限による制御**：Filament Shieldによる権限管理に基づき、支払の閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-CU-003 | PaymentsResource (Customer) | 主画面 | 顧客支払の一覧表示、作成、編集 |
| SCR-INV-VE-003 | PaymentsResource (Vendor) | 主画面 | 仕入先支払の一覧表示、作成、編集 |
| SCR-INV-CU-001 | InvoiceResource | 参照画面 | 顧客請求書の参照 |
| SCR-INV-VE-001 | BillResource | 参照画面 | 仕入請求書の参照 |

## 機能種別

CRUD操作 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| partner_id | integer | Yes | パートナーID | 存在チェック |
| journal_id | integer | Yes | 仕訳帳ID | 存在チェック |
| payment_method_line_id | integer | Yes | 支払方法ID | 存在チェック |
| currency_id | integer | Yes | 通貨ID | 存在チェック |
| amount | decimal | Yes | 支払金額 | 正の数値 |
| date | date | Yes | 支払日 | 日付形式 |
| payment_type | string | Yes | 支払タイプ | inbound/outbound |
| partner_type | string | Yes | パートナータイプ | customer/supplier |
| memo | string | No | メモ | 最大255文字 |
| payment_reference | string | No | 支払参照番号 | 最大255文字 |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（パートナー、仕訳帳、支払方法、通貨等のマスタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| name | string | 支払番号 |
| state | enum | ステータス（draft/posted/cancel） |
| amount | decimal | 支払金額 |
| amount_company_currency_signed | decimal | 会社通貨での金額（符号付き） |
| is_reconciled | boolean | 消込済みフラグ |
| is_matched | boolean | 照合済みフラグ |
| is_sent | boolean | 送信済みフラグ |

### 出力先

- DBテーブル（accounts_account_payments）
- 画面表示（一覧、詳細）

## 処理フロー

### 処理シーケンス

```
1. 支払作成開始
   └─ パートナー選択、支払タイプ選択
2. 支払方法・口座選択
   └─ 仕訳帳選択、支払方法選択
3. 金額・日付入力
   └─ 金額入力、支払日設定
4. 支払保存（ドラフト状態）
   └─ DBへの保存
5. 支払確認（投稿）
   └─ ステータス変更、仕訳生成
6. 請求書との消込
   └─ 対象請求書選択、消込実行
```

### フローチャート

```mermaid
flowchart TD
    A[支払作成開始] --> B[パートナー・タイプ選択]
    B --> C[支払方法・口座選択]
    C --> D[金額・日付入力]
    D --> E{保存}
    E --> F[ドラフト状態]
    F --> G{確認/投稿}
    G -->|投稿| H[Posted状態]
    G -->|キャンセル| I[Cancel状態]
    H --> J{消込実行?}
    J -->|Yes| K[請求書選択]
    K --> L[消込処理]
    L --> M[処理完了]
    J -->|No| M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-053-01 | 支払タイプ | inbound=入金、outbound=出金 | 支払作成時 |
| BR-053-02 | パートナータイプ | customer=顧客、supplier=仕入先 | 支払作成時 |
| BR-053-03 | 金額符号 | 入金は正、出金は負の符号で管理 | 金額計算時 |
| BR-053-04 | 消込制限 | 投稿済みの支払のみ消込可能 | 消込操作時 |
| BR-053-05 | 内部振替 | 同一会社内の口座間移動 | 振替操作時 |

### 計算ロジック

- 会社通貨金額 = 支払金額 × 為替レート × 符号（入金:+1、出金:-1）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 支払作成 | accounts_account_payments | INSERT | 支払レコード作成 |
| 仕訳作成 | accounts_account_moves | INSERT | 関連仕訳作成 |
| 支払更新 | accounts_account_payments | UPDATE | 支払情報更新 |
| 消込登録 | accounts_accounts_move_payment | INSERT | 消込関連付け |

### テーブル別操作詳細

#### accounts_account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | payment_type | 'inbound'/'outbound' | 入出金区分 |
| INSERT | partner_type | 'customer'/'supplier' | 取引先区分 |
| INSERT | state | 'draft' | 初期状態 |
| UPDATE | state | 'posted'/'cancel' | ステータス変更 |
| UPDATE | is_reconciled | true/false | 消込状態 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-053-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-053-02 | 金額エラー | 0以下の金額入力 | 正の金額入力を促す |
| E-053-03 | 消込エラー | 金額不一致 | 金額の確認を促す |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 支払の作成・更新は単一トランザクションで処理
- 支払と仕訳は同一トランザクション内で処理
- 消込処理も同一トランザクションで処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 支払保存：2秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- 支払アクセスはロールベースで制御
- 監査ログ（HasLogActivity）による操作履歴記録
- 銀行口座情報の適切な保護

## 備考

- PaymentモデルはaccountsプラグインのPaymentモデルを継承
- Moveモデルとの関連（move_id）で仕訳と紐付け
- PaymentTransactionとの連携でオンライン決済対応
- PaymentTokenによる決済トークン管理
