# 機能設計書 54-ベンダー管理

## 概要

本ドキュメントは、invoicesプラグインにおけるベンダー（仕入先）管理機能の設計仕様を定義する。仕入先の基本情報、支払条件、請求設定などを一元管理する機能を提供する。

### 本機能の処理概要

ベンダー管理機能は、企業が取引を行う仕入先の情報を包括的に管理するための機能である。仕入先の基本情報から支払条件、請求書設定まで、取引に必要な全ての情報を管理する。

**業務上の目的・背景**：購買・仕入業務において、仕入先情報の正確な管理は取引の円滑化と財務管理の基盤となる。本機能により、仕入先ごとの支払条件、連絡先、銀行口座情報を一元管理し、発注・支払業務の効率化と仕入先との良好な取引関係の維持を実現する。

**機能の利用シーン**：
- 新規仕入先の登録
- 仕入先情報の更新・修正
- 支払条件の設定
- 連絡先・住所の管理
- 銀行口座情報の管理
- 請求書自動化設定

**主要な処理内容**：
1. 仕入先の新規登録（基本情報入力）
2. 支払条件・支払方法の設定
3. 連絡先情報の管理
4. 住所情報の管理
5. 銀行口座情報の管理
6. 請求書設定（自動投稿、EDIフォーマット等）

**関連システム・外部連携**：
- パートナー管理（partners）の基盤機能を継承
- 会計モジュール（accounts）との支払条件連携
- 購買管理との仕入先情報共有
- 銀行口座管理との連携

**権限による制御**：Filament Shieldによる権限管理に基づき、仕入先情報の閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-VE-004 | VendorResource | 主画面 | 仕入先一覧表示、作成、編集、表示 |
| SCR-INV-VE-001 | BillResource | 参照画面 | 仕入先の請求書参照 |
| SCR-INV-VE-003 | PaymentsResource | 参照画面 | 仕入先への支払参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 仕入先名 | 最大255文字 |
| sub_type | string | Yes | サブタイプ | 'supplier'固定 |
| user_id | integer | No | 担当者ID | 存在チェック |
| property_payment_term_id | integer | No | 支払条件ID | 存在チェック |
| property_supplier_payment_term_id | integer | No | 仕入先支払条件ID | 存在チェック |
| property_inbound_payment_method_line_id | integer | No | 入金方法ID | 存在チェック |
| property_outbound_payment_method_line_id | integer | No | 出金方法ID | 存在チェック |
| property_account_position_id | integer | No | 財政ポジションID | 存在チェック |
| invoice_sending_method | enum | No | 請求書送信方法 | InvoiceSendingMethod |
| invoice_edi_format_store | enum | No | EDIフォーマット | InvoiceFormat |
| autopost_bills | enum | No | 自動投稿設定 | AutoPostBills |
| comment | text | No | 内部メモ | - |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（支払条件、支払方法、財政ポジション等のマスタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 仕入先ID |
| name | string | 仕入先名 |
| sub_type | string | サブタイプ（supplier） |
| property_payment_term_id | integer | 支払条件ID |
| invoice_sending_method | enum | 請求書送信方法 |
| autopost_bills | enum | 自動投稿設定 |

### 出力先

- DBテーブル（partners_partners）
- 画面表示（一覧、詳細、カード表示）

## 処理フロー

### 処理シーケンス

```
1. 仕入先作成開始
   └─ 基本情報入力（名前、担当者）
2. 販売・購買タブ設定
   └─ 支払条件、支払方法、財政ポジション設定
3. 請求タブ設定
   └─ 請求書送信方法、EDIフォーマット、自動化設定
4. 内部メモ入力（任意）
   └─ 社内向けコメント
5. 保存
   └─ DBへの保存
6. 関連情報管理
   └─ 連絡先、住所、銀行口座の追加
```

### フローチャート

```mermaid
flowchart TD
    A[仕入先作成開始] --> B[基本情報入力]
    B --> C[販売・購買設定]
    C --> D[請求設定]
    D --> E[内部メモ入力]
    E --> F{保存}
    F --> G[仕入先登録完了]
    G --> H{関連情報追加?}
    H -->|連絡先| I[連絡先管理]
    H -->|住所| J[住所管理]
    H -->|銀行口座| K[銀行口座管理]
    I --> L[処理完了]
    J --> L
    K --> L
    H -->|No| L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-054-01 | サブタイプ固定 | sub_type = 'supplier' で仕入先を識別 | 仕入先作成時 |
| BR-054-02 | 支払条件継承 | 仕入先の支払条件が請求書に継承される | 請求書作成時 |
| BR-054-03 | 自動投稿設定 | 設定に基づき請求書を自動投稿 | 請求書受領時 |
| BR-054-04 | EDI対応 | 指定フォーマットで電子請求書を処理 | 請求書送受信時 |

### 計算ロジック

特になし（マスタ管理機能）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 仕入先作成 | partners_partners | INSERT | 仕入先レコード作成 |
| 仕入先更新 | partners_partners | UPDATE | 仕入先情報更新 |
| 連絡先追加 | partners_partners | INSERT | 連絡先レコード作成 |
| 住所追加 | partners_addresses | INSERT | 住所レコード作成 |
| 銀行口座追加 | partners_bank_accounts | INSERT | 銀行口座レコード作成 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sub_type | 'supplier' | 仕入先識別 |
| INSERT/UPDATE | property_payment_term_id | 選択値 | 支払条件 |
| INSERT/UPDATE | property_supplier_payment_term_id | 選択値 | 仕入先支払条件 |
| INSERT/UPDATE | invoice_sending_method | 選択値 | 請求書送信方法 |
| INSERT/UPDATE | autopost_bills | 選択値 | 自動投稿設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-054-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-054-02 | 重複エラー | 同名仕入先の登録 | 確認を促すメッセージ表示 |
| E-054-03 | 参照整合性エラー | 存在しないIDを指定 | 正しい値の選択を促す |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 仕入先の作成・更新は単一トランザクションで処理
- 関連テーブル（連絡先、住所等）は個別トランザクションで処理
- 失敗時は該当トランザクションをロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 仕入先保存：1秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- 仕入先情報へのアクセスはロールベースで制御
- 銀行口座情報の適切な保護
- 監査ログによる操作履歴記録

## 備考

- VendorResourceはPartnerResourceを継承
- sub_type = 'supplier' でフィルタして仕入先のみ表示
- カード形式のグリッド表示に対応
- サブナビゲーションで連絡先・住所・銀行口座を管理
- 請求書送信方法、EDIフォーマット、自動投稿などの高度な設定が可能
