# 機能設計書 55-商品管理(請求)

## 概要

本ドキュメントは、invoicesプラグインにおける商品管理（請求）機能の設計仕様を定義する。請求書作成時に使用する商品情報の管理、税設定、会計科目との連携機能を提供する。

### 本機能の処理概要

商品管理（請求）機能は、請求業務で使用する商品情報を管理するための機能である。基本的な商品マスタ機能に加え、請求に必要な税設定や会計科目の連携を行う。

**業務上の目的・背景**：請求書作成において、商品情報は単価、税率、会計科目などの重要な情報を持つ。本機能により、商品ごとの収益・費用科目の自動設定、顧客税・仕入先税の適切な適用が可能となり、請求処理の正確性と効率性を向上させる。

**機能の利用シーン**：
- 請求用商品の新規登録
- 商品情報の更新・修正
- 顧客税（販売税）の設定
- 仕入先税（購買税）の設定
- 収益・費用科目の設定
- 商品バリエーションの管理

**主要な処理内容**：
1. 商品の新規作成（基本情報入力）
2. 価格・コストの設定
3. 顧客税（productTaxes）の設定
4. 仕入先税（supplierTaxes）の設定
5. 収益科目・費用科目の設定
6. 商品属性・バリエーションの管理

**関連システム・外部連携**：
- 商品マスタ（products）の基盤機能を継承
- 会計モジュール（accounts）との科目連携
- 税管理（Tax）との税設定連携
- 請求書作成時の商品参照

**権限による制御**：Filament Shieldによる権限管理に基づき、商品情報の閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-CU-005 | ProductResource (Customer) | 主画面 | 顧客向け商品の一覧表示、作成、編集 |
| SCR-INV-VE-005 | ProductResource (Vendor) | 主画面 | 仕入先向け商品の一覧表示、作成、編集 |
| SCR-INV-CU-001 | InvoiceResource | 参照画面 | 請求書での商品選択 |
| SCR-INV-VE-001 | BillResource | 参照画面 | 仕入請求書での商品選択 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 商品名 | 最大255文字 |
| type | enum | Yes | 商品タイプ | ProductType |
| price | decimal | Yes | 販売価格 | 0以上 |
| cost | decimal | No | 原価 | 0以上 |
| reference | string | No | 商品コード | 最大255文字 |
| barcode | string | No | バーコード | 最大255文字 |
| category_id | integer | Yes | カテゴリID | 存在チェック |
| property_account_income_id | integer | No | 収益科目ID | 存在チェック |
| property_account_expense_id | integer | No | 費用科目ID | 存在チェック |
| productTaxes | array | No | 顧客税ID配列 | 存在チェック |
| supplierTaxes | array | No | 仕入先税ID配列 | 存在チェック |
| invoice_policy | enum | No | 請求ポリシー | InvoicePolicy |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（カテゴリ、税、会計科目等のマスタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 商品ID |
| name | string | 商品名 |
| type | enum | 商品タイプ |
| price | decimal | 販売価格 |
| cost | decimal | 原価 |
| reference | string | 商品コード |
| is_favorite | boolean | お気に入りフラグ |

### 出力先

- DBテーブル（products_products）
- 画面表示（一覧、詳細）

## 処理フロー

### 処理シーケンス

```
1. 商品作成開始
   └─ 基本情報入力（名前、タイプ、カテゴリ）
2. 価格情報入力
   └─ 販売価格、原価の設定
3. 税設定
   └─ 顧客税、仕入先税の選択
4. 会計科目設定
   └─ 収益科目、費用科目の選択
5. 保存
   └─ DBへの保存
6. バリエーション管理（任意）
   └─ 属性設定、バリエーション生成
```

### フローチャート

```mermaid
flowchart TD
    A[商品作成開始] --> B[基本情報入力]
    B --> C[価格情報入力]
    C --> D[税設定]
    D --> E[会計科目設定]
    E --> F{保存}
    F --> G[商品登録完了]
    G --> H{バリエーション追加?}
    H -->|Yes| I[属性管理]
    I --> J[バリエーション生成]
    J --> K[処理完了]
    H -->|No| K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-055-01 | 税設定継承 | 商品の税設定が請求書明細に継承される | 請求書作成時 |
| BR-055-02 | 科目設定継承 | 商品の会計科目が仕訳に使用される | 請求書投稿時 |
| BR-055-03 | 請求ポリシー | 注文数量/納品数量に基づく請求制御 | 請求書作成時 |
| BR-055-04 | バリエーション | 属性に基づき複数バリエーションを管理 | 設定可能商品のみ |

### 計算ロジック

特になし（マスタ管理機能）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品作成 | products_products | INSERT | 商品レコード作成 |
| 商品更新 | products_products | UPDATE | 商品情報更新 |
| 顧客税設定 | accounts_product_taxes | INSERT/DELETE | 税関連付け |
| 仕入先税設定 | accounts_product_supplier_taxes | INSERT/DELETE | 税関連付け |

### テーブル別操作詳細

#### products_products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | property_account_income_id | 選択値 | 収益科目 |
| INSERT/UPDATE | property_account_expense_id | 選択値 | 費用科目 |
| INSERT/UPDATE | invoice_policy | 選択値 | 請求ポリシー |
| INSERT/UPDATE | sales_ok | true/false | 販売可能フラグ |
| INSERT/UPDATE | purchase_ok | true/false | 購買可能フラグ |

#### accounts_product_taxes（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | product_id | 商品ID | 商品への関連付け |
| INSERT | tax_id | 税ID | 顧客税の関連付け |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-055-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-055-02 | 価格エラー | 負の価格入力 | 正の値の入力を促す |
| E-055-03 | 参照整合性エラー | 存在しないIDを指定 | 正しい値の選択を促す |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 商品の作成・更新は単一トランザクションで処理
- 税関連付けは商品保存と同一トランザクションで処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 商品保存：1秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- 商品情報へのアクセスはロールベースで制御
- 監査ログ（HasLogActivity）による操作履歴記録

## 備考

- ProductモデルはBaseProductモデルを継承
- HasChatter, HasCustomFields, HasLogActivityトレイトを使用
- Customerクラスター配下にCustomer用ProductResourceを配置
- Vendorsクラスター配下にVendor用ProductResourceを配置
- productTaxes/supplierTaxesで税との多対多リレーションを管理
