# 機能設計書 56-インコターム管理

## 概要

本ドキュメントは、invoicesプラグインにおけるインコターム管理機能の設計仕様を定義する。国際取引条件（インコターム）のマスタ管理機能を提供する。

### 本機能の処理概要

インコターム管理機能は、国際商業会議所（ICC）が定める国際取引条件（Incoterms）のマスタデータを管理するための機能である。

**業務上の目的・背景**：国際取引において、売主と買主の責任範囲（費用負担、リスク移転時点）を明確にするためにインコタームが使用される。本機能により、FOB、CIF、EXW等の標準的な取引条件を登録・管理し、請求書や契約書に適切な条件を適用できる。これにより国際取引の透明性と法的確実性を確保する。

**機能の利用シーン**：
- インコタームコードの新規登録
- インコターム情報の更新・修正
- 請求書作成時のインコターム選択
- 国際取引契約での条件設定

**主要な処理内容**：
1. インコタームの新規登録（コード、名称）
2. インコターム情報の編集
3. インコタームの削除（論理削除）
4. 請求書へのインコターム適用

**関連システム・外部連携**：
- 会計モジュール（accounts）のIncotermモデルを継承
- 請求書（Move）のinvoice_incoterm_idとして参照
- 受注・発注での取引条件参照

**権限による制御**：Filament Shieldによる権限管理に基づき、インコタームの閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-INV-CF-005 | IncoTermResource | 主画面 | インコタームの一覧表示、作成、編集、削除 |
| SCR-INV-CU-001 | InvoiceResource | 参照画面 | 請求書でのインコターム選択 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code | string | Yes | インコタームコード | 最大10文字、英大文字 |
| name | string | Yes | インコターム名称 | 最大255文字 |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | インコタームID |
| code | string | インコタームコード（例：FOB, CIF） |
| name | string | インコターム名称 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- DBテーブル（accounts_incoterms）
- 画面表示（一覧）

## 処理フロー

### 処理シーケンス

```
1. インコターム作成開始
   └─ コード、名称入力
2. バリデーション
   └─ 必須項目、コード形式チェック
3. 保存
   └─ DBへの保存
4. 一覧表示更新
   └─ 新規インコタームの表示
```

### フローチャート

```mermaid
flowchart TD
    A[インコターム管理開始] --> B[一覧表示]
    B --> C{操作選択}
    C -->|新規作成| D[コード・名称入力]
    C -->|編集| E[既存データ編集]
    C -->|削除| F[削除確認]
    D --> G[保存]
    E --> G
    F --> H[論理削除]
    G --> B
    H --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-056-01 | コード一意性 | インコタームコードは一意である必要がある | 登録・更新時 |
| BR-056-02 | 標準コード | ICC標準のインコタームコードを使用推奨 | 登録時 |
| BR-056-03 | 論理削除 | 削除は論理削除（SoftDeletes）で実装 | 削除時 |
| BR-056-04 | 参照整合性 | 請求書で使用中のインコタームは削除不可 | 削除時 |

### 計算ロジック

特になし（マスタ管理機能）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| インコターム作成 | accounts_incoterms | INSERT | インコタームレコード作成 |
| インコターム更新 | accounts_incoterms | UPDATE | インコターム情報更新 |
| インコターム削除 | accounts_incoterms | UPDATE | deleted_at設定（論理削除） |

### テーブル別操作詳細

#### accounts_incoterms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | code | 入力値 | インコタームコード |
| INSERT | name | 入力値 | インコターム名称 |
| INSERT | creator_id | 現在のユーザーID | 作成者 |
| UPDATE | deleted_at | 現在日時 | 論理削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-056-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-056-02 | 重複エラー | 同一コードの登録 | 別のコードを入力 |
| E-056-03 | 削除制約エラー | 使用中のインコターム削除 | 削除不可メッセージ表示 |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- インコタームの作成・更新は単一トランザクションで処理
- 失敗時はロールバック

## パフォーマンス要件

- 一覧表示：1秒以内
- 保存：1秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- マスタデータへのアクセスはロールベースで制御
- 変更履歴の記録

## 備考

- IncotermモデルはaccountsプラグインのIncotermを継承
- SoftDeletesトレイトによる論理削除対応
- Configurationクラスター配下に配置
- 一覧表示のみ（詳細ビューなし）
- 代表的なインコターム：
  - EXW (Ex Works)
  - FOB (Free On Board)
  - CIF (Cost, Insurance & Freight)
  - DDP (Delivered Duty Paid)
