# 機能設計書 57-決済処理

## 概要

本ドキュメントは、paymentsプラグインにおける決済処理機能の設計仕様を定義する。オンライン決済の処理と決済トークンの管理機能を提供する。

### 本機能の処理概要

決済処理機能は、オンライン決済の実行と決済トークンの管理を行うための機能である。クレジットカードやその他のオンライン決済手段を統合的に管理する。

**業務上の目的・背景**：ECサイトやオンラインサービスにおいて、安全で確実な決済処理は事業継続の基盤となる。本機能により、複数の決済プロバイダーとの連携、決済トークンによるセキュアな再利用決済、決済履歴の管理が可能となり、顧客利便性の向上と決済業務の効率化を実現する。

**機能の利用シーン**：
- オンラインでの商品購入時の決済処理
- 定期課金（サブスクリプション）の自動決済
- 保存された決済方法での再利用決済
- 決済トークンの登録・管理
- 決済結果の確認

**主要な処理内容**：
1. 決済リクエストの受付
2. 決済プロバイダーへの処理要求
3. 決済トークンの生成・保存
4. 決済結果の記録
5. 会計システムとの連携

**関連システム・外部連携**：
- 外部決済プロバイダー（Stripe、PayPal等）との連携
- 会計モジュール（accounts）との支払連携
- 請求書管理との消込連携

**権限による制御**：決済処理は認証済みユーザーのみ実行可能。管理機能はFilament Shieldによる権限管理で制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Payment処理 | 処理機能 | 決済の実行 |
| SCR-ACC-003 | PaymentsResource | 参照画面 | 決済結果の確認 |

## 機能種別

決済処理 / データ連携 / バックエンド処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| amount | decimal | Yes | 決済金額 | 正の数値 |
| currency_id | integer | Yes | 通貨ID | 存在チェック |
| partner_id | integer | Yes | パートナーID | 存在チェック |
| payment_method_id | integer | Yes | 決済方法ID | 存在チェック |
| payment_token_id | integer | No | 決済トークンID | 存在チェック |
| payment_details | json | No | 決済詳細情報 | JSON形式 |

### 入力データソース

- API呼び出し（決済リクエスト）
- 画面入力（管理画面での操作）
- DBテーブル参照（決済トークン、決済方法等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 決済ID |
| payment_token_id | integer | 決済トークンID |
| provider_reference_id | string | プロバイダー参照ID |
| payment_details | json | 決済詳細 |
| is_active | boolean | アクティブフラグ |

### 出力先

- DBテーブル（payments_payment_tokens）
- 外部決済プロバイダー
- 会計システム

## 処理フロー

### 処理シーケンス

```
1. 決済リクエスト受付
   └─ 金額、通貨、決済方法の検証
2. 決済トークン確認（再利用決済の場合）
   └─ 既存トークンの有効性確認
3. 決済プロバイダーへ処理要求
   └─ 外部APIコール
4. 決済結果受信
   └─ 成功/失敗の判定
5. トークン保存（新規カードの場合）
   └─ 決済トークンの生成・保存
6. 結果記録
   └─ 決済トランザクションの記録
7. 会計連携
   └─ 支払レコードの作成
```

### フローチャート

```mermaid
flowchart TD
    A[決済リクエスト] --> B{トークンあり?}
    B -->|Yes| C[トークン検証]
    B -->|No| D[新規決済情報入力]
    C --> E{有効?}
    E -->|Yes| F[決済処理]
    E -->|No| D
    D --> G{保存希望?}
    G -->|Yes| H[決済処理 + トークン生成]
    G -->|No| F
    F --> I{成功?}
    H --> I
    I -->|Yes| J[トランザクション記録]
    I -->|No| K[エラー処理]
    J --> L[会計連携]
    L --> M[完了]
    K --> N[エラー返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-057-01 | 金額検証 | 決済金額は正の数値である必要がある | 決済処理時 |
| BR-057-02 | トークン有効期限 | 決済トークンには有効期限がある | トークン使用時 |
| BR-057-03 | アクティブ制御 | is_active = false のトークンは使用不可 | トークン使用時 |
| BR-057-04 | 決済履歴 | 全ての決済処理は履歴として記録 | 決済処理後 |
| BR-057-05 | 失敗時ロールバック | 決済失敗時は関連処理をロールバック | 決済失敗時 |

### 計算ロジック

- 決済手数料 = 決済金額 × 手数料率（プロバイダー設定による）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| トークン作成 | payments_payment_tokens | INSERT | 決済トークン作成 |
| トークン更新 | payments_payment_tokens | UPDATE | トークン情報更新 |
| トークン無効化 | payments_payment_tokens | UPDATE | is_active = false |
| 支払作成 | accounts_account_payments | INSERT | 支払レコード作成 |

### テーブル別操作詳細

#### payments_payment_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | company_id | 会社ID | 会社への関連付け |
| INSERT | payment_method_id | 決済方法ID | 決済方法への関連付け |
| INSERT | partner_id | パートナーID | パートナーへの関連付け |
| INSERT | provider_reference_id | プロバイダー発行ID | 外部参照ID |
| INSERT | payment_details | 決済詳細JSON | カード情報等 |
| INSERT | is_active | true | 有効フラグ |
| UPDATE | is_active | false | トークン無効化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-057-01 | 決済失敗 | プロバイダーからの拒否 | エラー理由を表示 |
| E-057-02 | トークン無効 | 期限切れ/無効化済み | 再入力を促す |
| E-057-03 | 通信エラー | プロバイダー接続失敗 | リトライまたは別手段 |
| E-057-04 | 金額エラー | 0以下の金額 | 正しい金額の入力を促す |

### リトライ仕様

- 通信エラー時は最大3回までリトライ
- リトライ間隔：1秒、2秒、4秒（指数バックオフ）

## トランザクション仕様

- 決済処理と会計連携は同一トランザクションで処理
- 決済プロバイダー処理成功後にDBトランザクション開始
- 失敗時は全体をロールバック

## パフォーマンス要件

- 決済処理：5秒以内（プロバイダー応答時間含む）
- トークン検証：100ms以内

## セキュリティ考慮事項

- PCI DSS準拠の考慮
- 決済情報の暗号化
- トークン化によるカード情報の非保持
- 監査ログによる全操作の記録
- HTTPS必須

## 備考

- PaymentモデルはEloquentモデルを継承
- HasFactoryトレイトを使用
- PaymentTokenモデルで決済トークンを管理
- 外部決済プロバイダーとの連携はサービスクラスで実装（詳細は別途）
- accounts_account_paymentsテーブルと連携して会計処理を実行
