# 機能設計書 58-決済トランザクション管理

## 概要

本ドキュメントは、paymentsプラグインにおける決済トランザクション管理機能の設計仕様を定義する。決済処理の履歴記録と照会機能を提供する。

### 本機能の処理概要

決済トランザクション管理機能は、実行された決済処理の履歴を記録・管理するための機能である。銀行明細との照合、消込処理の追跡を行う。

**業務上の目的・背景**：決済処理の透明性と追跡可能性は、財務報告と監査対応において不可欠である。本機能により、全ての決済トランザクションの詳細履歴を管理し、銀行明細との自動照合、未消込トランザクションの追跡が可能となり、経理業務の効率化と正確性の向上を実現する。

**機能の利用シーン**：
- 決済処理結果の履歴照会
- 銀行明細との照合（突合）
- 未消込トランザクションの確認
- 消込処理の実行
- 決済履歴のレポート出力

**主要な処理内容**：
1. 決済トランザクションの記録
2. トランザクション履歴の照会
3. 銀行明細との照合
4. 消込状態の管理
5. 残高の追跡

**関連システム・外部連携**：
- 会計モジュール（accounts）との仕訳連携
- 銀行明細（BankStatement）との照合連携
- 支払管理との消込連携

**権限による制御**：Filament Shieldによる権限管理に基づき、トランザクションの閲覧・編集の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | PaymentTransaction処理 | 処理機能 | トランザクションの記録・照会 |
| SCR-ACC-003 | PaymentsResource | 参照画面 | 関連支払の確認 |

## 機能種別

データ管理 / 照合処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| move_id | integer | Yes | 仕訳移動ID | 存在チェック |
| journal_id | integer | No | 仕訳帳ID | 存在チェック |
| company_id | integer | No | 会社ID | 存在チェック |
| statement_id | integer | No | 銀行明細ID | 存在チェック |
| partner_id | integer | No | パートナーID | 存在チェック |
| currency_id | integer | No | 通貨ID | 存在チェック |
| amount | decimal | Yes | 金額 | 数値 |
| transaction_type | string | No | 取引タイプ | 最大255文字 |
| payment_reference | string | No | 支払参照番号 | 最大255文字 |

### 入力データソース

- 決済処理の結果（自動記録）
- 銀行明細のインポート
- 手動入力（管理画面）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | トランザクションID |
| move_id | integer | 仕訳移動ID |
| amount | decimal | 金額 |
| amount_currency | decimal | 通貨建て金額 |
| amount_residual | decimal | 残高 |
| transaction_type | string | 取引タイプ |
| is_reconciled | boolean | 消込済みフラグ |

### 出力先

- DBテーブル（payments_payment_transactions）
- 画面表示（一覧、詳細）
- レポート出力

## 処理フロー

### 処理シーケンス

```
1. トランザクション記録
   └─ 決済処理完了時に自動記録
2. 銀行明細インポート
   └─ 外部明細の取り込み
3. 自動照合
   └─ 金額・参照番号による自動マッチング
4. 手動照合（必要時）
   └─ 不一致分の手動マッチング
5. 消込処理
   └─ 照合完了後の消込実行
6. 残高更新
   └─ amount_residualの更新
```

### フローチャート

```mermaid
flowchart TD
    A[トランザクション記録] --> B[銀行明細インポート]
    B --> C[自動照合実行]
    C --> D{一致?}
    D -->|Yes| E[自動消込]
    D -->|No| F[未照合リストへ]
    F --> G[手動照合]
    G --> H{照合完了?}
    H -->|Yes| I[手動消込]
    H -->|No| J[保留]
    E --> K[残高更新]
    I --> K
    K --> L[処理完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-058-01 | 自動照合 | 金額・参照番号が一致する場合に自動照合 | 明細インポート時 |
| BR-058-02 | 部分消込 | 一部金額のみの消込が可能 | 消込処理時 |
| BR-058-03 | 残高管理 | 消込後に残高を自動計算 | 消込処理後 |
| BR-058-04 | 消込済み制限 | 消込済みトランザクションは編集不可 | 編集操作時 |

### 計算ロジック

- 残高（amount_residual）= 元金額（amount）- 消込済み金額

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| トランザクション記録 | payments_payment_transactions | INSERT | トランザクション作成 |
| トランザクション更新 | payments_payment_transactions | UPDATE | 情報更新 |
| 消込実行 | payments_payment_transactions | UPDATE | is_reconciled更新 |
| 残高更新 | payments_payment_transactions | UPDATE | amount_residual更新 |

### テーブル別操作詳細

#### payments_payment_transactions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_id | 仕訳移動ID | 必須 |
| INSERT | journal_id | 仕訳帳ID | 任意 |
| INSERT | amount | 金額 | 必須 |
| INSERT | amount_currency | 通貨建て金額 | 任意 |
| INSERT | amount_residual | 初期値=amount | 残高 |
| INSERT | is_reconciled | false | 初期値 |
| UPDATE | is_reconciled | true | 消込完了時 |
| UPDATE | amount_residual | 計算値 | 消込処理後 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-058-01 | 照合エラー | 一致するトランザクションなし | 手動照合を促す |
| E-058-02 | 金額不一致 | 消込金額が残高を超過 | 正しい金額の入力を促す |
| E-058-03 | 編集制約 | 消込済みトランザクションの編集 | 編集不可メッセージ表示 |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 消込処理は単一トランザクションで処理
- 複数トランザクションの一括消込も同一トランザクション内で処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 自動照合：1000件/分以上

## セキュリティ考慮事項

- Filament Shield による権限管理
- トランザクション情報へのアクセスはロールベースで制御
- 監査ログによる全操作の記録
- 消込済みトランザクションの改ざん防止

## 備考

- PaymentTransactionモデルはEloquentモデルを継承
- HasFactoryトレイトを使用
- accounts_bank_statementsテーブルとの連携で銀行明細と照合
- accounts_account_movesテーブルとの連携で仕訳と紐付け
- 外貨建て取引にも対応（foreign_currency_id）
