# 機能設計書 59-商品マスタ管理

## 概要

本ドキュメントは、productsプラグインにおける商品マスタ管理機能の設計仕様を定義する。商品の基本情報、バリエーション、属性などを一元管理する機能を提供する。

### 本機能の処理概要

商品マスタ管理機能は、企業が取り扱う全ての商品情報を一元的に管理するための中核機能である。商品の基本情報からバリエーション、属性、価格情報まで包括的に管理する。

**業務上の目的・背景**：販売・購買・在庫管理において、正確な商品情報は全ての業務の基盤となる。本機能により、商品の基本情報、価格、カテゴリ、バリエーションを体系的に管理し、各業務モジュールでの商品参照を効率化する。商品情報の一元管理により、データの整合性維持と業務効率の向上を実現する。

**機能の利用シーン**：
- 新規商品の登録
- 商品情報の更新・修正
- 商品バリエーションの管理
- 商品属性の設定
- 価格・コストの管理
- バーコード印刷

**主要な処理内容**：
1. 商品の新規作成（基本情報入力）
2. 商品画像の登録
3. 価格・コストの設定
4. カテゴリの割り当て
5. タグの設定
6. 属性・バリエーションの管理
7. バーコード印刷

**関連システム・外部連携**：
- カテゴリ管理との連携
- 属性管理との連携
- 価格リスト管理との連携
- 在庫管理での商品参照
- 販売・購買での商品参照

**権限による制御**：Filament Shieldによる権限管理に基づき、商品の閲覧・作成・編集・削除・印刷の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRD-001 | ProductResource | 主画面 | 商品一覧表示、作成、編集、表示、削除 |
| SCR-PRD-002 | CategoryResource | 参照画面 | カテゴリ選択 |
| SCR-PRD-003 | AttributeResource | 参照画面 | 属性管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 商品名 | 最大255文字 |
| type | enum | Yes | 商品タイプ | ProductType |
| reference | string | No | 商品コード | 最大255文字 |
| barcode | string | No | バーコード | 最大255文字 |
| category_id | integer | Yes | カテゴリID | 存在チェック |
| price | decimal | Yes | 販売価格 | 0以上 |
| cost | decimal | No | 原価 | 0以上 |
| weight | decimal | No | 重量 | 0以上 |
| volume | decimal | No | 容量 | 0以上 |
| description | text | No | 説明 | - |
| images | array | No | 商品画像 | 画像ファイル |
| tags | array | No | タグID配列 | 存在チェック |
| company_id | integer | No | 会社ID | 存在チェック |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（カテゴリ、タグ、会社等のマスタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 商品ID |
| name | string | 商品名 |
| type | enum | 商品タイプ（goods/service/combo） |
| reference | string | 商品コード |
| barcode | string | バーコード |
| price | decimal | 販売価格 |
| cost | decimal | 原価 |
| is_favorite | boolean | お気に入りフラグ |
| is_configurable | boolean | 設定可能フラグ |

### 出力先

- DBテーブル（products_products）
- 画面表示（一覧、詳細、グリッド）
- PDF出力（バーコードラベル）

## 処理フロー

### 処理シーケンス

```
1. 商品作成開始
   └─ 基本情報入力（名前、タイプ）
2. 画像登録
   └─ 商品画像のアップロード
3. 価格設定
   └─ 販売価格、原価の入力
4. 分類設定
   └─ カテゴリ、タグの選択
5. 詳細情報入力
   └─ 説明、重量、容量等
6. 保存
   └─ DBへの保存
7. 属性・バリエーション管理（任意）
   └─ 属性設定、バリエーション生成
```

### フローチャート

```mermaid
flowchart TD
    A[商品作成開始] --> B[基本情報入力]
    B --> C[画像登録]
    C --> D[価格設定]
    D --> E[分類設定]
    E --> F[詳細情報入力]
    F --> G{保存}
    G --> H[商品登録完了]
    H --> I{バリエーション追加?}
    I -->|Yes| J[属性管理]
    J --> K[バリエーション生成]
    K --> L[処理完了]
    I -->|No| L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-059-01 | 商品タイプ | goods/service/comboの3種類 | 商品作成時 |
| BR-059-02 | カテゴリ必須 | 商品は必ずカテゴリに属する | 商品作成時 |
| BR-059-03 | お気に入り | 商品にお気に入りフラグを設定可能 | 表示時 |
| BR-059-04 | 論理削除 | 削除は論理削除（SoftDeletes） | 削除時 |
| BR-059-05 | ソート順 | sort列によるソート順管理 | 表示時 |
| BR-059-06 | バリエーション | is_configurable=trueで属性設定可能 | バリエーション管理時 |

### 計算ロジック

- 利益率 = (販売価格 - 原価) / 販売価格 × 100

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品作成 | products_products | INSERT | 商品レコード作成 |
| 商品更新 | products_products | UPDATE | 商品情報更新 |
| 商品削除 | products_products | UPDATE | deleted_at設定（論理削除） |
| タグ設定 | products_product_tag | INSERT/DELETE | タグ関連付け |
| バリエーション作成 | products_products | INSERT | バリエーション作成 |

### テーブル別操作詳細

#### products_products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | type | 選択値 | 商品タイプ |
| INSERT | category_id | 選択値 | カテゴリ |
| INSERT | price | 入力値 | 販売価格 |
| INSERT | cost | 入力値 | 原価 |
| INSERT | sort | 自動採番 | ソート順 |
| INSERT | creator_id | 現在ユーザー | 作成者 |
| INSERT | is_configurable | true/false | 設定可能フラグ |
| INSERT | parent_id | 親商品ID | バリエーション用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-059-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-059-02 | 価格エラー | 負の価格入力 | 正の値の入力を促す |
| E-059-03 | 削除制約エラー | 使用中の商品削除 | 削除不可メッセージ表示 |
| E-059-04 | 画像エラー | 不正な画像形式 | 対応形式の案内 |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- 商品の作成・更新は単一トランザクションで処理
- タグ関連付けは商品保存と同一トランザクションで処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- 商品保存：2秒以内
- バーコード印刷：3秒以内（100件）

## セキュリティ考慮事項

- Filament Shield による権限管理
- 商品情報へのアクセスはロールベースで制御
- 監査ログ（HasLogActivity）による操作履歴記録
- SoftDeletesによる誤削除防止

## 備考

- ProductモデルはEloquentモデルを実装
- HasChatter, HasLogActivityトレイトで活動ログを管理
- SortableTrait でドラッグ&ドロップによる並び替えをサポート
- QueryBuilderフィルタで高度な検索が可能
- 一括印刷機能（Dymo、各種ラベル形式対応）
- 商品タイプ：GOODS（物品）、SERVICE（サービス）
