# 機能設計書: カスタムフィールド管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F006 |
| 機能名 | カスタムフィールド管理 |
| 機能概要 | エンティティに対して動的にカスタムフィールドを追加・編集・削除し、フォーム・テーブル・詳細画面での表示を設定する |
| 関連画面 | SCR-FIELD-001（フィールド一覧）、SCR-FIELD-002（フィールド作成）、SCR-FIELD-003（フィールド編集） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

カスタムフィールド管理機能は、システムの各エンティティ（モデル）に対して、コードを変更せずに動的にフィールドを追加できる機能を提供する。追加したフィールドはフォーム、テーブル一覧、詳細情報リストに表示可能。

#### 主な機能
1. **フィールド一覧表示**: 登録済みカスタムフィールドをテーブル形式で表示
2. **フィールド作成**: 新規カスタムフィールドの登録（タイプ、オプション、表示設定）
3. **フィールド編集**: 既存フィールドの設定更新
4. **フィールド削除**: カスタムフィールドの削除（論理削除）
5. **ソート順管理**: ドラッグ&ドロップによるフィールド表示順の変更
6. **表示設定**: フォーム・テーブル・詳細情報リストでの表示設定

### 2.2 処理フロー

#### フィールド作成フロー
```
[開始]
   |
   v
[フィールド作成画面表示]
   |
   v
[フィールド設定入力]
   | - コード（一意識別子）
   | - 名前（表示ラベル）
   | - タイプ選択
   | - オプション設定
   | - フォーム設定
   | - テーブル設定
   | - 詳細リスト設定
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フィールド設定入力]
   |
   v (OK)
[custom_fieldsテーブルにレコード作成]
   |
   v
[ソート順自動設定（Sortable）]
   |
   v
[フィールド一覧へリダイレクト]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| code | string | YES | max:255, unique:custom_fields | フィールドコード（識別子） |
| name | string | YES | max:255 | フィールド名（表示ラベル） |
| type | string | YES | in:text,textarea,select,... | フィールドタイプ |
| input_type | string | NO | - | 入力タイプ（textの場合のサブタイプ） |
| is_multiselect | boolean | NO | - | 複数選択可否（select型の場合） |
| datalist | string | NO | - | データリスト参照 |
| options | array | NO | - | 選択肢オプション |
| form_settings | array | NO | - | フォーム表示設定 |
| use_in_table | boolean | NO | - | テーブル表示使用フラグ |
| table_settings | array | NO | - | テーブル表示設定 |
| infolist_settings | array | NO | - | 詳細リスト表示設定 |
| customizable_type | string | YES | - | 対象モデルクラス名 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | フィールドID |
| code | string | フィールドコード |
| name | string | フィールド名 |
| type | string | フィールドタイプ |
| input_type | string | 入力タイプ |
| is_multiselect | boolean | 複数選択可否 |
| options | array | 選択肢オプション |
| form_settings | object | フォーム表示設定 |
| table_settings | object | テーブル表示設定 |
| infolist_settings | object | 詳細リスト表示設定 |
| sort | integer | ソート順 |
| customizable_type | string | 対象モデルクラス |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | コード一意性 | フィールドコードは同一customizable_type内で一意 |
| BR-002 | 論理削除 | フィールド削除は論理削除（SoftDelete）で行われる |
| BR-003 | ソート順自動設定 | 新規作成時にソート順が自動設定される |
| BR-004 | JSON設定保存 | options, form_settings, table_settings, infolist_settingsはJSON形式で保存 |
| BR-005 | HasCustomFieldsトレイト | カスタムフィールドを使用するモデルはHasCustomFieldsトレイトを使用 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| custom_fields | カスタムフィールド定義 | SELECT, INSERT, UPDATE, DELETE(soft) |

### 4.2 テーブル定義（custom_fields）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| code | varchar(255) | NO | - | フィールドコード |
| name | varchar(255) | NO | - | フィールド名 |
| type | varchar(50) | NO | - | フィールドタイプ |
| input_type | varchar(50) | YES | NULL | 入力タイプ |
| is_multiselect | boolean | NO | false | 複数選択フラグ |
| datalist | varchar(255) | YES | NULL | データリスト参照 |
| options | json | YES | NULL | 選択肢オプション |
| form_settings | json | YES | NULL | フォーム表示設定 |
| use_in_table | boolean | NO | false | テーブル使用フラグ |
| table_settings | json | YES | NULL | テーブル表示設定 |
| infolist_settings | json | YES | NULL | 詳細リスト設定 |
| sort | integer | NO | auto | ソート順 |
| customizable_type | varchar(255) | NO | - | 対象モデルクラス |
| deleted_at | timestamp | YES | NULL | 論理削除日時 |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

### 4.3 サポートフィールドタイプ

| タイプ | 説明 | input_type |
|--------|------|------------|
| text | テキスト入力 | text, email, password, tel, url, number |
| textarea | 複数行テキスト | - |
| select | 選択リスト | - |
| checkbox | チェックボックス | - |
| radio | ラジオボタン | - |
| date | 日付 | - |
| datetime | 日時 | - |
| file | ファイルアップロード | - |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| FieldResource | plugins/webkul/fields/src/Filament/Resources/FieldResource.php | フィールド管理Filamentリソース |
| Field | plugins/webkul/fields/src/Models/Field.php | カスタムフィールドモデル |
| HasCustomFields | plugins/webkul/fields/src/Traits/HasCustomFields.php | カスタムフィールド使用トレイト |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/fields | 必須（カスタムフィールド基盤） |
| spatie/eloquent-sortable | 必須（ソート機能） |
| filament/filament | 必須（管理画面UI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_field | フィールド一覧・詳細の閲覧 |
| view_any_field | 全フィールドの閲覧 |
| create_field | フィールド作成 |
| update_field | フィールド更新 |
| delete_field | フィールド削除 |
| restore_field | 削除フィールド復元 |

### 6.2 セキュリティ考慮事項

- カスタムフィールド管理は管理者権限を持つユーザーのみアクセス可能
- XSS対策としてフィールド値のサニタイズを実施

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内 |
| フィールド作成応答時間 | 500ms以内 |
| フォーム描画への影響 | 100ms以内（1フィールドあたり） |

### 7.2 可用性

- JSON設定の整合性チェック
- 不正設定時のフォールバック処理

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| FIELD-001 | コード重複 | バリデーションエラー表示 |
| FIELD-002 | 不正なタイプ指定 | バリデーションエラー表示 |
| FIELD-003 | JSON設定パースエラー | デフォルト設定適用、警告ログ |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | フィールド一覧が正しく表示されること |
| T-002 | フィールド作成 | 各タイプのフィールドが作成できること |
| T-003 | フォーム表示 | カスタムフィールドがフォームに表示されること |
| T-004 | テーブル表示 | カスタムフィールドがテーブルに表示されること |
| T-005 | 詳細リスト表示 | カスタムフィールドが詳細リストに表示されること |
| T-006 | ソート順変更 | ドラッグ&ドロップで順序変更できること |
| T-007 | 削除・復元 | フィールドの論理削除と復元ができること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
