# 機能設計書 60-商品カテゴリ管理

## 概要

本ドキュメントは、productsプラグインにおける商品カテゴリ管理機能の設計仕様を定義する。商品を分類するための階層型カテゴリ構造の管理機能を提供する。

### 本機能の処理概要

商品カテゴリ管理機能は、商品を体系的に分類・整理するためのカテゴリ構造を管理する機能である。階層型のカテゴリ構造により、商品の効率的な分類と検索を実現する。

**業務上の目的・背景**：商品数が増加するにつれ、効率的な商品分類は業務効率に直結する。本機能により、階層型のカテゴリ構造で商品を体系的に分類し、商品検索の効率化、在庫管理の視認性向上、販売分析のグループ化を実現する。

**機能の利用シーン**：
- 新規カテゴリの作成
- カテゴリ階層の構築
- 商品のカテゴリ割り当て
- カテゴリ別の商品検索
- 価格ルールのカテゴリ適用

**主要な処理内容**：
1. カテゴリの新規作成
2. 親カテゴリの設定（階層構築）
3. カテゴリパスの自動生成
4. フルネームの自動生成
5. カテゴリの更新・削除

**関連システム・外部連携**：
- 商品マスタ管理との連携
- 価格ルール管理との連携
- 在庫管理でのカテゴリフィルタ
- 販売分析でのカテゴリ別集計

**権限による制御**：Filament Shieldによる権限管理に基づき、カテゴリの閲覧・作成・編集・削除の各操作に対してロールベースのアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRD-002 | CategoryResource | 主画面 | カテゴリ一覧表示、作成、編集、表示、削除 |
| SCR-PRD-001 | ProductResource | 参照画面 | カテゴリ選択 |

## 機能種別

CRUD操作 / マスタ管理 / 階層データ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 最大255文字、ユニーク |
| parent_id | integer | No | 親カテゴリID | 存在チェック、循環参照チェック |

### 入力データソース

- 画面入力（Filament Formsによるフォーム入力）
- DBテーブル参照（親カテゴリの選択）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | カテゴリID |
| name | string | カテゴリ名 |
| full_name | string | フルパス名（自動生成） |
| parent_path | string | 親パス（自動生成） |
| parent_id | integer | 親カテゴリID |
| creator_id | integer | 作成者ID |

### 出力先

- DBテーブル（products_categories）
- 画面表示（一覧、詳細）

## 処理フロー

### 処理シーケンス

```
1. カテゴリ作成開始
   └─ カテゴリ名入力
2. 親カテゴリ選択（任意）
   └─ 既存カテゴリから選択
3. 循環参照チェック
   └─ 自己参照・循環参照の検証
4. パス情報生成
   └─ parent_pathの自動生成
5. フルネーム生成
   └─ full_nameの自動生成
6. 保存
   └─ DBへの保存
```

### フローチャート

```mermaid
flowchart TD
    A[カテゴリ作成開始] --> B[カテゴリ名入力]
    B --> C{親カテゴリ選択?}
    C -->|Yes| D[親カテゴリ選択]
    C -->|No| E[ルートカテゴリとして設定]
    D --> F{循環参照チェック}
    F -->|OK| G[parent_path生成]
    F -->|NG| H[エラー表示]
    H --> D
    E --> I[parent_path = '/']
    G --> J[full_name生成]
    I --> J
    J --> K[保存]
    K --> L[処理完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-060-01 | 循環参照禁止 | 自己参照および循環参照は禁止 | カテゴリ作成・更新時 |
| BR-060-02 | カテゴリ名ユニーク | カテゴリ名は重複不可 | カテゴリ作成・更新時 |
| BR-060-03 | パス自動生成 | parent_pathは親カテゴリから自動生成 | カテゴリ保存時 |
| BR-060-04 | フルネーム自動生成 | full_nameは階層パスから自動生成 | カテゴリ保存時 |
| BR-060-05 | カスケード削除 | 親カテゴリ削除時は子カテゴリも削除 | カテゴリ削除時 |
| BR-060-06 | 商品紐付け制約 | 商品が紐付いているカテゴリは削除制限 | カテゴリ削除時 |

### 計算ロジック

- parent_path = 親のparent_path + 親ID + '/'
- full_name = 親カテゴリ名 + ' / ' + カテゴリ名（階層全体を連結）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ作成 | products_categories | INSERT | カテゴリレコード作成 |
| カテゴリ更新 | products_categories | UPDATE | カテゴリ情報更新 |
| カテゴリ削除 | products_categories | DELETE | カテゴリ削除（カスケード） |

### テーブル別操作詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | カテゴリ名 |
| INSERT | parent_id | 選択値/null | 親カテゴリ |
| INSERT | parent_path | 自動生成 | 親パス |
| INSERT | full_name | 自動生成 | フルパス名 |
| INSERT | creator_id | 現在ユーザー | 作成者 |
| UPDATE | name | 入力値 | カテゴリ名更新 |
| UPDATE | parent_id | 選択値 | 親カテゴリ変更 |
| UPDATE | parent_path | 再計算 | パス更新 |
| UPDATE | full_name | 再計算 | フルネーム更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-060-01 | 循環参照エラー | 自己参照または循環参照検出 | 別の親カテゴリを選択するよう促す |
| E-060-02 | 重複エラー | カテゴリ名が既存と重複 | 別の名前を入力するよう促す |
| E-060-03 | 削除制約エラー | 商品が紐付いているカテゴリの削除 | 商品を別カテゴリに移動するよう促す |
| E-060-04 | 親カテゴリ不存在 | 指定した親カテゴリが存在しない | 存在する親カテゴリを選択するよう促す |

### リトライ仕様

トランザクション失敗時は自動ロールバックし、ユーザーに再操作を促す。

## トランザクション仕様

- カテゴリの作成・更新は単一トランザクションで処理
- カスケード削除はDB制約により自動処理
- 失敗時は全体をロールバック

## パフォーマンス要件

- 一覧表示：1秒以内（100件表示時）
- カテゴリ保存：1秒以内
- 階層検索：1秒以内

## セキュリティ考慮事項

- Filament Shield による権限管理
- カテゴリ情報へのアクセスはロールベースで制御
- 監査ログ（HasLogActivity）による操作履歴記録

## 備考

- CategoryモデルはEloquentモデルを実装
- HasChatter, HasLogActivityトレイトで活動ログを管理
- 循環参照検出はvalidateNoRecursionメソッドで実装
- parent_pathとfull_nameはbootメソッド内で自動計算
- 親カテゴリ削除時はcascadeOnDeleteにより子カテゴリも削除される
- priceRuleItemsリレーションで価格ルールとの連携が可能
