# 機能設計書 61-商品属性管理

## 概要

本ドキュメントは、AureusERPシステムにおける商品属性管理機能の設計仕様を定義する。商品のバリエーション（サイズ、色、素材など）を生成するための属性とオプションを管理する機能である。

### 本機能の処理概要

商品属性管理機能は、商品のバリエーションを定義するための属性（Attribute）とその選択肢（AttributeOption）を管理するためのマスタ管理機能である。

**業務上の目的・背景**：ECサイトや在庫管理において、同一商品でもサイズ・色・素材などの違いにより複数のバリエーション（SKU）が存在する。これらのバリエーションを効率的に管理するため、属性を定義し、その組み合わせによって商品バリエーションを自動生成する仕組みが必要である。本機能により、属性のマスタ管理を一元化し、商品登録時の効率化と整合性確保を実現する。

**機能の利用シーン**：商品マスタ登録前の事前準備として属性を定義する場面、新しい属性タイプ（例：新素材、新色）を追加する場面、既存属性のオプション（選択肢）を拡張する場面で利用される。

**主要な処理内容**：
1. 属性（Attribute）のCRUD操作（作成・読取・更新・削除）
2. 属性オプション（AttributeOption）の管理（属性に紐づく選択肢の追加・編集・削除）
3. 属性タイプの設定（ラジオボタン、セレクトボックス、カラーピッカー）
4. オプションごとの追加価格設定
5. 論理削除・復元・完全削除

**関連システム・外部連携**：商品管理モジュール（products）と連携し、商品バリエーション生成時に属性情報を参照する。

**権限による制御**：Filament Shieldによる権限管理が適用され、ロールに応じて属性の作成・編集・削除権限が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRD-003 | AttributeResource | 主画面 | 属性一覧表示・CRUD操作 |
| SCR-PRD-001 | ProductResource | 参照画面 | 商品登録時に属性を参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 属性名 | 最大255文字 |
| type | enum | Yes | 属性タイプ | radio/select/color のいずれか |
| sort | integer | No | 表示順 | 自動設定 |
| options | array | No | 属性オプション配列 | - |
| options.*.name | string | Yes | オプション名 | 最大255文字 |
| options.*.color | string | No | 色コード（typeがcolorの場合） | HEXカラーコード |
| options.*.extra_price | decimal | Yes | 追加価格 | 0以上、最大99999999999 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 属性ID |
| name | string | 属性名 |
| type | enum | 属性タイプ |
| sort | integer | 表示順 |
| creator_id | integer | 作成者ID |
| options | array | 属性オプション一覧 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（論理削除） |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（products_attributes, products_attribute_options）

## 処理フロー

### 処理シーケンス

```
1. 属性一覧表示
   └─ products_attributesテーブルからデータ取得・表示
2. 属性作成
   └─ バリデーション実行後、products_attributesにINSERT
   └─ オプションがあればproducts_attribute_optionsにINSERT
3. 属性編集
   └─ バリデーション実行後、products_attributesをUPDATE
   └─ オプションの追加・更新・削除を反映
4. 属性削除（論理削除）
   └─ deleted_atに現在日時を設定
5. 属性復元
   └─ deleted_atをNULLに設定
6. 属性完全削除
   └─ products_attribute_optionsを先に削除（CASCADE）
   └─ products_attributesからレコードを物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[属性一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F{削除種別}

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[DB保存]
    G -->|NG| I[エラー表示]

    F -->|論理削除| J[deleted_at設定]
    F -->|完全削除| K[物理削除実行]

    C --> L[終了]
    H --> L
    I --> D
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-061-001 | 属性タイプ選択 | 属性タイプはradio/select/colorの3種類から選択 | 属性作成・編集時 |
| BR-061-002 | カラー属性表示 | typeがcolorの場合のみオプションの色選択が表示される | 属性フォーム表示時 |
| BR-061-003 | 追加価格デフォルト | オプションの追加価格は0をデフォルト値とする | オプション作成時 |
| BR-061-004 | ソート自動設定 | sort値は作成時に自動で最後尾に設定される | 属性・オプション作成時 |

### 計算ロジック

追加価格（extra_price）は商品価格に加算される金額として使用される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 属性作成 | products_attributes | INSERT | 新規属性レコード挿入 |
| オプション作成 | products_attribute_options | INSERT | 属性に紐づくオプション挿入 |
| 属性編集 | products_attributes | UPDATE | 属性情報の更新 |
| オプション編集 | products_attribute_options | UPDATE | オプション情報の更新 |
| 属性論理削除 | products_attributes | UPDATE | deleted_atの設定 |
| 属性完全削除 | products_attributes | DELETE | レコードの物理削除 |
| オプション削除 | products_attribute_options | DELETE | CASCADE削除 |

### テーブル別操作詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | type | 入力値（radio/select/color） | 必須 |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | creator_id | ログインユーザーID | - |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除・復元時 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | color | 入力値（HEX） | typeがcolorの場合のみ |
| INSERT | extra_price | 入力値 | デフォルト0 |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | attribute_id | 親属性のID | 外部キー |
| INSERT | creator_id | ログインユーザーID | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-061-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-061-002 | 削除エラー | 商品で使用中の属性を完全削除 | 使用中の旨を通知、削除中止 |
| E-061-003 | DB制約エラー | 外部キー制約違反 | エラー通知、ロールバック |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

属性とオプションの保存は単一トランザクション内で実行される。オプションの保存でエラーが発生した場合、属性の保存もロールバックされる。

## パフォーマンス要件

- 属性一覧取得：1秒以内
- 属性保存処理：2秒以内
- 想定データ量：属性数100件程度、オプション数1000件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）

## 備考

- Spatie EloquentSortableパッケージによるドラッグ&ドロップ並び替えに対応
- SoftDeletesトレイトによる論理削除機能を実装
