# 機能設計書 62-価格リスト管理

## 概要

本ドキュメントは、AureusERPシステムにおける価格リスト管理機能の設計仕様を定義する。顧客別・数量別の価格設定を管理するためのマスタ管理機能である。

### 本機能の処理概要

価格リスト管理機能は、商品の販売価格を顧客セグメント、購入数量、期間などの条件に応じて柔軟に設定・管理するための機能である。

**業務上の目的・背景**：B2B取引において、顧客ランクや取引量に応じた価格設定は一般的な商慣習である。また、キャンペーン価格や季節価格など、時期によって価格を変動させる必要がある。本機能により、複数の価格リストを定義し、適用条件に基づいて適切な価格を自動適用することで、価格管理の効率化と整合性確保を実現する。

**機能の利用シーン**：新規顧客向け価格リストの作成、VIP顧客向け特別価格の設定、キャンペーン期間限定価格の設定、卸売価格と小売価格の管理など。

**主要な処理内容**：
1. 価格リスト（PriceList）のCRUD操作
2. 価格リストの有効・無効の切り替え
3. 通貨（Currency）との紐付け
4. 会社（Company）との紐付け
5. 表示順序（sort）の管理

**関連システム・外部連携**：通貨マスタ（currencies）、会社マスタ（companies）と連携。販売管理モジュール（sales）で見積・受注作成時に価格リストを参照。

**権限による制御**：Filament Shieldによる権限管理が適用され、ロールに応じて価格リストの作成・編集・削除権限が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRD-004 | PriceListResource | 主画面 | 価格リスト一覧・CRUD操作 |
| SCR-SALES-001 | QuotationResource | 参照画面 | 見積作成時に価格リストを参照 |
| SCR-SALES-002 | OrderResource | 参照画面 | 受注作成時に価格リストを参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 価格リスト名 | - |
| currency_id | integer | No | 通貨ID | 通貨マスタに存在すること |
| company_id | integer | No | 会社ID | 会社マスタに存在すること |
| is_active | boolean | No | 有効フラグ | true/false |
| sort | integer | No | 表示順 | 自動設定 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 価格リストID |
| name | string | 価格リスト名 |
| currency_id | integer | 通貨ID |
| company_id | integer | 会社ID |
| is_active | boolean | 有効フラグ |
| sort | integer | 表示順 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（products_product_price_lists）

## 処理フロー

### 処理シーケンス

```
1. 価格リスト一覧表示
   └─ products_product_price_listsテーブルからデータ取得・表示
2. 価格リスト作成
   └─ バリデーション実行後、products_product_price_listsにINSERT
3. 価格リスト編集
   └─ バリデーション実行後、products_product_price_listsをUPDATE
4. 価格リスト削除
   └─ products_product_price_listsからレコードを削除
5. 有効/無効切り替え
   └─ is_activeフラグを更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[価格リスト一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F[削除確認]

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[DB保存]
    G -->|NG| I[エラー表示]

    F -->|確認| J[レコード削除]
    F -->|キャンセル| C

    C --> K[終了]
    H --> K
    I --> D
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-062-001 | 有効リスト適用 | is_activeがtrueの価格リストのみ適用可能 | 見積・受注作成時 |
| BR-062-002 | 通貨一致 | 価格リストの通貨と取引通貨が一致する必要がある | 価格適用時 |
| BR-062-003 | 会社制限 | 会社が設定されている場合、その会社の取引でのみ使用可能 | 価格適用時 |
| BR-062-004 | ソート自動設定 | sort値は作成時に自動で設定される | 価格リスト作成時 |

### 計算ロジック

価格リストに基づく価格計算ロジックは、販売管理モジュール側で実装される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 価格リスト作成 | products_product_price_lists | INSERT | 新規価格リストレコード挿入 |
| 価格リスト編集 | products_product_price_lists | UPDATE | 価格リスト情報の更新 |
| 価格リスト削除 | products_product_price_lists | DELETE | レコードの削除 |

### テーブル別操作詳細

#### products_product_price_lists

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | - |
| INSERT | currency_id | 入力値 | 外部キー |
| INSERT | company_id | 入力値 | 外部キー |
| INSERT | is_active | 入力値 | デフォルトtrue |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | creator_id | ログインユーザーID | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-062-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-062-002 | 参照整合性エラー | 存在しない通貨・会社を指定 | エラー通知 |
| E-062-003 | 削除エラー | 使用中の価格リストを削除 | 使用中の旨を通知、削除中止 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

価格リストの保存は単一トランザクション内で実行される。

## パフォーマンス要件

- 価格リスト一覧取得：1秒以内
- 価格リスト保存処理：2秒以内
- 想定データ量：価格リスト数50件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）

## 備考

- Spatie EloquentSortableパッケージによるドラッグ&ドロップ並び替えに対応
- 現在のリソースクラスはformとtableメソッドが空のため、フル機能実装は未完了の可能性あり
