# 機能設計書 63-パッケージング管理

## 概要

本ドキュメントは、AureusERPシステムにおけるパッケージング管理機能の設計仕様を定義する。商品の梱包単位（ケース、パレットなど）を管理するためのマスタ管理機能である。

### 本機能の処理概要

パッケージング管理機能は、商品の物流・販売における梱包単位を定義・管理する機能である。

**業務上の目的・背景**：物流において、商品は個別単位だけでなくケース単位やパレット単位で取り扱われることが多い。ECサイトでも「6個入りパック」「12本セット」などのセット販売が行われる。本機能により、商品ごとの梱包単位を事前に定義し、出荷・販売時の効率化と在庫管理の精度向上を実現する。

**機能の利用シーン**：商品のケース単位定義、パレット単位の設定、セット販売商品の梱包定義、バーコード管理など。

**主要な処理内容**：
1. パッケージング（Packaging）のCRUD操作
2. 商品（Product）との紐付け
3. 梱包数量（quantity）の設定
4. バーコードの管理
5. 表示順序（sort）の管理
6. 販売・購入での使用フラグ管理

**関連システム・外部連携**：商品管理モジュール（products）と連携。在庫管理・販売管理モジュールでパッケージング情報を参照。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRD-005 | PackagingResource | 主画面 | パッケージング一覧・CRUD操作 |
| SCR-PRD-001 | ProductResource | 参照画面 | 商品詳細からパッケージング参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| product_id | integer | Yes | 商品ID | 商品マスタに存在すること |
| name | string | Yes | パッケージング名 | 最大255文字 |
| quantity | decimal | Yes | 梱包数量 | 最小0 |
| barcode | string | No | バーコード | 最大255文字、ユニーク |
| is_sales | boolean | No | 販売で使用 | デフォルトtrue |
| is_purchase | boolean | No | 購入で使用 | デフォルトtrue |
| sort | integer | No | 表示順 | 自動設定 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パッケージングID |
| product_id | integer | 商品ID |
| name | string | パッケージング名 |
| quantity | decimal | 梱包数量 |
| barcode | string | バーコード |
| is_sales | boolean | 販売使用フラグ |
| is_purchase | boolean | 購入使用フラグ |
| sort | integer | 表示順 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（products_product_packagings）

## 処理フロー

### 処理シーケンス

```
1. パッケージング一覧表示
   └─ products_product_packagingsテーブルからデータ取得・表示
2. パッケージング作成
   └─ バリデーション実行後、products_product_packagingsにINSERT
3. パッケージング編集
   └─ バリデーション実行後、products_product_packagingsをUPDATE
4. パッケージング削除
   └─ products_product_packagingsからレコードを削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[パッケージング一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F[削除確認]

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[バーコード重複チェック]
    G -->|NG| I[エラー表示]

    H -->|OK| J[DB保存]
    H -->|重複| K[重複エラー表示]

    F -->|確認| L[レコード削除]
    F -->|キャンセル| C

    C --> M[終了]
    J --> M
    I --> D
    K --> D
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-063-001 | バーコード一意性 | バーコードはシステム全体で一意 | バーコード入力時 |
| BR-063-002 | 販売使用フラグ | is_salesがtrueの場合のみ販売可能 | 販売処理時 |
| BR-063-003 | 購入使用フラグ | is_purchaseがtrueの場合のみ購入可能 | 購入処理時 |
| BR-063-004 | 商品必須 | パッケージングは必ず商品に紐づく | パッケージング作成時 |
| BR-063-005 | 数量正値 | 梱包数量は0以上 | 数量入力時 |

### 計算ロジック

パッケージング数量に基づく在庫計算は、在庫管理モジュール側で実装される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッケージング作成 | products_product_packagings | INSERT | 新規パッケージングレコード挿入 |
| パッケージング編集 | products_product_packagings | UPDATE | パッケージング情報の更新 |
| パッケージング削除 | products_product_packagings | DELETE | レコードの削除 |

### テーブル別操作詳細

#### products_product_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | product_id | 入力値 | 外部キー、必須 |
| INSERT | name | 入力値 | 必須 |
| INSERT | quantity | 入力値 | 必須、0以上 |
| INSERT | barcode | 入力値 | ユニーク制約 |
| INSERT | is_sales | 入力値 | デフォルトtrue |
| INSERT | is_purchase | 入力値 | デフォルトtrue |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | creator_id | ログインユーザーID | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-063-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-063-002 | バーコード重複エラー | 同一バーコードが既存 | 別のバーコードを入力するよう通知 |
| E-063-003 | 参照整合性エラー | 存在しない商品を指定 | エラー通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

パッケージングの保存は単一トランザクション内で実行される。

## パフォーマンス要件

- パッケージング一覧取得：1秒以内
- パッケージング保存処理：2秒以内
- 想定データ量：パッケージング数500件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）

## 備考

- Spatie EloquentSortableパッケージによるドラッグ&ドロップ並び替えに対応
- barcode項目はuniqueバリデーションが適用される
