# 機能設計書 64-パートナー管理

## 概要

本ドキュメントは、AureusERPシステムにおけるパートナー管理機能の設計仕様を定義する。顧客・仕入先・従業員などのビジネスパートナー情報を一元管理するための機能である。

### 本機能の処理概要

パートナー管理機能は、企業が関わるすべての取引先（顧客、仕入先、従業員、その他）を統合的に管理するためのマスタ管理機能である。

**業務上の目的・背景**：ERPシステムにおいて、顧客・仕入先・従業員などの「人・組織」情報は多くのモジュールから参照される共通マスタである。これらを一元管理することで、データの重複排除、整合性確保、360度ビューでの情報把握を実現する。本機能により、取引先情報を一元的に登録・管理し、販売・購買・人事など各業務モジュールからの参照を可能にする。

**機能の利用シーン**：新規顧客登録、仕入先情報の更新、従業員情報の管理、取引先の住所・連絡先管理など。

**主要な処理内容**：
1. パートナー（Partner）のCRUD操作
2. アカウントタイプ（individual/company）の設定
3. サブタイプ（customer/vendor/employee等）の設定
4. 住所情報の管理（国・都道府県・市区町村・番地）
5. 連絡先情報の管理（電話・メール・Webサイト）
6. 関連パートナー（親子関係）の管理
7. 銀行口座情報の管理
8. タグによる分類

**関連システム・外部連携**：販売管理（Sales）、購買管理（Purchase）、人事管理（Employees）、会計管理（Accounting）等の各モジュールと連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PTN-001 | PartnerResource | 主画面 | パートナー一覧・CRUD操作 |
| SCR-PTN-002 | AddressResource | 関連画面 | 住所管理 |
| SCR-PTN-003 | ContactResource | 関連画面 | 連絡先管理 |
| SCR-PTN-004 | BankAccountResource | 関連画面 | 銀行口座管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| account_type | enum | Yes | アカウントタイプ | individual/company |
| sub_type | string | No | サブタイプ | customer/vendor/employee等 |
| name | string | Yes | 名前 | 最大255文字 |
| avatar | string | No | アバター画像パス | - |
| email | string | No | メールアドレス | メール形式 |
| job_title | string | No | 役職 | - |
| website | string | No | Webサイト | URL形式 |
| tax_id | string | No | 税務ID | - |
| phone | string | No | 電話番号 | - |
| mobile | string | No | 携帯電話番号 | - |
| color | integer | No | 表示色 | - |
| company_registry | string | No | 会社登記番号 | - |
| reference | string | No | 参照コード | - |
| street1 | string | No | 住所1 | - |
| street2 | string | No | 住所2 | - |
| city | string | No | 市区町村 | - |
| zip | string | No | 郵便番号 | - |
| state_id | integer | No | 都道府県ID | statesマスタに存在 |
| country_id | integer | No | 国ID | countriesマスタに存在 |
| parent_id | integer | No | 親パートナーID | 自己参照 |
| title_id | integer | No | 敬称ID | titlesマスタに存在 |
| company_id | integer | No | 会社ID | companiesマスタに存在 |
| industry_id | integer | No | 業種ID | industriesマスタに存在 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パートナーID |
| account_type | enum | アカウントタイプ |
| sub_type | string | サブタイプ |
| name | string | 名前 |
| avatar | string | アバター画像パス |
| avatar_url | string | アバター画像URL（accessor） |
| email | string | メールアドレス |
| job_title | string | 役職 |
| website | string | Webサイト |
| tax_id | string | 税務ID |
| phone | string | 電話番号 |
| mobile | string | 携帯電話番号 |
| color | integer | 表示色 |
| street1 | string | 住所1 |
| street2 | string | 住所2 |
| city | string | 市区町村 |
| zip | string | 郵便番号 |
| creator_id | integer | 作成者ID |
| user_id | integer | 関連ユーザーID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（論理削除） |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（partners_partners）

## 処理フロー

### 処理シーケンス

```
1. パートナー一覧表示
   └─ partners_partnersテーブルからデータ取得・表示
   └─ フィルタ・検索・ソートを適用
2. パートナー作成
   └─ バリデーション実行
   └─ partners_partnersにINSERT
   └─ 関連データ（住所・連絡先・銀行口座）を登録
3. パートナー編集
   └─ バリデーション実行
   └─ partners_partnersをUPDATE
   └─ 関連データを更新
4. パートナー論理削除
   └─ deleted_atに現在日時を設定
5. パートナー復元
   └─ deleted_atをNULLに設定
6. パートナー完全削除
   └─ 関連データを先に削除
   └─ partners_partnersからレコードを物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[パートナー一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F{削除種別}

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[DB保存]
    G -->|NG| I[エラー表示]

    F -->|論理削除| J[deleted_at設定]
    F -->|完全削除| K[関連データ削除]
    K --> L[物理削除実行]

    C --> M[終了]
    H --> M
    I --> D
    J --> M
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-064-001 | アカウントタイプ | individual（個人）またはcompany（企業）のいずれか | パートナー登録時 |
| BR-064-002 | 住所階層 | 住所タイプがaddressの子パートナーは親パートナーの住所として扱う | 住所参照時 |
| BR-064-003 | 連絡先階層 | 住所タイプ以外の子パートナーは親パートナーの連絡先として扱う | 連絡先参照時 |
| BR-064-004 | Filamentパネルアクセス | canAccessPanelメソッドで常にtrueを返す | パネルアクセス判定時 |

### 計算ロジック

アバターURLはStorageファサードを通じて生成される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パートナー作成 | partners_partners | INSERT | 新規パートナーレコード挿入 |
| パートナー編集 | partners_partners | UPDATE | パートナー情報の更新 |
| パートナー論理削除 | partners_partners | UPDATE | deleted_atの設定 |
| パートナー完全削除 | partners_partners | DELETE | レコードの物理削除 |
| 住所登録 | partners_partners | INSERT | 子レコードとして住所を挿入 |
| 銀行口座登録 | partners_bank_accounts | INSERT | 銀行口座情報を挿入 |
| タグ関連付け | partners_partner_tag | INSERT | タグとのリレーション設定 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_type | 入力値 | 必須、enum |
| INSERT | sub_type | 入力値 | - |
| INSERT | name | 入力値 | 必須 |
| INSERT | email | 入力値 | メール形式 |
| INSERT | phone | 入力値 | - |
| INSERT | mobile | 入力値 | - |
| INSERT | street1 | 入力値 | - |
| INSERT | street2 | 入力値 | - |
| INSERT | city | 入力値 | - |
| INSERT | zip | 入力値 | - |
| INSERT | state_id | 入力値 | 外部キー |
| INSERT | country_id | 入力値 | 外部キー |
| INSERT | parent_id | 入力値 | 自己参照外部キー |
| INSERT | creator_id | ログインユーザーID | - |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除・復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-064-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-064-002 | 参照整合性エラー | 存在しない国・都道府県を指定 | エラー通知 |
| E-064-003 | 循環参照エラー | 自己を親として設定 | エラー通知 |
| E-064-004 | 削除エラー | 他で参照されているパートナーを削除 | 使用中の旨を通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

パートナーと関連データ（住所・銀行口座・タグ）の保存は単一トランザクション内で実行される。

## パフォーマンス要件

- パートナー一覧取得：2秒以内
- パートナー保存処理：3秒以内
- 想定データ量：パートナー数10,000件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）
- アバター画像のストレージアクセス制御
- Authenticatableを継承しFilamentUserインターフェースを実装

## 備考

- SoftDeletesトレイトによる論理削除機能を実装
- HasChatter, HasLogActivityトレイトによる活動ログ記録機能を実装
- Notifiableトレイトによる通知機能を実装
- PartnerFactoryによるテストデータ生成が可能
