# 機能設計書 65-住所管理

## 概要

本ドキュメントは、AureusERPシステムにおける住所管理機能の設計仕様を定義する。パートナーに紐づく住所情報（請求先・配送先など）を管理するための機能である。

### 本機能の処理概要

住所管理機能は、パートナー（顧客・仕入先等）に紐づく複数の住所を管理するためのサブ機能である。パートナーの子レコードとして住所を登録・管理する。

**業務上の目的・背景**：B2B取引において、1つの取引先が複数の住所（本社住所、工場住所、配送先住所、請求先住所など）を持つことは一般的である。本機能により、パートナーごとに複数の住所を登録し、用途（請求先/配送先など）に応じた住所を選択できるようにする。

**機能の利用シーン**：取引先の配送先住所の追加、請求先住所の変更、新規拠点住所の登録など。

**主要な処理内容**：
1. 住所のCRUD操作（作成・読取・更新・削除）
2. 住所タイプ（請求先/配送先/その他）の設定
3. 親パートナーとの紐付け
4. 国・都道府県の選択
5. 連絡先情報（電話・メール）の設定

**関連システム・外部連携**：販売管理（配送先選択）、購買管理（仕入先住所選択）と連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PTN-002 | AddressResource | 主画面 | 住所一覧・CRUD操作 |
| SCR-PTN-001 | PartnerResource/ManageAddresses | 関連画面 | パートナー詳細からの住所管理 |

## 機能種別

CRUD操作 / サブマスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sub_type | enum | No | 住所タイプ | invoice/delivery/other |
| parent_id | integer | Yes | 親パートナーID | パートナーマスタに存在（ManageAddressesでは非表示） |
| name | string | Yes | 名前 | 最大255文字 |
| email | string | No | メールアドレス | 最大255文字、メール形式 |
| phone | string | No | 電話番号 | 最大255文字 |
| mobile | string | No | 携帯電話番号 | - |
| street1 | string | No | 住所1 | 最大255文字 |
| street2 | string | No | 住所2 | 最大255文字 |
| city | string | No | 市区町村 | 最大255文字 |
| zip | string | No | 郵便番号 | 最大255文字 |
| country_id | integer | No | 国ID | countriesマスタに存在 |
| state_id | integer | No | 都道府県ID | statesマスタに存在、country_idに依存 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 住所ID（パートナーID） |
| sub_type | enum | 住所タイプ |
| parent_id | integer | 親パートナーID |
| name | string | 名前 |
| email | string | メールアドレス |
| phone | string | 電話番号 |
| mobile | string | 携帯電話番号 |
| street1 | string | 住所1 |
| street2 | string | 住所2 |
| city | string | 市区町村 |
| zip | string | 郵便番号 |
| country_id | integer | 国ID |
| state_id | integer | 都道府県ID |
| account_type | enum | アカウントタイプ（ADDRESS固定） |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（partners_partners、account_type='address'）

## 処理フロー

### 処理シーケンス

```
1. 住所一覧表示
   └─ partners_partnersテーブルからaccount_type=ADDRESSのデータ取得
   └─ 親パートナーでフィルタ
2. 住所作成
   └─ バリデーション実行
   └─ account_type=ADDRESSとしてpartners_partnersにINSERT
   └─ creator_idに現在ユーザーIDを設定
3. 住所編集
   └─ バリデーション実行
   └─ partners_partnersをUPDATE
4. 住所削除
   └─ partners_partnersからレコードを削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[住所一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F[削除確認]

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[account_type=ADDRESS設定]
    G -->|NG| I[エラー表示]

    H --> J[DB保存]

    F -->|確認| K[レコード削除]
    F -->|キャンセル| C

    C --> L[終了]
    J --> L
    I --> D
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-065-001 | 住所タイプデフォルト | sub_typeのデフォルト値はINVOICE（請求先） | 住所作成時 |
| BR-065-002 | アカウントタイプ固定 | 住所作成時にaccount_type=ADDRESSが自動設定 | 住所保存時 |
| BR-065-003 | 都道府県フィルタ | 都道府県リストは選択された国に属するもののみ表示 | 都道府県選択時 |
| BR-065-004 | 作成者自動設定 | creator_idは現在ログインユーザーが自動設定 | 住所作成時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 住所作成 | partners_partners | INSERT | account_type=ADDRESSで新規レコード挿入 |
| 住所編集 | partners_partners | UPDATE | 住所情報の更新 |
| 住所削除 | partners_partners | DELETE | レコードの削除 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_type | ADDRESS | 自動設定 |
| INSERT | sub_type | 入力値 | デフォルトINVOICE |
| INSERT | parent_id | 入力値/コンテキスト値 | 必須 |
| INSERT | name | 入力値 | 必須 |
| INSERT | email | 入力値 | メール形式 |
| INSERT | phone | 入力値 | - |
| INSERT | mobile | 入力値 | - |
| INSERT | street1 | 入力値 | - |
| INSERT | street2 | 入力値 | - |
| INSERT | city | 入力値 | - |
| INSERT | zip | 入力値 | - |
| INSERT | country_id | 入力値 | 外部キー |
| INSERT | state_id | 入力値 | 外部キー |
| INSERT | creator_id | ログインユーザーID | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-065-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-065-002 | 参照整合性エラー | 存在しない国・都道府県を指定 | エラー通知 |
| E-065-003 | 参照整合性エラー | 存在しない親パートナーを指定 | エラー通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

住所の保存は単一トランザクション内で実行される。

## パフォーマンス要件

- 住所一覧取得：1秒以内
- 住所保存処理：2秒以内
- 想定データ量：住所数5,000件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）

## 備考

- 住所はパートナーテーブル（partners_partners）の子レコードとして管理される
- account_type=ADDRESSで住所レコードを識別
- ManageAddressesページでは親パートナーがコンテキストから自動設定される
- 都道府県選択は国選択後にフィルタリングされる動的UI
