# 機能設計書 66-連絡先管理

## 概要

本ドキュメントは、AureusERPシステムにおける連絡先管理機能の設計仕様を定義する。パートナー（企業）に紐づく担当者・連絡先を管理するための機能である。

### 本機能の処理概要

連絡先管理機能は、パートナー（主に企業）に紐づく担当者（個人）を管理するためのサブ機能である。パートナーの子レコードとして連絡先を登録・管理する。

**業務上の目的・背景**：B2B取引において、1つの取引先企業には複数の担当者（購買担当、経理担当、技術担当など）が存在する。本機能により、企業パートナーに紐づく担当者情報を管理し、適切な連絡先を選択できるようにする。

**機能の利用シーン**：取引先担当者の登録、担当者の連絡先更新、担当者変更時の情報追加など。

**主要な処理内容**：
1. 連絡先（Contact）のCRUD操作
2. 親パートナー（企業）との紐付け
3. 連絡先情報（電話・メール・役職）の設定
4. 個人としての住所情報管理

**関連システム・外部連携**：販売管理（担当者選択）、購買管理（仕入先担当者選択）、メール送信機能と連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PTN-003 | ContactResource | 主画面 | 連絡先一覧・CRUD操作 |
| SCR-PTN-001 | PartnerResource/ManageContacts | 関連画面 | パートナー詳細からの連絡先管理 |

## 機能種別

CRUD操作 / サブマスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| account_type | enum | Yes | アカウントタイプ | individual固定 |
| parent_id | integer | Yes | 親パートナーID | パートナーマスタに存在 |
| name | string | Yes | 名前 | 最大255文字 |
| job_title | string | No | 役職 | - |
| email | string | No | メールアドレス | メール形式 |
| phone | string | No | 電話番号 | - |
| mobile | string | No | 携帯電話番号 | - |
| street1 | string | No | 住所1 | - |
| street2 | string | No | 住所2 | - |
| city | string | No | 市区町村 | - |
| zip | string | No | 郵便番号 | - |
| country_id | integer | No | 国ID | countriesマスタに存在 |
| state_id | integer | No | 都道府県ID | statesマスタに存在 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 連絡先ID（パートナーID） |
| account_type | enum | アカウントタイプ（individual固定） |
| parent_id | integer | 親パートナーID |
| name | string | 名前 |
| job_title | string | 役職 |
| email | string | メールアドレス |
| phone | string | 電話番号 |
| mobile | string | 携帯電話番号 |
| street1 | string | 住所1 |
| street2 | string | 住所2 |
| city | string | 市区町村 |
| zip | string | 郵便番号 |
| country_id | integer | 国ID |
| state_id | integer | 都道府県ID |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（partners_partners、account_type != 'address'かつparent_id設定）

## 処理フロー

### 処理シーケンス

```
1. 連絡先一覧表示
   └─ partners_partnersテーブルからaccount_type!=ADDRESSかつparent_id設定のデータ取得
   └─ 親パートナーでフィルタ
2. 連絡先作成
   └─ バリデーション実行
   └─ account_type=individualとしてpartners_partnersにINSERT
3. 連絡先編集
   └─ バリデーション実行
   └─ partners_partnersをUPDATE
4. 連絡先削除
   └─ partners_partnersからレコードを削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[連絡先一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F[削除確認]

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[account_type=individual設定]
    G -->|NG| I[エラー表示]

    H --> J[DB保存]

    F -->|確認| K[レコード削除]
    F -->|キャンセル| C

    C --> L[終了]
    J --> L
    I --> D
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-066-001 | アカウントタイプ | 連絡先のaccount_typeはindividual（個人） | 連絡先作成時 |
| BR-066-002 | 親パートナー必須 | 連絡先は必ず親パートナー（企業）に紐づく | 連絡先作成時 |
| BR-066-003 | 住所との区別 | account_type != ADDRESSで住所と区別 | 連絡先取得時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 連絡先作成 | partners_partners | INSERT | account_type=individualで新規レコード挿入 |
| 連絡先編集 | partners_partners | UPDATE | 連絡先情報の更新 |
| 連絡先削除 | partners_partners | DELETE | レコードの削除 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_type | individual | 固定値 |
| INSERT | parent_id | 入力値/コンテキスト値 | 必須 |
| INSERT | name | 入力値 | 必須 |
| INSERT | job_title | 入力値 | 役職 |
| INSERT | email | 入力値 | メール形式 |
| INSERT | phone | 入力値 | - |
| INSERT | mobile | 入力値 | - |
| INSERT | street1 | 入力値 | - |
| INSERT | street2 | 入力値 | - |
| INSERT | city | 入力値 | - |
| INSERT | zip | 入力値 | - |
| INSERT | country_id | 入力値 | 外部キー |
| INSERT | state_id | 入力値 | 外部キー |
| INSERT | creator_id | ログインユーザーID | 自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-066-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-066-002 | 参照整合性エラー | 存在しない親パートナーを指定 | エラー通知 |
| E-066-003 | メール形式エラー | 不正なメールアドレス形式 | エラー通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

連絡先の保存は単一トランザクション内で実行される。

## パフォーマンス要件

- 連絡先一覧取得：1秒以内
- 連絡先保存処理：2秒以内
- 想定データ量：連絡先数10,000件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）
- メールアドレスの保護（アクセス権限による制御）

## 備考

- 連絡先はパートナーテーブル（partners_partners）の子レコードとして管理される
- account_type=individualかつparent_id設定かつaccount_type!=ADDRESSで連絡先を識別
- パートナーモデルのcontacts()リレーションで取得可能
- 親パートナーの削除時は連絡先も連動して削除される（ソフトデリートの場合はそのまま残る）
