# 機能設計書 67-パートナー関係管理

## 概要

本ドキュメントは、AureusERPシステムにおけるパートナー関係管理機能の設計仕様を定義する。パートナー間の親子関係・グループ関係を管理するための機能である。

### 本機能の処理概要

パートナー関係管理機能は、パートナー間の階層構造や関連性を管理するための機能である。企業グループ、親会社・子会社関係、本社・支店関係などを表現する。

**業務上の目的・背景**：ビジネスにおいて、取引先は単独の企業だけでなく、企業グループとして存在することが多い。親会社への請求、子会社との取引、支店への配送など、企業間の関係性を理解することは重要である。本機能により、パートナー間の階層構造を管理し、グループ全体の取引状況把握や与信管理に活用する。

**機能の利用シーン**：企業グループの登録、親会社・子会社関係の設定、本社・支店関係の管理など。

**主要な処理内容**：
1. パートナー間の親子関係設定（parent_id）
2. 階層構造の可視化
3. 関連パートナーの一覧表示
4. グループ単位での分析・集計

**関連システム・外部連携**：販売管理、購買管理、会計管理（与信管理）と連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PTN-001 | PartnerResource | 主画面 | 親パートナー設定・関連表示 |

## 機能種別

データ管理 / 関係設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| parent_id | integer | No | 親パートナーID | 自己参照禁止、存在するパートナー |

### 入力データソース

画面入力（パートナー編集フォーム内）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| parent | Partner | 親パートナー情報 |
| addresses | Collection | 住所一覧（子パートナー） |
| contacts | Collection | 連絡先一覧（子パートナー） |

### 出力先

- 画面表示（パートナー詳細画面内）

## 処理フロー

### 処理シーケンス

```
1. 親パートナー設定
   └─ パートナー編集時にparent_idを設定
   └─ 自己参照チェック
   └─ 保存
2. 子パートナー取得（住所）
   └─ addresses()リレーションで取得
   └─ account_type=ADDRESSでフィルタ
3. 子パートナー取得（連絡先）
   └─ contacts()リレーションで取得
   └─ account_type!=ADDRESSでフィルタ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パートナー編集]
    B --> C{親パートナー設定?}
    C -->|Yes| D[parent_id選択]
    C -->|No| E[parent_id=NULL]

    D --> F{自己参照チェック}
    F -->|NG| G[エラー表示]
    F -->|OK| H[保存]

    E --> H
    G --> D

    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-067-001 | 自己参照禁止 | parent_idに自身のIDを設定不可 | 親パートナー設定時 |
| BR-067-002 | 住所は子パートナー | account_type=ADDRESSの子パートナーを住所として扱う | 住所取得時 |
| BR-067-003 | 連絡先は子パートナー | account_type!=ADDRESSの子パートナーを連絡先として扱う | 連絡先取得時 |
| BR-067-004 | 階層構造 | パートナーは任意の深さの階層構造を持てる | 親パートナー設定時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 親パートナー設定 | partners_partners | UPDATE | parent_idの更新 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | parent_id | 選択した親パートナーID / NULL | 自己参照禁止 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-067-001 | 自己参照エラー | parent_idに自身のIDを設定 | エラーメッセージ表示 |
| E-067-002 | 循環参照エラー | 親子関係がループする | エラーメッセージ表示 |
| E-067-003 | 参照整合性エラー | 存在しないパートナーを親に設定 | エラー通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

親パートナー設定の保存は単一トランザクション内で実行される。

## パフォーマンス要件

- 関連パートナー取得：1秒以内
- 想定データ量：階層深度3〜5レベル程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 関連パートナー情報へのアクセス権限確認

## 備考

- パートナー関係は主にPartnerモデルのparent()、addresses()、contacts()リレーションで表現される
- 階層構造の深さに制限はないが、パフォーマンス考慮で3〜5レベル程度を推奨
- グループ全体の与信管理・売上集計機能は将来拡張として検討
