# 機能設計書 68-従業員管理

## 概要

本ドキュメントは、AureusERPシステムにおける従業員管理機能の設計仕様を定義する。組織の従業員情報を包括的に管理するための人事マスタ管理機能である。

### 本機能の処理概要

従業員管理機能は、組織に所属する従業員の基本情報、勤務情報、個人情報、スキル・経歴情報を一元管理するための機能である。

**業務上の目的・背景**：人事管理において、従業員情報は組織運営の基盤となるデータである。給与計算、勤怠管理、スキル管理、組織編成など、多くの人事業務で従業員情報が参照される。本機能により、従業員の基本情報から勤務情報、個人情報まで包括的に管理し、人事業務の効率化と情報の一元管理を実現する。

**機能の利用シーン**：新入社員の登録、従業員情報の更新、退職処理、部門異動、スキル・経歴の登録など。

**主要な処理内容**：
1. 従業員（Employee）のCRUD操作
2. 基本情報（氏名、メール、電話）の管理
3. 勤務情報（部門、職位、勤務地、勤務時間）の管理
4. 個人情報（住所、緊急連絡先、証明書情報）の管理
5. スキル・経歴情報の管理
6. 上司・コーチの設定
7. パートナー情報との自動連携

**関連システム・外部連携**：パートナー管理（Partner）と自動連携、部門管理（Department）、職位管理（JobPosition）と連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-001 | EmployeeResource | 主画面 | 従業員一覧・CRUD操作 |
| SCR-EMP-002 | ManageResume | サブ画面 | 経歴管理 |
| SCR-EMP-003 | ManageSkill | サブ画面 | スキル管理 |
| SCR-EMP-004 | ViewEmployee | 詳細画面 | 従業員詳細表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 氏名 | 最大255文字 |
| job_title | string | No | 役職名 | 最大255文字 |
| avatar | file | No | アバター画像 | 画像形式 |
| work_email | string | No | 業務メール | メール形式 |
| work_phone | string | No | 業務電話 | - |
| mobile_phone | string | No | 携帯電話 | - |
| department_id | integer | No | 部門ID | 部門マスタに存在 |
| job_id | integer | No | 職位ID | 職位マスタに存在 |
| parent_id | integer | No | 上司ID | 従業員マスタに存在 |
| coach_id | integer | No | コーチID | 従業員マスタに存在 |
| company_id | integer | No | 会社ID | 会社マスタに存在 |
| work_location_id | integer | No | 勤務地ID | 勤務地マスタに存在 |
| address_id | integer | No | 勤務先住所ID | パートナーマスタに存在 |
| calendar_id | integer | No | 勤務カレンダーID | カレンダーマスタに存在 |
| time_zone | string | No | タイムゾーン | - |
| leave_manager_id | integer | No | 休暇承認者ID | ユーザーマスタに存在 |
| attendance_manager_id | integer | No | 勤怠承認者ID | ユーザーマスタに存在 |
| gender | enum | No | 性別 | male/female/other |
| birthday | date | No | 誕生日 | - |
| marital | enum | No | 婚姻状況 | single/married/divorced/widower |
| spouse_complete_name | string | No | 配偶者名 | - |
| spouse_birthdate | date | No | 配偶者誕生日 | - |
| children | integer | No | 子供の人数 | 0以上 |
| private_phone | string | No | 個人電話 | - |
| private_email | string | No | 個人メール | メール形式 |
| private_street1 | string | No | 住所1 | - |
| private_street2 | string | No | 住所2 | - |
| private_city | string | No | 市区町村 | - |
| private_zip | string | No | 郵便番号 | - |
| private_state_id | integer | No | 都道府県ID | - |
| private_country_id | integer | No | 国ID | - |
| emergency_contact | string | No | 緊急連絡先名 | - |
| emergency_phone | string | No | 緊急連絡先電話 | - |
| identification_id | string | No | 身分証番号 | - |
| passport_id | string | No | パスポート番号 | - |
| visa_no | string | No | ビザ番号 | - |
| visa_expire | date | No | ビザ有効期限 | - |
| work_permit | string | No | 労働許可証 | - |
| work_permit_expiration_date | date | No | 労働許可証有効期限 | - |
| certificate | string | No | 学歴証明 | - |
| study_field | string | No | 専攻分野 | - |
| study_school | string | No | 学校名 | - |
| is_active | boolean | No | 在籍フラグ | デフォルトtrue |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 従業員ID |
| name | string | 氏名 |
| job_title | string | 役職名 |
| work_email | string | 業務メール |
| work_phone | string | 業務電話 |
| mobile_phone | string | 携帯電話 |
| department | Department | 所属部門 |
| job | EmployeeJobPosition | 職位 |
| parent | Employee | 上司 |
| coach | Employee | コーチ |
| company | Company | 所属会社 |
| partner | Partner | 関連パートナー |
| skills | Collection | スキル一覧 |
| resumes | Collection | 経歴一覧 |
| categories | Collection | カテゴリタグ一覧 |
| is_active | boolean | 在籍フラグ |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（論理削除） |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（employees_employees）

## 処理フロー

### 処理シーケンス

```
1. 従業員一覧表示
   └─ employees_employeesテーブルからデータ取得
   └─ フィルタ・検索・グルーピングを適用
2. 従業員作成
   └─ バリデーション実行
   └─ employees_employeesにINSERT
   └─ パートナーレコードを自動生成（handlePartnerCreation）
3. 従業員編集
   └─ バリデーション実行
   └─ employees_employeesをUPDATE
   └─ パートナーレコードを自動更新（handlePartnerUpdation）
4. 従業員論理削除
   └─ deleted_atに現在日時を設定
5. 従業員復元
   └─ deleted_atをNULLに設定
6. 従業員完全削除
   └─ 関連データを先に削除
   └─ employees_employeesからレコードを物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[従業員一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F{削除種別}

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[DB保存]
    G -->|NG| I[エラー表示]

    H --> J{partner_id存在?}
    J -->|No| K[パートナー自動生成]
    J -->|Yes| L[パートナー自動更新]

    K --> M[終了]
    L --> M

    F -->|論理削除| N[deleted_at設定]
    F -->|完全削除| O[物理削除実行]

    C --> M
    I --> D
    N --> M
    O --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-068-001 | パートナー自動生成 | 従業員保存時にパートナーレコードが自動生成される | 新規従業員作成時 |
| BR-068-002 | パートナー自動更新 | 従業員情報変更時にパートナーレコードも自動更新 | 従業員編集時 |
| BR-068-003 | 上司設定 | parent_idで上司を設定、組織階層を表現 | 従業員編集時 |
| BR-068-004 | コーチ設定 | coach_idでコーチを設定、メンタリング関係を表現 | 従業員編集時 |
| BR-068-005 | 部門紐付け | department_idで部門に紐付け | 従業員作成・編集時 |
| BR-068-006 | 職位紐付け | job_idで職位に紐付け | 従業員作成・編集時 |

### 計算ロジック

パートナー自動生成/更新ロジック（bootメソッド内）：
- account_type: 'individual'固定
- sub_type: 'employee'固定
- name, email, job_title, phone, mobile, color, parent_id, company_id, user_idを従業員から転記

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 従業員作成 | employees_employees | INSERT | 新規従業員レコード挿入 |
| 従業員作成 | partners_partners | INSERT | パートナーレコード自動生成 |
| 従業員編集 | employees_employees | UPDATE | 従業員情報の更新 |
| 従業員編集 | partners_partners | UPDATE | パートナーレコード自動更新 |
| 従業員論理削除 | employees_employees | UPDATE | deleted_atの設定 |
| 従業員完全削除 | employees_employees | DELETE | レコードの物理削除 |
| スキル登録 | employees_employee_skills | INSERT | スキル情報の登録 |
| 経歴登録 | employees_employee_resumes | INSERT | 経歴情報の登録 |
| カテゴリ関連 | employees_employee_categories | INSERT | カテゴリタグの関連付け |

### テーブル別操作詳細

#### employees_employees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | job_title | 入力値 | - |
| INSERT | work_email | 入力値 | メール形式 |
| INSERT | work_phone | 入力値 | - |
| INSERT | mobile_phone | 入力値 | - |
| INSERT | department_id | 入力値 | 外部キー |
| INSERT | job_id | 入力値 | 外部キー |
| INSERT | parent_id | 入力値 | 自己参照外部キー |
| INSERT | coach_id | 入力値 | 自己参照外部キー |
| INSERT | company_id | 入力値 | 外部キー |
| INSERT | partner_id | 自動生成ID | パートナー自動生成後に設定 |
| INSERT | creator_id | ログインユーザーID | - |
| INSERT | is_active | 入力値 | デフォルトtrue |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除・復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-068-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-068-002 | 参照整合性エラー | 存在しない部門・職位を指定 | エラー通知 |
| E-068-003 | メール形式エラー | 不正なメールアドレス形式 | エラー通知 |
| E-068-004 | パートナー生成エラー | パートナー自動生成失敗 | エラー通知、ロールバック |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

従業員とパートナーの保存は単一トランザクション内で実行される。パートナー生成でエラーが発生した場合、従業員の保存もロールバックされる。

## パフォーマンス要件

- 従業員一覧取得：2秒以内
- 従業員保存処理：3秒以内
- 想定データ量：従業員数1,000件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）
- 個人情報（住所、緊急連絡先、証明書番号等）の適切なアクセス制御
- アバター画像のストレージアクセス制御

## 備考

- SoftDeletesトレイトによる論理削除機能を実装
- HasChatter, HasLogActivityトレイトによる活動ログ記録機能を実装
- HasCustomFieldsトレイトによるカスタムフィールド機能を実装
- EmployeeFactoryによるテストデータ生成が可能
- 従業員とパートナーは1:1で関連付けされ、情報が同期される
