# 機能設計書 69-部門管理

## 概要

本ドキュメントは、AureusERPシステムにおける部門管理機能の設計仕様を定義する。組織の部門構造を階層的に管理するためのマスタ管理機能である。

### 本機能の処理概要

部門管理機能は、組織の部門構造を定義・管理するための機能である。部門の階層構造、マネージャー、所属会社などを管理する。

**業務上の目的・背景**：組織運営において、部門構造は権限委譲、レポーティングライン、予算管理の基盤となる。本機能により、組織の部門構造を階層的に管理し、従業員の所属部門設定、組織図表示、部門別分析などに活用する。

**機能の利用シーン**：新規部門の作成、部門の統廃合、部門マネージャーの設定、子部門の追加など。

**主要な処理内容**：
1. 部門（Department）のCRUD操作
2. 部門階層構造の管理（parent_id）
3. 部門マネージャーの設定
4. 会社との紐付け
5. 完全名称（complete_name）の自動生成
6. 循環参照チェック
7. 部門配下の従業員管理

**関連システム・外部連携**：従業員管理（Employee）、職位管理（JobPosition）と連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-005 | DepartmentResource | 主画面 | 部門一覧・CRUD操作 |
| SCR-EMP-006 | ViewDepartment | 詳細画面 | 部門詳細・階層表示 |
| SCR-EMP-007 | ManageEmployee | サブ画面 | 部門配下の従業員管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 部門名 | 最大255文字 |
| parent_id | integer | No | 親部門ID | 自己参照禁止、循環参照禁止 |
| manager_id | integer | No | マネージャーID | 従業員マスタに存在 |
| company_id | integer | No | 会社ID | 会社マスタに存在 |
| color | string | No | 表示色 | HEXカラーコード |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 部門ID |
| name | string | 部門名 |
| complete_name | string | 完全名称（階層パス） |
| parent_path | string | 親パス（/区切り） |
| parent_id | integer | 親部門ID |
| master_department_id | integer | 最上位部門ID |
| manager_id | integer | マネージャーID |
| company_id | integer | 会社ID |
| color | string | 表示色 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（論理削除） |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（employees_departments）

## 処理フロー

### 処理シーケンス

```
1. 部門一覧表示
   └─ employees_departmentsテーブルからデータ取得
   └─ カード形式で表示
2. 部門作成
   └─ バリデーション実行
   └─ 循環参照チェック実行
   └─ parent_path、complete_name、master_department_idを自動計算
   └─ employees_departmentsにINSERT
3. 部門編集
   └─ バリデーション実行
   └─ 循環参照チェック実行
   └─ parent_path、complete_name、master_department_idを再計算
   └─ employees_departmentsをUPDATE
4. 部門論理削除
   └─ deleted_atに現在日時を設定
5. 部門復元
   └─ deleted_atをNULLに設定
6. 部門完全削除
   └─ 関連データを先に確認
   └─ employees_departmentsからレコードを物理削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[部門一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F{削除種別}

    D --> G[バリデーション]
    E --> G
    G -->|OK| H[循環参照チェック]
    G -->|NG| I[エラー表示]

    H -->|OK| J[パス・名称計算]
    H -->|NG| K[循環参照エラー]

    J --> L[DB保存]

    F -->|論理削除| M[deleted_at設定]
    F -->|完全削除| N[物理削除実行]

    C --> O[終了]
    L --> O
    I --> D
    K --> D
    M --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-069-001 | 循環参照禁止 | 部門の親子関係がループしてはならない | 部門作成・編集時 |
| BR-069-002 | 自己参照禁止 | parent_idに自身のIDを設定不可 | 部門編集時 |
| BR-069-003 | 完全名称自動生成 | complete_nameは親部門の名称を「 / 」で連結して自動生成 | 部門保存時 |
| BR-069-004 | 親パス自動計算 | parent_pathは「/親ID/」形式で自動計算 | 部門保存時 |
| BR-069-005 | 最上位部門自動設定 | master_department_idは最上位の親部門IDを自動設定 | 部門保存時 |

### 計算ロジック

**完全名称（complete_name）の計算**：
```
親部門名1 / 親部門名2 / ... / 自部門名
```

**親パス（parent_path）の計算**：
```
/親部門ID1/親部門ID2/.../
```
ルート部門の場合は「/」

**最上位部門（master_department_id）の計算**：
- 親部門を辿って最上位（parent_id=null）の部門IDを設定
- ルート部門の場合はnull

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 部門作成 | employees_departments | INSERT | 新規部門レコード挿入 |
| 部門編集 | employees_departments | UPDATE | 部門情報の更新 |
| 部門論理削除 | employees_departments | UPDATE | deleted_atの設定 |
| 部門完全削除 | employees_departments | DELETE | レコードの物理削除 |

### テーブル別操作詳細

#### employees_departments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | parent_id | 入力値 | 外部キー |
| INSERT | parent_path | 自動計算 | - |
| INSERT | complete_name | 自動計算 | - |
| INSERT | master_department_id | 自動計算 | - |
| INSERT | manager_id | 入力値 | 外部キー |
| INSERT | company_id | 入力値 | 外部キー |
| INSERT | color | 入力値 | HEXカラー |
| INSERT | creator_id | ログインユーザーID | - |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除・復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-069-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-069-002 | 循環参照エラー | 部門階層がループする | InvalidArgumentException例外、エラー通知 |
| E-069-003 | 自己参照エラー | parent_idに自身を設定 | エラー通知 |
| E-069-004 | 参照整合性エラー | 存在しない部門・従業員を指定 | エラー通知 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

部門の保存は単一トランザクション内で実行される。循環参照チェックはトランザクション開始前に実行される。

## パフォーマンス要件

- 部門一覧取得：1秒以内
- 部門保存処理：2秒以内
- 想定データ量：部門数100件程度、階層深度3〜5レベル

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）

## 備考

- SoftDeletesトレイトによる論理削除機能を実装
- HasChatter, HasLogActivityトレイトによる活動ログ記録機能を実装
- HasCustomFieldsトレイトによるカスタムフィールド機能を実装
- DepartmentFactoryによるテストデータ生成が可能
- bootメソッドで循環参照チェック・パス計算が自動実行される
- 詳細画面で階層ツリー表示機能あり（buildHierarchyTreeメソッド）
- 削除済み部門も選択肢に表示（「(Deleted)」サフィックス付き、選択不可）
