# 機能設計書: テーブルビュー管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F007 |
| 機能名 | テーブルビュー管理 |
| 機能概要 | テーブル一覧のフィルタ・ソート・グループ設定を保存・共有可能なビューとして管理する |
| 関連画面 | 各リソースの一覧画面（ビュー切り替えUI） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

テーブルビュー管理機能は、Filamentテーブルのフィルタ・ソート・検索・グループ設定を「ビュー」として保存し、再利用可能にする機能を提供する。ユーザーはプリセットビューまたは保存済みビューを切り替えて効率的にデータを閲覧できる。

#### 主な機能
1. **ビュー作成**: 現在のテーブル設定（フィルタ、ソート、検索、グループ）を保存
2. **ビュー編集**: 保存済みビューの名前・アイコン・色の変更
3. **ビュー削除**: 保存済みビューの削除
4. **ビュー適用**: 保存済みビューを適用してテーブル表示を切り替え
5. **お気に入り管理**: よく使うビューをお気に入りに追加
6. **公開/非公開設定**: ビューを他ユーザーと共有するか個人用にするか設定
7. **ビュー置き換え**: 現在のテーブル設定で既存ビューを上書き

### 2.2 処理フロー

#### ビュー作成フロー
```
[開始]
   |
   v
[テーブル一覧画面でフィルタ等を設定]
   |
   v
[ビュー作成ボタンクリック]
   |
   v
[ビュー設定モーダル表示]
   | - ビュー名入力
   | - アイコン選択
   | - 色選択
   | - 公開設定
   |
   v
[現在のテーブル設定を取得]
   | - tableFilters
   | - tableGrouping
   | - tableSearch
   | - tableColumnSearches
   | - tableSort
   | - tableRecordsPerPage
   |
   v
[table_viewsテーブルにレコード作成]
   |
   v
[ビュータブに新規ビュー追加表示]
   |
   v
[終了]
```

#### ビュー適用フロー
```
[開始]
   |
   v
[ビュータブからビュー選択]
   |
   v
[テーブル設定リセット]
   |
   v
[ビューのfilters設定を取得]
   |
   v
[各設定を適用]
   | - tableFilters
   | - tableGrouping
   | - tableSearch
   | - tableSort
   | - tableRecordsPerPage
   |
   v
[テーブル再描画]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| name | string | YES | max:255 | ビュー名 |
| icon | string | NO | heroicon_name | アイコン名 |
| color | string | NO | - | テーマカラー |
| is_public | boolean | NO | - | 公開フラグ |
| filters | object | YES | - | テーブル設定（自動取得） |
| filterable_type | string | YES | - | 対象リソースクラス名（自動設定） |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | ビューID |
| name | string | ビュー名 |
| icon | string | アイコン名 |
| color | string | テーマカラー |
| is_public | boolean | 公開フラグ |
| filters | object | 保存されたテーブル設定 |
| filterable_type | string | 対象リソースクラス名 |
| user_id | integer | 作成者ユーザーID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 2.5 filters オブジェクト構造

| キー | 型 | 説明 |
|------|-----|------|
| tableFilters | object | フィルタ設定 |
| tableGrouping | string | グループ化カラム |
| tableSearch | string | 検索文字列 |
| tableColumnSearches | object | カラム別検索設定 |
| tableSort | object | ソート設定 |
| tableRecordsPerPage | integer | 1ページあたりの表示件数 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | ユーザー所有ビュー | 保存済みビューは作成者ユーザーに紐付く |
| BR-002 | 公開ビュー | is_public=trueのビューは全ユーザーに表示 |
| BR-003 | デフォルトビュー | 「default」ビューは常に存在しリセット用に使用 |
| BR-004 | お気に入り管理 | ユーザーごとにお気に入りビューを管理 |
| BR-005 | 変更検知 | アクティブビューからの設定変更を検知して表示 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| table_views | ビュー情報管理 | SELECT, INSERT, UPDATE, DELETE |
| table_view_favorites | お気に入り管理 | SELECT, INSERT, UPDATE, DELETE |
| users | ユーザー情報参照 | SELECT |

### 4.2 テーブル定義（table_views）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| name | varchar(255) | NO | - | ビュー名 |
| icon | varchar(100) | YES | NULL | アイコン名 |
| color | varchar(50) | YES | NULL | テーマカラー |
| is_public | boolean | NO | false | 公開フラグ |
| filters | json | YES | NULL | テーブル設定 |
| filterable_type | varchar(255) | NO | - | 対象リソースクラス名 |
| user_id | bigint | NO | - | 作成者ユーザーID（FK） |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

### 4.3 テーブル定義（table_view_favorites）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| view_type | varchar(50) | NO | - | ビュータイプ（preset/saved） |
| view_key | varchar(255) | NO | - | ビューキー |
| filterable_type | varchar(255) | NO | - | 対象リソースクラス名 |
| user_id | bigint | NO | - | ユーザーID（FK） |
| is_favorite | boolean | NO | false | お気に入りフラグ |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| HasTableViews | plugins/webkul/table-views/src/Filament/Concerns/HasTableViews.php | テーブルビュー機能トレイト |
| TableView | plugins/webkul/table-views/src/Models/TableView.php | ビューモデル |
| TableViewFavorite | plugins/webkul/table-views/src/Models/TableViewFavorite.php | お気に入りモデル |
| CreateViewAction | plugins/webkul/table-views/src/Filament/Actions/CreateViewAction.php | ビュー作成アクション |
| EditViewAction | plugins/webkul/table-views/src/Filament/Actions/EditViewAction.php | ビュー編集アクション |
| PresetView | plugins/webkul/table-views/src/Filament/Components/PresetView.php | プリセットビューコンポーネント |
| SavedView | plugins/webkul/table-views/src/Filament/Components/SavedView.php | 保存済みビューコンポーネント |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/table-views | 必須（テーブルビュー基盤） |
| webkul/security | 必須（ユーザー管理） |
| filament/filament | 必須（管理画面UI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 操作 | 条件 |
|------|------|
| ビュー閲覧 | 自分のビューまたは公開ビュー |
| ビュー作成 | ログインユーザー |
| ビュー編集 | 自分が作成したビューのみ |
| ビュー削除 | 自分が作成したビューのみ |

### 6.2 セキュリティ考慮事項

- ビューのfiltersにはフィルタ条件のみ保存（データ本体は含まない）
- 公開ビューでも表示データはユーザー権限に従う

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| ビュー読み込み速度 | 500ms以内 |
| ビュー切り替え応答時間 | 1秒以内 |
| キャッシュ | ビュー一覧をキャッシュ |

### 7.2 可用性

- ビュー設定のバリデーション
- 不正設定時のフォールバック

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| VIEW-001 | ビュー作成失敗 | エラー通知表示 |
| VIEW-002 | 存在しないビュー適用 | デフォルトビューにフォールバック |
| VIEW-003 | フィルタ設定適用エラー | 該当フィルタをスキップ |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | ビュー作成 | 現在の設定でビューが作成できること |
| T-002 | ビュー適用 | 保存済みビューで設定が復元されること |
| T-003 | ビュー編集 | ビュー名等が更新できること |
| T-004 | ビュー削除 | ビューが削除されること |
| T-005 | 公開設定 | 公開ビューが他ユーザーに表示されること |
| T-006 | お気に入り | お気に入り追加・削除ができること |
| T-007 | ビュー置き換え | 既存ビューを現在設定で上書きできること |
| T-008 | リセット | デフォルトビューで設定がリセットされること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
