# 機能設計書 70-職位管理

## 概要

本ドキュメントは、AureusERPシステムにおける職位管理機能の設計仕様を定義する。組織内の職位（ジョブポジション）を管理するためのマスタ管理機能である。

### 本機能の処理概要

職位管理機能は、組織内で定義される職位（エンジニア、マネージャー、セールス担当など）を管理するための機能である。

**業務上の目的・背景**：人事管理において、職位は従業員の役割、責任、給与体系の基盤となる。採用計画、人員配置、キャリアパス設計などで職位情報が活用される。本機能により、組織の職位を一元管理し、従業員への職位割り当て、採用目標管理などに活用する。

**機能の利用シーン**：新規職位の作成、職位の有効/無効切り替え、採用目標の設定、職務記述書の管理など。

**主要な処理内容**：
1. 職位（EmployeeJobPosition）のCRUD操作
2. 部門・会社との紐付け
3. 職務記述・要件の管理
4. 採用目標人数の設定
5. 雇用タイプ（正社員、契約社員等）との紐付け
6. 有効/無効フラグの管理
7. 表示順序の管理

**関連システム・外部連携**：従業員管理（Employee）、部門管理（Department）と連携。採用管理モジュールと連携。

**権限による制御**：Filament Shieldによる権限管理が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-008 | JobPositionResource | 主画面 | 職位一覧・CRUD操作 |
| SCR-EMP-009 | ViewJobPosition | 詳細画面 | 職位詳細表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 職位名 | 最大255文字 |
| department_id | integer | No | 部門ID | 部門マスタに存在 |
| company_id | integer | No | 会社ID | 会社マスタに存在 |
| employment_type_id | integer | No | 雇用タイプID | 雇用タイプマスタに存在 |
| description | text | No | 職務記述 | リッチテキスト |
| requirements | text | No | 要件 | リッチテキスト |
| no_of_recruitment | integer | No | 採用目標人数 | 0以上、最大99999999999 |
| is_active | boolean | No | 有効フラグ | デフォルトtrue |
| sort | integer | No | 表示順 | 自動設定 |

### 入力データソース

画面入力（Filament管理画面のフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 職位ID |
| name | string | 職位名 |
| department_id | integer | 部門ID |
| company_id | integer | 会社ID |
| employment_type_id | integer | 雇用タイプID |
| description | text | 職務記述 |
| requirements | text | 要件 |
| no_of_recruitment | integer | 採用目標人数 |
| no_of_employee | integer | 現在の従業員数（計算値） |
| expected_employees | integer | 予想従業員数（計算値） |
| is_active | boolean | 有効フラグ |
| sort | integer | 表示順 |
| creator_id | integer | 作成者ID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（論理削除） |

### 出力先

- 画面表示（一覧・詳細画面）
- DBテーブル（employees_job_positions）

## 処理フロー

### 処理シーケンス

```
1. 職位一覧表示
   └─ employees_job_positionsテーブルからデータ取得
   └─ ソート順に表示
2. 職位作成
   └─ バリデーション実行
   └─ employees_job_positionsにINSERT
   └─ ソート値自動設定
3. 職位編集
   └─ バリデーション実行
   └─ employees_job_positionsをUPDATE
4. 職位論理削除
   └─ deleted_atに現在日時を設定
5. 職位復元
   └─ deleted_atをNULLに設定
6. 職位完全削除
   └─ 使用中チェック
   └─ employees_job_positionsからレコードを物理削除
7. 並び替え
   └─ sort値を更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[職位一覧取得]
    B -->|作成| D[入力フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|削除| F{削除種別}
    B -->|並び替え| G[ソート更新]

    D --> H[バリデーション]
    E --> H
    H -->|OK| I[DB保存]
    H -->|NG| J[エラー表示]

    F -->|論理削除| K[deleted_at設定]
    F -->|完全削除| L{使用中チェック}
    L -->|使用中| M[削除エラー]
    L -->|未使用| N[物理削除実行]

    C --> O[終了]
    I --> O
    J --> D
    K --> O
    M --> O
    N --> O
    G --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-070-001 | 有効フラグ | is_activeがtrueの職位のみ従業員に割り当て可能 | 従業員職位設定時 |
| BR-070-002 | 部門連動 | 部門選択時に会社が未設定なら部門の会社を自動設定 | 部門選択時 |
| BR-070-003 | ソート自動設定 | sort値は作成時に自動で最後尾に設定 | 職位作成時 |
| BR-070-004 | 採用目標デフォルト | no_of_recruitmentのデフォルト値は0 | 職位作成時 |
| BR-070-005 | 使用中削除禁止 | 従業員が割り当てられている職位は完全削除不可 | 職位完全削除時 |

### 計算ロジック

**現在の従業員数（no_of_employee）**：
- employeesリレーションのカウント

**予想従業員数（expected_employees）**：
- 現在の従業員数 + 採用目標人数

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 職位作成 | employees_job_positions | INSERT | 新規職位レコード挿入 |
| 職位編集 | employees_job_positions | UPDATE | 職位情報の更新 |
| 職位論理削除 | employees_job_positions | UPDATE | deleted_atの設定 |
| 職位完全削除 | employees_job_positions | DELETE | レコードの物理削除 |
| 並び替え | employees_job_positions | UPDATE | sort値の更新 |

### テーブル別操作詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | department_id | 入力値 | 外部キー |
| INSERT | company_id | 入力値/部門から継承 | 外部キー |
| INSERT | employment_type_id | 入力値 | 外部キー |
| INSERT | description | 入力値 | リッチテキスト |
| INSERT | requirements | 入力値 | リッチテキスト |
| INSERT | no_of_recruitment | 入力値 | デフォルト0 |
| INSERT | is_active | 入力値 | デフォルトtrue |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | creator_id | ログインユーザーID | - |
| UPDATE | deleted_at | 現在日時/NULL | 論理削除・復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-070-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E-070-002 | 参照整合性エラー | 存在しない部門・会社を指定 | エラー通知 |
| E-070-003 | 削除エラー | 使用中の職位を完全削除 | 使用中の旨を通知、削除中止 |

### リトライ仕様

データベースエラー発生時は処理を中止し、ユーザーに通知する。自動リトライは行わない。

## トランザクション仕様

職位の保存は単一トランザクション内で実行される。

## パフォーマンス要件

- 職位一覧取得：1秒以内
- 職位保存処理：2秒以内
- 想定データ量：職位数50件程度

## セキュリティ考慮事項

- Filament Shieldによるロールベースアクセス制御
- CSRF対策（Laravelデフォルト）
- 入力値のサニタイズ・バリデーション
- SQLインジェクション対策（Eloquent ORM使用）
- リッチテキストエディタのXSS対策

## 備考

- SoftDeletesトレイトによる論理削除機能を実装
- SortableTraitによるドラッグ&ドロップ並び替え機能を実装
- HasCustomFieldsトレイトによるカスタムフィールド機能を実装
- EmployeeJobPositionFactoryによるテストデータ生成が可能
- ConfigurationsクラスタのサブリソースとしてJobPositionResourceが配置
- 部門選択時に会社を自動設定するafterStateUpdated処理あり
- 削除済み項目は選択肢に表示されるが選択不可（(Deleted)サフィックス）
