# 機能設計書 F071-スキルタイプ管理

## 概要

本ドキュメントは、AureusERPの人事管理モジュールにおけるスキルタイプ管理機能の詳細設計を記述します。スキルタイプは、従業員が保有するスキルを分類・管理するためのマスタデータです。

### 本機能の処理概要

スキルタイプ管理機能は、組織における従業員スキルの分類体系を定義・維持するための機能です。

**業務上の目的・背景**：企業における人材管理において、従業員のスキルを体系的に把握することは重要です。スキルタイプを定義することで、技術スキル、ソフトスキル、資格・認定など、スキルをカテゴリ別に分類し、人材配置や育成計画の策定に活用できます。

**機能の利用シーン**：人事担当者が新しいスキル分類を追加する際、既存のスキル分類を更新する際、または組織のスキル体系を見直す際に利用されます。また、採用活動において求められるスキルセットの定義にも活用されます。

**主要な処理内容**：
1. スキルタイプの一覧表示・検索・フィルタリング
2. 新規スキルタイプの作成（名前、色、有効/無効状態）
3. 既存スキルタイプの編集・更新
4. スキルタイプの削除（論理削除）・復元
5. スキルタイプに紐づくスキル・スキルレベルの管理

**関連システム・外部連携**：従業員管理（EmployeeResource）、採用管理（RecruitmentResource）と連携し、スキル情報の参照元として機能します。

**権限による制御**：管理者権限を持つユーザーのみがスキルタイプの作成・編集・削除が可能です。一般ユーザーは閲覧のみ可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-EMP-004 | SkillTypeResource | 主画面 | スキルタイプのCRUD操作 |
| SCR-EMP-001 | EmployeeResource | 参照画面 | 従業員スキル情報の参照 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | スキルタイプ名 | 最大255文字、ユニーク制約 |
| color | string | No | 表示色（Tailwind CSSカラー） | Colors Enumの値 |
| is_active | boolean | No | 有効/無効フラグ | デフォルト: true |
| creator_id | integer | Yes | 作成者ID | 認証ユーザーIDが自動設定 |

### 入力データソース

画面フォーム入力（Filament Form）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | スキルタイプID |
| name | string | スキルタイプ名 |
| color | string | 表示色 |
| is_active | boolean | 有効/無効状態 |
| skills | array | 紐づくスキル一覧 |
| skillLevels | array | 紐づくスキルレベル一覧 |
| createdBy | object | 作成者情報 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

画面表示（Filament Table/Infolist）、データベーステーブル（employees_skill_types）

## 処理フロー

### 処理シーケンス

```
1. ユーザー認証確認
   └─ 未認証の場合はログイン画面へリダイレクト
2. 権限チェック
   └─ スキルタイプ管理権限の有無を確認
3. 一覧表示処理
   └─ フィルタ・ソート条件に基づきデータ取得
4. CRUD操作
   └─ 作成：バリデーション → 保存 → 通知
   └─ 更新：存在確認 → バリデーション → 保存 → 通知
   └─ 削除：存在確認 → 論理削除 → 通知
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証済み?}
    B -->|No| C[ログイン画面へ]
    B -->|Yes| D{権限確認}
    D -->|権限なし| E[403エラー]
    D -->|権限あり| F[一覧表示]
    F --> G{操作選択}
    G -->|作成| H[入力フォーム表示]
    G -->|編集| I[編集フォーム表示]
    G -->|削除| J[削除確認]
    G -->|表示| K[詳細表示]
    H --> L{バリデーション}
    I --> L
    L -->|OK| M[DB保存]
    L -->|NG| N[エラー表示]
    M --> O[成功通知]
    J --> P[論理削除]
    P --> O
    O --> F
    K --> F
    N --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-071-01 | 名前一意性 | スキルタイプ名は重複不可 | 新規作成・更新時 |
| BR-071-02 | 論理削除 | 削除時は論理削除（SoftDeletes） | 削除操作時 |
| BR-071-03 | 作成者自動設定 | 作成者は認証ユーザーが自動設定 | 新規作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | employees_skill_types | SELECT | スキルタイプ一覧の取得 |
| 詳細取得 | employees_skill_types | SELECT | 単一スキルタイプの取得 |
| 作成 | employees_skill_types | INSERT | 新規スキルタイプの登録 |
| 更新 | employees_skill_types | UPDATE | スキルタイプ情報の更新 |
| 削除 | employees_skill_types | UPDATE | 論理削除（deleted_at更新） |
| 復元 | employees_skill_types | UPDATE | 復元（deleted_at = NULL） |

### テーブル別操作詳細

#### employees_skill_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | color | ユーザー選択値 | 任意 |
| INSERT | is_active | ユーザー選択値（デフォルト: true） | |
| INSERT | creator_id | 認証ユーザーID | 自動設定 |
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-071-01 | バリデーションエラー | 名前未入力または重複 | エラーメッセージ表示 |
| E-071-02 | 認証エラー | 未ログイン状態 | ログイン画面へリダイレクト |
| E-071-03 | 権限エラー | 操作権限なし | 403エラーページ表示 |
| E-071-04 | 存在エラー | 対象レコード不存在 | 404エラーページ表示 |

### リトライ仕様

データベース接続エラー時は自動リトライ（Laravel標準機能）

## トランザクション仕様

単一テーブル操作のため、個別操作ごとのトランザクション管理（Laravel Eloquent標準）

## パフォーマンス要件

- 一覧取得：1秒以内
- 単一操作（CRUD）：500ms以内
- ページネーション：15件/ページ

## セキュリティ考慮事項

- 認証必須（Filament認証）
- CSRF対策（Laravel標準）
- XSS対策（Blade自動エスケープ）
- 権限制御（Filament Shield）

## 備考

- Filament v3を使用したリソース管理
- SoftDeletesトレイトによる論理削除対応
- HasCustomFieldsトレイトによるカスタムフィールド拡張対応
